/*
 * Decompiled with CFR 0.152.
 */
package de.labathome;

public class Interval
implements Comparable<Interval> {
    private double integralValue = 0.0;
    private double errorEstimate = Double.POSITIVE_INFINITY;
    private double center;
    private double halfWidth;

    public Interval(double center, double halfWidth) {
        this.center = center;
        this.halfWidth = halfWidth;
    }

    public Interval cutInHalf() {
        this.halfWidth /= 2.0;
        Interval otherHalf = new Interval(this.center + this.halfWidth, this.halfWidth);
        this.center -= this.halfWidth;
        return otherHalf;
    }

    public void setIntegralValue(double integralValue) {
        this.integralValue = integralValue;
    }

    public void setErrorEstimate(double errorEstimate) {
        this.errorEstimate = errorEstimate;
    }

    public double getIntegralValue() {
        return this.integralValue;
    }

    public double getErrorEstimate() {
        return this.errorEstimate;
    }

    public double getCenter() {
        return this.center;
    }

    public double getHalfWidth() {
        return this.halfWidth;
    }

    @Override
    public int compareTo(Interval other) {
        if (this.errorEstimate == other.errorEstimate) {
            return 0;
        }
        return this.errorEstimate < other.errorEstimate ? 1 : -1;
    }
}

