/*
 * Decompiled with CFR 0.152.
 */
package de.labathome;

import de.labathome.Interval;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.UnaryOperator;

public class GaussKronrod {
    private static final double DBL_EPSILON = Math.ulp(1.0);
    public static final int NUM_GAUSS_POINTS = 7;
    public static final int NUM_KRONROD_POINTS = 15;
    public static double[] P_GK_7_15 = new double[]{0.20778495500789848, 0.4058451513773972, 0.5860872354676911, 0.7415311855993945, 0.8648644233597691, 0.9491079123427585, 0.9914553711208126};
    public static double[] W_GAUSS = new double[]{0.4179591836734694, 0.3818300505051189, 0.27970539148927664, 0.1294849661688697};
    public static double[] W_KRNRD = new double[]{0.20948214108472782, 0.20443294007529889, 0.19035057806478542, 0.1690047266392679, 0.14065325971552592, 0.10479001032225019, 0.06309209262997856, 0.022935322010529224};

    public static void evalGaussKronrod(UnaryOperator<double[]> integrand, List<Interval> intervals, AtomicBoolean gracefulStop) {
        int intervalStartIdx;
        double halfWidth;
        int numIntervals = intervals.size();
        double[] evaluationLocations = new double[numIntervals * 15];
        for (int i = 0; i < numIntervals; ++i) {
            int j;
            Interval interval = intervals.get(i);
            double center = interval.getCenter();
            halfWidth = interval.getHalfWidth();
            intervalStartIdx = i * 15;
            evaluationLocations[intervalStartIdx] = center;
            for (j = 1; j < 7; j += 2) {
                evaluationLocations[intervalStartIdx + j] = center - halfWidth * P_GK_7_15[j];
                evaluationLocations[intervalStartIdx + j + 1] = center + halfWidth * P_GK_7_15[j];
            }
            for (j = 0; j < 7; j += 2) {
                evaluationLocations[intervalStartIdx + 7 + j] = center - halfWidth * P_GK_7_15[j];
                evaluationLocations[intervalStartIdx + 7 + j + 1] = center + halfWidth * P_GK_7_15[j];
            }
        }
        double[] functionValues = (double[])integrand.apply(evaluationLocations);
        if (gracefulStop.get()) {
            return;
        }
        for (int i = 0; i < numIntervals; ++i) {
            double min_err;
            double kVal2;
            double kVal1;
            int j;
            Interval interval = intervals.get(i);
            halfWidth = interval.getHalfWidth();
            intervalStartIdx = i * 15;
            double resultGauss = functionValues[intervalStartIdx] * W_GAUSS[0];
            double resultKrnrd = functionValues[intervalStartIdx] * W_KRNRD[0];
            double resultAbs = Math.abs(resultKrnrd);
            for (j = 1; j <= 3; ++j) {
                double gVal = (functionValues[intervalStartIdx + 2 * j - 1] + functionValues[intervalStartIdx + 2 * j]) * W_GAUSS[j];
                kVal1 = functionValues[intervalStartIdx + 2 * j - 1] * W_KRNRD[2 * j];
                kVal2 = functionValues[intervalStartIdx + 2 * j] * W_KRNRD[2 * j];
                resultGauss += gVal;
                resultKrnrd += kVal1 + kVal2;
                resultAbs += Math.abs(kVal1) + Math.abs(kVal2);
            }
            for (j = 0; j <= 3; ++j) {
                kVal1 = functionValues[intervalStartIdx + 7 + 2 * j] * W_KRNRD[2 * j + 1];
                kVal2 = functionValues[intervalStartIdx + 7 + 2 * j + 1] * W_KRNRD[2 * j + 1];
                resultKrnrd += kVal1 + kVal2;
                resultAbs += Math.abs(kVal1) + Math.abs(kVal2);
            }
            resultAbs *= halfWidth;
            interval.setIntegralValue(resultKrnrd * halfWidth);
            double errorEstimate = Math.abs(resultKrnrd - resultGauss) * halfWidth;
            double mean = resultKrnrd * 0.5;
            double resultResidual = Math.abs(functionValues[intervalStartIdx] - mean) * W_KRNRD[0];
            for (j = 1; j <= 3; ++j) {
                kVal1 = Math.abs(functionValues[intervalStartIdx + 2 * j - 1] - mean) * W_KRNRD[2 * j];
                kVal2 = Math.abs(functionValues[intervalStartIdx + 2 * j] - mean) * W_KRNRD[2 * j];
                resultResidual += kVal1 + kVal2;
            }
            for (j = 0; j <= 3; ++j) {
                kVal1 = Math.abs(functionValues[intervalStartIdx + 7 + 2 * j] - mean) * W_KRNRD[2 * j + 1];
                kVal2 = Math.abs(functionValues[intervalStartIdx + 7 + 2 * j + 1] - mean) * W_KRNRD[2 * j + 1];
                resultResidual += kVal1 + kVal2;
            }
            if ((resultResidual *= halfWidth) != 0.0 && errorEstimate != 0.0) {
                double scale = Math.pow(200.0 * errorEstimate / resultResidual, 1.5);
                double d = errorEstimate = scale < 1.0 ? resultResidual * scale : resultResidual;
            }
            if (resultAbs > Double.MIN_NORMAL / (50.0 * DBL_EPSILON) && (min_err = 50.0 * DBL_EPSILON * resultAbs) > errorEstimate) {
                errorEstimate = min_err;
            }
            interval.setErrorEstimate(errorEstimate);
        }
    }
}

