/*
 * Decompiled with CFR 0.152.
 */
package de.labathome;

import de.labathome.GaussKronrod;
import de.labathome.Interval;
import de.labathome.IntervalHeap;
import de.labathome.RescaledIntegrand;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.UnaryOperator;

public class AdaptiveQuadrature {
    public static double[] integrate(UnaryOperator<double[]> integrand, double lowerBound, double upperBound, double relTol, double absTol, int maxEval) {
        AtomicBoolean gracefulStop = new AtomicBoolean(false);
        return AdaptiveQuadrature.integrate(integrand, lowerBound, upperBound, relTol, absTol, maxEval, gracefulStop);
    }

    public static double[] integrate(UnaryOperator<double[]> integrand, double lowerBound, double upperBound, double relTol, double absTol, int maxEval, AtomicBoolean gracefulStop) {
        boolean boundsReversed;
        if (Double.isNaN(lowerBound)) {
            throw new RuntimeException("lower bound must not be NaN");
        }
        if (Double.isNaN(upperBound)) {
            throw new RuntimeException("upper bound must not be NaN");
        }
        if (lowerBound == upperBound) {
            if (Double.isInfinite(lowerBound)) {
                throw new RuntimeException("integral from " + lowerBound + " to " + upperBound + " is not supported");
            }
            return new double[]{0.0, 0.0};
        }
        boolean bl = boundsReversed = lowerBound > upperBound;
        if (boundsReversed) {
            double temp = upperBound;
            upperBound = lowerBound;
            lowerBound = temp;
        }
        RescaledIntegrand rescaledIntegrand = new RescaledIntegrand(integrand, lowerBound, upperBound, gracefulStop);
        double scaledLowerBound = rescaledIntegrand.getScaledLowerBound();
        double scaledUpperBound = rescaledIntegrand.getScaledUpperBound();
        double center = (scaledUpperBound + scaledLowerBound) / 2.0;
        double halfWidth = (scaledUpperBound - scaledLowerBound) / 2.0;
        Interval rootInterval = new Interval(center, halfWidth);
        ArrayList<Interval> intervalsToEval = new ArrayList<Interval>();
        intervalsToEval.add(rootInterval);
        GaussKronrod.evalGaussKronrod(rescaledIntegrand, intervalsToEval, gracefulStop);
        if (gracefulStop.get()) {
            return null;
        }
        IntervalHeap intervalHeap = new IntervalHeap();
        intervalHeap.add((Interval)intervalsToEval.get(0));
        int numEval = 15;
        boolean converged = true;
        double result = intervalHeap.getIntegralValue();
        double errorEstimate = intervalHeap.getErrorEstimate();
        while (maxEval == 0 || numEval < maxEval) {
            result = intervalHeap.getIntegralValue();
            errorEstimate = intervalHeap.getErrorEstimate();
            converged = false;
            if (!Double.isNaN(absTol)) {
                converged |= errorEstimate < absTol;
            }
            if (!Double.isNaN(relTol)) {
                converged |= errorEstimate < Math.abs(result) * relTol;
            }
            if (converged) break;
            intervalsToEval.clear();
            do {
                Interval worstInterval = intervalHeap.poll();
                errorEstimate -= worstInterval.getErrorEstimate();
                Interval halfOfWorst = worstInterval.cutInHalf();
                intervalsToEval.add(worstInterval);
                intervalsToEval.add(halfOfWorst);
                numEval += 30;
                converged = false;
                if (!Double.isNaN(absTol)) {
                    converged |= errorEstimate < absTol;
                }
                if (Double.isNaN(relTol)) continue;
                converged |= errorEstimate < Math.abs(result) * relTol;
            } while (intervalHeap.size() > 0 && (numEval < maxEval || maxEval == 0) && !converged);
            GaussKronrod.evalGaussKronrod(rescaledIntegrand, intervalsToEval, gracefulStop);
            if (gracefulStop.get()) {
                return null;
            }
            for (Interval interval : intervalsToEval) {
                intervalHeap.add(interval);
            }
        }
        if (!converged) {
            System.out.println("did not converge after " + numEval + " function evaluations!");
        }
        result = 0.0;
        errorEstimate = 0.0;
        for (Interval interval : intervalHeap) {
            result += interval.getIntegralValue();
            errorEstimate += interval.getErrorEstimate();
        }
        if (boundsReversed) {
            return new double[]{-result, errorEstimate};
        }
        return new double[]{result, errorEstimate};
    }
}

