/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.iiif.model.search;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Lists;
import de.digitalcollections.iiif.model.search.Term;
import java.net.URI;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class TermList {
    public static final String CONTEXT = "http://iiif.io/api/search/1/context.json";
    public static final String TYPE = "search:TermList";
    @JsonProperty(value="@id")
    private final URI identifier;
    private Set<String> ignored;
    private List<Term> terms;

    @JsonCreator
    public TermList(@JsonProperty(value="@id") String identifier) {
        this.identifier = URI.create(identifier);
    }

    @JsonProperty(value="@context")
    private String getContext() {
        return CONTEXT;
    }

    @JsonProperty(value="@type")
    private String getType() {
        return TYPE;
    }

    public URI getIdentifier() {
        return this.identifier;
    }

    public Set<String> getIgnored() {
        return this.ignored;
    }

    public void setIgnored(Set<String> ignored) {
        this.ignored = ignored;
    }

    public TermList addIgnored(String first, String ... rest) {
        if (this.ignored == null) {
            this.ignored = new LinkedHashSet<String>();
        }
        this.ignored.addAll(Lists.asList((Object)first, (Object[])rest));
        return this;
    }

    public List<Term> getTerms() {
        return this.terms;
    }

    public void setTerms(List<Term> terms) {
        this.terms = terms;
    }

    public TermList addTerm(Term first, Term ... rest) {
        if (this.terms == null) {
            this.terms = new ArrayList<Term>();
        }
        this.terms.addAll(Lists.asList((Object)first, (Object[])rest));
        return this;
    }
}

