/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.iiif.model.search;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import de.digitalcollections.iiif.model.PropertyValue;
import java.net.URI;

public class Term {
    private URI url;
    private String match;
    private Integer count;
    private PropertyValue label;

    @JsonCreator
    public Term(@JsonProperty(value="url") URI url, @JsonProperty(value="match") String match) {
        this.url = url;
        this.match = match;
    }

    public Term(String url, String match, Integer count) {
        this(URI.create(url), match);
        this.count = count;
    }

    public Term(String url, String match, Integer count, String label) {
        this(URI.create(url), match);
        this.count = count;
        this.label = new PropertyValue(label, new String[0]);
    }

    public URI getUrl() {
        return this.url;
    }

    public String getMatch() {
        return this.match;
    }

    public Integer getCount() {
        return this.count;
    }

    public PropertyValue getLabel() {
        return this.label;
    }

    public void setLabel(PropertyValue label) {
        this.label = label;
    }

    @JsonIgnore
    public String getLabelString() {
        return this.label.getFirstValue();
    }
}

