/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.iiif.model.jackson.serialization;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import de.digitalcollections.iiif.model.ModelUtilities;
import de.digitalcollections.iiif.model.Profile;
import de.digitalcollections.iiif.model.image.ImageApiProfile;
import java.io.IOException;

public class ProfileSerializer
extends JsonSerializer<Profile> {
    private final JsonSerializer<Object> defaultSerializer;

    public ProfileSerializer(JsonSerializer<Object> defaultSerializer) {
        this.defaultSerializer = defaultSerializer;
    }

    public void serialize(Profile value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
        ModelUtilities.Completeness completeness = ModelUtilities.getCompleteness(value, Profile.class);
        if (completeness == ModelUtilities.Completeness.ID_ONLY || value instanceof ImageApiProfile && completeness == ModelUtilities.Completeness.ID_AND_TYPE) {
            gen.writeString(value.getIdentifier().toString());
        } else {
            this.defaultSerializer.serialize((Object)value, gen, serializers);
        }
    }
}

