/*
 * Decompiled with CFR 0.152.
 */
package com.xugu.cloudjdbc.rowset;

import com.xugu.cloudjdbc.Driver;
import com.xugu.cloudjdbc.Error;
import com.xugu.cloudjdbc.ResultSet;
import com.xugu.cloudjdbc.rowset.RowSetMetaDataImpl;
import com.xugu.common.ReplaceEnum;
import com.xugu.common.SQLCommon;
import com.xugu.pool.XgDataSource;
import java.io.InputStream;
import java.io.Reader;
import java.io.Serializable;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import javax.sql.RowSet;
import javax.sql.RowSetEvent;
import javax.sql.RowSetListener;
import javax.sql.RowSetMetaData;
import javax.sql.rowset.Joinable;

public class RowSetImpl
implements RowSet,
Joinable,
Serializable {
    protected Connection rowsetConnection;
    protected CallableStatement rowCstm;
    protected java.sql.ResultSet innerRS;
    protected RowSetEvent event;
    protected String command;
    protected String url;
    protected String username;
    protected String password;
    protected Properties props;
    protected int rowsetType;
    protected int concurrency;
    protected int maxFieldSize;
    protected int maxRows;
    protected int queryTimeout;
    protected int fetchSize;
    protected boolean readOnly;
    protected int fetchDirection;
    protected boolean isClosed;
    protected Vector<RowSetListener> eventListener;
    protected RowSetMetaData rowRsmd;
    protected String dataSourceName;
    protected boolean driverloaded;

    public RowSetImpl() {
        this.commonInit();
    }

    public RowSetImpl(Connection initConn) {
        this.commonInit();
        this.rowsetConnection = initConn;
    }

    private void commonInit() {
        this.command = null;
        this.concurrency = 1007;
        this.fetchDirection = 1000;
        this.rowsetType = 1003;
        this.readOnly = true;
        this.event = new RowSetEvent(this);
        this.eventListener = new Vector();
    }

    @Override
    public boolean absolute(int row) throws SQLException {
        this.checkRowSetClosed();
        this.checkRowIndexType(row);
        boolean moved = false;
        if (this.innerRS != null && (moved = this.innerRS.absolute(row))) {
            this.notifyCursorMoved();
        }
        return moved;
    }

    @Override
    public void afterLast() throws SQLException {
        this.checkRowSetClosed();
        if (this.innerRS != null) {
            this.innerRS.afterLast();
            this.notifyCursorMoved();
        }
    }

    @Override
    public void beforeFirst() throws SQLException {
        this.checkRowSetClosed();
        this.checkRowIndexType(-1);
        if (this.innerRS != null) {
            if (this.innerRS.isBeforeFirst()) {
                return;
            }
            this.innerRS.beforeFirst();
            this.notifyCursorMoved();
        }
    }

    @Override
    public void cancelRowUpdates() throws SQLException {
        this.checkRowSetClosed();
        if (this.innerRS != null) {
            this.innerRS.cancelRowUpdates();
        }
        this.notifyRowChanged();
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.checkRowSetClosed();
        if (this.innerRS != null) {
            this.innerRS.clearWarnings();
        }
    }

    @Override
    public void close() throws SQLException {
        if (this.innerRS != null) {
            this.innerRS.close();
        }
        if (this.rowCstm != null) {
            this.rowCstm.close();
        }
        if (this.rowsetConnection != null && !this.rowsetConnection.isClosed()) {
            this.rowsetConnection.close();
        }
        this.eventListener.clear();
        this.notifyRowSetChanged();
        this.isClosed = true;
    }

    @Override
    public void deleteRow() throws SQLException {
        this.checkRowSetClosed();
        this.checkRowSetUpdatableType();
        if (this.innerRS != null) {
            this.innerRS.deleteRow();
            this.notifyRowChanged();
        }
    }

    @Override
    public int findColumn(String columnLabel) throws SQLException {
        int colIndex = -1;
        this.checkRowSetClosed();
        if (this.innerRS != null) {
            colIndex = this.innerRS.findColumn(columnLabel);
        }
        return colIndex;
    }

    @Override
    public boolean first() throws SQLException {
        this.checkRowSetClosed();
        this.checkRowIndexType(-1);
        boolean moveFirst = false;
        if (this.innerRS != null) {
            if (this.innerRS.isFirst()) {
                moveFirst = true;
            } else {
                moveFirst = this.innerRS.first();
                this.notifyCursorMoved();
            }
        }
        return moveFirst;
    }

    @Override
    public Array getArray(int columnIndex) throws SQLException {
        this.checkRowSetClosed();
        if (this.innerRS != null) {
            return this.innerRS.getArray(columnIndex);
        }
        return null;
    }

    @Override
    public Array getArray(String columnLabel) throws SQLException {
        return this.getArray(this.findColumn(columnLabel));
    }

    @Override
    public InputStream getAsciiStream(int columnIndex) throws SQLException {
        this.checkRowSetClosed();
        if (this.innerRS != null) {
            return this.innerRS.getAsciiStream(columnIndex);
        }
        return null;
    }

    @Override
    public InputStream getAsciiStream(String columnLabel) throws SQLException {
        return this.getAsciiStream(this.findColumn(columnLabel));
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        this.checkRowSetClosed();
        if (this.innerRS != null) {
            return this.innerRS.getBigDecimal(columnIndex);
        }
        return null;
    }

    @Override
    public BigDecimal getBigDecimal(String columnLabel) throws SQLException {
        return this.getBigDecimal(this.findColumn(columnLabel));
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        this.checkRowSetClosed();
        if (this.innerRS != null) {
            return this.innerRS.getBigDecimal(columnIndex, scale);
        }
        return null;
    }

    @Override
    public BigDecimal getBigDecimal(String columnLabel, int scale) throws SQLException {
        return this.getBigDecimal(this.findColumn(columnLabel), scale);
    }

    @Override
    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        this.checkRowSetClosed();
        if (this.innerRS != null) {
            return this.innerRS.getBinaryStream(columnIndex);
        }
        return null;
    }

    @Override
    public InputStream getBinaryStream(String columnLabel) throws SQLException {
        return this.getBinaryStream(this.findColumn(columnLabel));
    }

    @Override
    public Blob getBlob(int columnIndex) throws SQLException {
        this.checkRowSetClosed();
        if (this.innerRS != null) {
            return this.innerRS.getBlob(columnIndex);
        }
        return null;
    }

    @Override
    public Blob getBlob(String columnLabel) throws SQLException {
        return this.getBlob(this.findColumn(columnLabel));
    }

    @Override
    public boolean getBoolean(int columnIndex) throws SQLException {
        this.checkRowSetClosed();
        if (this.innerRS != null) {
            return this.innerRS.getBoolean(columnIndex);
        }
        return false;
    }

    @Override
    public boolean getBoolean(String columnLabel) throws SQLException {
        return this.getBoolean(this.findColumn(columnLabel));
    }

    @Override
    public byte getByte(int columnIndex) throws SQLException {
        this.checkRowSetClosed();
        if (this.innerRS != null) {
            return this.innerRS.getByte(columnIndex);
        }
        return 0;
    }

    @Override
    public byte getByte(String columnLabel) throws SQLException {
        return this.getByte(this.findColumn(columnLabel));
    }

    @Override
    public byte[] getBytes(int columnIndex) throws SQLException {
        this.checkRowSetClosed();
        if (this.innerRS != null) {
            return this.innerRS.getBytes(columnIndex);
        }
        return null;
    }

    @Override
    public byte[] getBytes(String columnLabel) throws SQLException {
        return this.getBytes(this.findColumn(columnLabel));
    }

    @Override
    public Reader getCharacterStream(int columnIndex) throws SQLException {
        this.checkRowSetClosed();
        if (this.innerRS != null) {
            return this.innerRS.getCharacterStream(columnIndex);
        }
        return null;
    }

    @Override
    public Reader getCharacterStream(String columnLabel) throws SQLException {
        return this.getCharacterStream(this.findColumn(columnLabel));
    }

    @Override
    public Clob getClob(int columnIndex) throws SQLException {
        this.checkRowSetClosed();
        if (this.innerRS != null) {
            return this.innerRS.getClob(columnIndex);
        }
        return null;
    }

    @Override
    public Clob getClob(String columnLabel) throws SQLException {
        return this.getClob(this.findColumn(columnLabel));
    }

    @Override
    public int getConcurrency() throws SQLException {
        return this.concurrency;
    }

    @Override
    public String getCursorName() throws SQLException {
        this.checkRowSetClosed();
        if (this.innerRS != null) {
            return this.innerRS.getCursorName();
        }
        return null;
    }

    @Override
    public Date getDate(int columnIndex) throws SQLException {
        this.checkRowSetClosed();
        if (this.innerRS != null) {
            return this.innerRS.getDate(columnIndex);
        }
        return null;
    }

    @Override
    public Date getDate(String columnLabel) throws SQLException {
        return this.getDate(this.findColumn(columnLabel));
    }

    @Override
    public Date getDate(int columnIndex, Calendar cal) throws SQLException {
        this.checkRowSetClosed();
        if (this.innerRS != null) {
            return this.innerRS.getDate(columnIndex, cal);
        }
        return null;
    }

    @Override
    public Date getDate(String columnLabel, Calendar cal) throws SQLException {
        return this.getDate(this.findColumn(columnLabel), cal);
    }

    @Override
    public double getDouble(int columnIndex) throws SQLException {
        this.checkRowSetClosed();
        if (this.innerRS != null) {
            return this.innerRS.getDouble(columnIndex);
        }
        return 0.0;
    }

    @Override
    public double getDouble(String columnLabel) throws SQLException {
        return this.getDouble(this.findColumn(columnLabel));
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return this.fetchDirection;
    }

    @Override
    public int getFetchSize() throws SQLException {
        return this.fetchSize;
    }

    @Override
    public float getFloat(int columnIndex) throws SQLException {
        this.checkRowSetClosed();
        if (this.innerRS != null) {
            return this.innerRS.getFloat(columnIndex);
        }
        return 0.0f;
    }

    @Override
    public float getFloat(String columnLabel) throws SQLException {
        return this.getFloat(this.findColumn(columnLabel));
    }

    @Override
    public int getHoldability() throws SQLException {
        return this.getHoldability();
    }

    @Override
    public int getInt(int columnIndex) throws SQLException {
        this.checkRowSetClosed();
        if (this.innerRS != null) {
            return this.innerRS.getInt(columnIndex);
        }
        return 0;
    }

    @Override
    public int getInt(String columnLabel) throws SQLException {
        return this.getInt(this.findColumn(columnLabel));
    }

    @Override
    public long getLong(int columnIndex) throws SQLException {
        this.checkRowSetClosed();
        if (this.innerRS != null) {
            return this.innerRS.getLong(columnIndex);
        }
        return 0L;
    }

    @Override
    public long getLong(String columnLabel) throws SQLException {
        return this.getLong(this.findColumn(columnLabel));
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        this.checkRowSetClosed();
        if (this.innerRS != null) {
            return this.innerRS.getMetaData();
        }
        return null;
    }

    @Override
    public Reader getNCharacterStream(int columnIndex) throws SQLException {
        this.checkRowSetClosed();
        if (this.innerRS != null) {
            return this.innerRS.getNCharacterStream(columnIndex);
        }
        return null;
    }

    @Override
    public Reader getNCharacterStream(String columnLabel) throws SQLException {
        return this.getNCharacterStream(this.findColumn(columnLabel));
    }

    @Override
    public NClob getNClob(int columnIndex) throws SQLException {
        this.checkRowSetClosed();
        if (this.innerRS != null) {
            return this.innerRS.getNClob(columnIndex);
        }
        return null;
    }

    @Override
    public NClob getNClob(String columnLabel) throws SQLException {
        return this.getNClob(this.findColumn(columnLabel));
    }

    @Override
    public String getNString(int columnIndex) throws SQLException {
        return this.getString(columnIndex);
    }

    @Override
    public String getNString(String columnLabel) throws SQLException {
        return this.getNString(this.findColumn(columnLabel));
    }

    @Override
    public Object getObject(int columnIndex) throws SQLException {
        this.checkRowSetClosed();
        if (this.innerRS != null) {
            return this.innerRS.getObject(columnIndex);
        }
        return null;
    }

    @Override
    public Object getObject(String columnLabel) throws SQLException {
        return this.getObject(this.findColumn(columnLabel));
    }

    @Override
    public Object getObject(int columnIndex, Map<String, Class<?>> maps) throws SQLException {
        this.checkRowSetClosed();
        if (this.innerRS != null) {
            return this.innerRS.getObject(columnIndex, maps);
        }
        return null;
    }

    @Override
    public Object getObject(String columnLabel, Map<String, Class<?>> maps) throws SQLException {
        return this.getObject(this.findColumn(columnLabel), maps);
    }

    @Override
    public Ref getRef(int columnIndex) throws SQLException {
        this.checkRowSetClosed();
        if (this.innerRS != null) {
            return this.innerRS.getRef(columnIndex);
        }
        return null;
    }

    @Override
    public Ref getRef(String columnLabel) throws SQLException {
        return this.getRef(this.findColumn(columnLabel));
    }

    @Override
    public int getRow() throws SQLException {
        this.checkRowSetClosed();
        if (this.innerRS != null) {
            return this.innerRS.getRow();
        }
        return 0;
    }

    @Override
    public RowId getRowId(int columnIndex) throws SQLException {
        this.checkRowSetClosed();
        if (this.innerRS != null) {
            return this.innerRS.getRowId(columnIndex);
        }
        return null;
    }

    @Override
    public RowId getRowId(String columnLabel) throws SQLException {
        return this.getRowId(this.findColumn(columnLabel));
    }

    @Override
    public SQLXML getSQLXML(int columnIndex) throws SQLException {
        this.checkRowSetClosed();
        if (this.innerRS != null) {
            return this.innerRS.getSQLXML(columnIndex);
        }
        return null;
    }

    @Override
    public SQLXML getSQLXML(String columnLabel) throws SQLException {
        return this.getSQLXML(this.findColumn(columnLabel));
    }

    @Override
    public short getShort(int columnIndex) throws SQLException {
        this.checkRowSetClosed();
        if (this.innerRS != null) {
            return this.innerRS.getShort(columnIndex);
        }
        return 0;
    }

    @Override
    public short getShort(String columnLabel) throws SQLException {
        return this.getShort(this.findColumn(columnLabel));
    }

    @Override
    public Statement getStatement() throws SQLException {
        this.checkRowSetClosed();
        if (this.innerRS != null) {
            return this.innerRS.getStatement();
        }
        return null;
    }

    @Override
    public String getString(int columnIndex) throws SQLException {
        this.checkRowSetClosed();
        if (this.innerRS != null) {
            return this.innerRS.getString(columnIndex);
        }
        return null;
    }

    @Override
    public String getString(String columnLabel) throws SQLException {
        return this.getString(this.findColumn(columnLabel));
    }

    @Override
    public Time getTime(int columnIndex) throws SQLException {
        this.checkRowSetClosed();
        if (this.innerRS != null) {
            return this.innerRS.getTime(columnIndex);
        }
        return null;
    }

    @Override
    public Time getTime(String columnLabel) throws SQLException {
        return this.getTime(this.findColumn(columnLabel));
    }

    @Override
    public Time getTime(int columnIndex, Calendar cal) throws SQLException {
        this.checkRowSetClosed();
        if (this.innerRS != null) {
            return this.innerRS.getTime(columnIndex, cal);
        }
        return null;
    }

    @Override
    public Time getTime(String columnLabel, Calendar cal) throws SQLException {
        return this.getTime(this.findColumn(columnLabel), cal);
    }

    @Override
    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        this.checkRowSetClosed();
        if (this.innerRS != null) {
            return this.innerRS.getTimestamp(columnIndex);
        }
        return null;
    }

    @Override
    public Timestamp getTimestamp(String columnLabel) throws SQLException {
        return this.getTimestamp(this.findColumn(columnLabel));
    }

    @Override
    public Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        this.checkRowSetClosed();
        if (this.innerRS != null) {
            return this.innerRS.getTimestamp(columnIndex, cal);
        }
        return null;
    }

    @Override
    public Timestamp getTimestamp(String columnLabel, Calendar cal) throws SQLException {
        return this.getTimestamp(this.findColumn(columnLabel), cal);
    }

    @Override
    public int getType() throws SQLException {
        return this.rowsetType;
    }

    @Override
    public URL getURL(int columnIndex) throws SQLException {
        this.checkRowSetClosed();
        if (this.innerRS != null) {
            return this.innerRS.getURL(columnIndex);
        }
        return null;
    }

    @Override
    public URL getURL(String columnLabel) throws SQLException {
        return this.getURL(this.findColumn(columnLabel));
    }

    @Override
    public InputStream getUnicodeStream(int columnIndex) throws SQLException {
        this.checkRowSetClosed();
        if (this.innerRS != null) {
            return this.innerRS.getUnicodeStream(columnIndex);
        }
        return null;
    }

    @Override
    public InputStream getUnicodeStream(String columnLabel) throws SQLException {
        return this.getUnicodeStream(this.findColumn(columnLabel));
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.checkRowSetClosed();
        if (this.innerRS != null) {
            return this.innerRS.getWarnings();
        }
        return null;
    }

    @Override
    public void insertRow() throws SQLException {
        this.checkRowSetClosed();
        this.checkRowSetUpdatableType();
        if (this.innerRS != null) {
            this.innerRS.insertRow();
            this.notifyRowChanged();
        }
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        this.checkRowSetClosed();
        if (this.innerRS != null) {
            return this.innerRS.isAfterLast();
        }
        return false;
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        this.checkRowSetClosed();
        if (this.innerRS != null) {
            return this.innerRS.isBeforeFirst();
        }
        return false;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.isClosed;
    }

    @Override
    public boolean isFirst() throws SQLException {
        this.checkRowSetClosed();
        if (this.innerRS != null) {
            return this.innerRS.isFirst();
        }
        return false;
    }

    @Override
    public boolean isLast() throws SQLException {
        this.checkRowSetClosed();
        if (this.innerRS != null) {
            return this.innerRS.isLast();
        }
        return false;
    }

    @Override
    public boolean last() throws SQLException {
        this.checkRowSetClosed();
        boolean moveLast = false;
        if (this.innerRS != null && (moveLast = this.innerRS.last())) {
            this.notifyCursorMoved();
        }
        return moveLast;
    }

    @Override
    public void moveToCurrentRow() throws SQLException {
        this.checkRowSetClosed();
        this.checkRowSetUpdatableType();
        if (this.innerRS != null) {
            this.innerRS.moveToCurrentRow();
        }
    }

    @Override
    public void moveToInsertRow() throws SQLException {
        this.checkRowSetClosed();
        this.checkRowSetUpdatableType();
        if (this.innerRS != null) {
            this.innerRS.moveToInsertRow();
        }
    }

    @Override
    public boolean next() throws SQLException {
        this.checkRowSetClosed();
        boolean hasNext = false;
        if (this.innerRS != null) {
            ResultSet nextRS = (ResultSet)this.innerRS;
            Connection conn = null;
            if (!nextRS.hasMoreRows()) {
                conn = this.getConnection();
            }
            if (hasNext = nextRS.next(true, conn)) {
                this.notifyCursorMoved();
            }
        }
        return hasNext;
    }

    @Override
    public boolean previous() throws SQLException {
        this.checkRowSetClosed();
        this.checkRowIndexType(-1);
        boolean moved = false;
        if (this.innerRS != null && (moved = this.innerRS.previous())) {
            this.notifyCursorMoved();
        }
        return moved;
    }

    @Override
    public void refreshRow() throws SQLException {
        this.checkRowSetClosed();
        if (this.innerRS != null) {
            this.innerRS.refreshRow();
        }
    }

    @Override
    public boolean relative(int row) throws SQLException {
        this.checkRowSetClosed();
        this.checkRowIndexType(row);
        boolean moved = false;
        if (this.innerRS != null && (moved = this.innerRS.relative(row))) {
            this.notifyCursorMoved();
        }
        return moved;
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        this.checkRowSetClosed();
        boolean rowDeleted = false;
        if (this.innerRS != null) {
            rowDeleted = this.innerRS.rowDeleted();
        }
        return rowDeleted;
    }

    @Override
    public boolean rowInserted() throws SQLException {
        this.checkRowSetClosed();
        boolean rowInserted = false;
        if (this.innerRS != null) {
            rowInserted = this.innerRS.rowInserted();
        }
        return rowInserted;
    }

    @Override
    public boolean rowUpdated() throws SQLException {
        this.checkRowSetClosed();
        boolean rowUpdated = false;
        if (this.innerRS != null) {
            rowUpdated = this.innerRS.rowUpdated();
        }
        return rowUpdated;
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        this.checkRowSetClosed();
        if (this.innerRS != null) {
            this.innerRS.setFetchDirection(direction);
        }
    }

    @Override
    public void setFetchSize(int size) throws SQLException {
        this.checkRowSetClosed();
        if (this.innerRS != null) {
            this.innerRS.setFetchSize(size);
        }
    }

    @Override
    public void updateArray(int columnIndex, Array array) throws SQLException {
        this.checkRowSetClosed();
        if (this.innerRS != null) {
            this.innerRS.updateArray(columnIndex, array);
        }
    }

    @Override
    public void updateArray(String columnLabel, Array array) throws SQLException {
        this.updateArray(this.findColumn(columnLabel), array);
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream input) throws SQLException {
        this.checkRowSetClosed();
        if (this.innerRS != null) {
            this.innerRS.updateAsciiStream(columnIndex, input);
        }
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream input) throws SQLException {
        this.updateAsciiStream(this.findColumn(columnLabel), input);
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream input, int length) throws SQLException {
        this.checkRowSetClosed();
        if (this.innerRS != null) {
            this.innerRS.updateAsciiStream(columnIndex, input, length);
        }
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream input, int length) throws SQLException {
        this.updateAsciiStream(this.findColumn(columnLabel), input, length);
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream input, long length) throws SQLException {
        this.checkRowSetClosed();
        if (this.innerRS != null) {
            this.innerRS.updateAsciiStream(columnIndex, input, length);
        }
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream input, long length) throws SQLException {
        this.updateAsciiStream(this.findColumn(columnLabel), input, length);
    }

    @Override
    public void updateBigDecimal(int columnIndex, BigDecimal x) throws SQLException {
        this.checkRowSetClosed();
        if (this.innerRS != null) {
            this.innerRS.updateBigDecimal(columnIndex, x);
        }
    }

    @Override
    public void updateBigDecimal(String columnLabel, BigDecimal x) throws SQLException {
        this.updateBigDecimal(this.findColumn(columnLabel), x);
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream input) throws SQLException {
        this.checkRowSetClosed();
        if (this.innerRS != null) {
            this.innerRS.updateBinaryStream(columnIndex, input);
        }
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream input) throws SQLException {
        this.updateBinaryStream(this.findColumn(columnLabel), input);
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream input, int length) throws SQLException {
        this.checkRowSetClosed();
        if (this.innerRS != null) {
            this.innerRS.updateBinaryStream(columnIndex, input, length);
        }
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream input, int length) throws SQLException {
        this.updateBinaryStream(this.findColumn(columnLabel), input, length);
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream input, long length) throws SQLException {
        this.checkRowSetClosed();
        if (this.innerRS != null) {
            this.innerRS.updateBinaryStream(columnIndex, input, length);
        }
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream input, long length) throws SQLException {
        this.updateBinaryStream(this.findColumn(columnLabel), input, length);
    }

    @Override
    public void updateBlob(int columnIndex, Blob blob) throws SQLException {
        this.checkRowSetClosed();
        if (this.innerRS != null) {
            this.innerRS.updateBlob(columnIndex, blob);
        }
    }

    @Override
    public void updateBlob(String columnLabel, Blob blob) throws SQLException {
        this.updateBlob(this.findColumn(columnLabel), blob);
    }

    @Override
    public void updateBlob(int columnIndex, InputStream input) throws SQLException {
        this.checkRowSetClosed();
        if (this.innerRS != null) {
            this.innerRS.updateBlob(columnIndex, input);
        }
    }

    @Override
    public void updateBlob(String columnLabel, InputStream input) throws SQLException {
        this.updateBlob(this.findColumn(columnLabel), input);
    }

    @Override
    public void updateBlob(int columnIndex, InputStream input, long length) throws SQLException {
        this.checkRowSetClosed();
        if (this.innerRS != null) {
            this.innerRS.updateBlob(columnIndex, input, length);
        }
    }

    @Override
    public void updateBlob(String columnLabel, InputStream input, long length) throws SQLException {
        this.updateBlob(this.findColumn(columnLabel), input, length);
    }

    @Override
    public void updateBoolean(int columnIndex, boolean x) throws SQLException {
        this.checkRowSetClosed();
        if (this.innerRS != null) {
            this.innerRS.updateBoolean(columnIndex, x);
        }
    }

    @Override
    public void updateBoolean(String columnLabel, boolean x) throws SQLException {
        this.updateBoolean(this.findColumn(columnLabel), x);
    }

    @Override
    public void updateByte(int columnIndex, byte x) throws SQLException {
        this.checkRowSetClosed();
        if (this.innerRS != null) {
            this.innerRS.updateByte(columnIndex, x);
        }
    }

    @Override
    public void updateByte(String columnLabel, byte x) throws SQLException {
        this.updateByte(this.findColumn(columnLabel), x);
    }

    @Override
    public void updateBytes(int columnIndex, byte[] x) throws SQLException {
        this.checkRowSetClosed();
        if (this.innerRS != null) {
            this.innerRS.updateBytes(columnIndex, x);
        }
    }

    @Override
    public void updateBytes(String columnLabel, byte[] x) throws SQLException {
        this.updateBytes(this.findColumn(columnLabel), x);
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader reader) throws SQLException {
        this.checkRowSetClosed();
        if (this.innerRS != null) {
            this.innerRS.updateCharacterStream(columnIndex, reader);
        }
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader) throws SQLException {
        this.updateCharacterStream(this.findColumn(columnLabel), reader);
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader reader, int length) throws SQLException {
        this.checkRowSetClosed();
        if (this.innerRS != null) {
            this.innerRS.updateCharacterStream(columnIndex, reader, length);
        }
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader, int length) throws SQLException {
        this.updateCharacterStream(this.findColumn(columnLabel), reader, length);
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader reader, long length) throws SQLException {
        this.checkRowSetClosed();
        if (this.innerRS != null) {
            this.innerRS.updateCharacterStream(columnIndex, reader, length);
        }
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        this.updateCharacterStream(this.findColumn(columnLabel), reader, length);
    }

    @Override
    public void updateClob(int columnIndex, Clob clob) throws SQLException {
        this.checkRowSetClosed();
        if (this.innerRS != null) {
            this.innerRS.updateClob(columnIndex, clob);
        }
    }

    @Override
    public void updateClob(String columnLabel, Clob clob) throws SQLException {
        this.updateClob(this.findColumn(columnLabel), clob);
    }

    @Override
    public void updateClob(int columnIndex, Reader reader) throws SQLException {
        this.checkRowSetClosed();
        if (this.innerRS != null) {
            this.innerRS.updateClob(columnIndex, reader);
        }
    }

    @Override
    public void updateClob(String columnLabel, Reader reader) throws SQLException {
        this.updateClob(this.findColumn(columnLabel), reader);
    }

    @Override
    public void updateClob(int columnIndex, Reader reader, long length) throws SQLException {
        this.checkRowSetClosed();
        if (this.innerRS != null) {
            this.innerRS.updateClob(columnIndex, reader, length);
        }
    }

    @Override
    public void updateClob(String columnLabel, Reader reader, long length) throws SQLException {
        this.updateClob(this.findColumn(columnLabel), reader, length);
    }

    @Override
    public void updateDate(int columnIndex, Date x) throws SQLException {
        this.checkRowSetClosed();
        if (this.innerRS != null) {
            this.innerRS.updateDate(columnIndex, x);
        }
    }

    @Override
    public void updateDate(String columnLabel, Date x) throws SQLException {
        this.updateDate(this.findColumn(columnLabel), x);
    }

    @Override
    public void updateDouble(int columnIndex, double x) throws SQLException {
        this.checkRowSetClosed();
        if (this.innerRS != null) {
            this.innerRS.updateDouble(columnIndex, x);
        }
    }

    @Override
    public void updateDouble(String columnLabel, double x) throws SQLException {
        this.updateDouble(this.findColumn(columnLabel), x);
    }

    @Override
    public void updateFloat(int columnIndex, float x) throws SQLException {
        this.checkRowSetClosed();
        if (this.innerRS != null) {
            this.innerRS.updateFloat(columnIndex, x);
        }
    }

    @Override
    public void updateFloat(String columnLabel, float x) throws SQLException {
        this.updateFloat(this.findColumn(columnLabel), x);
    }

    @Override
    public void updateInt(int columnIndex, int x) throws SQLException {
        this.checkRowSetClosed();
        if (this.innerRS != null) {
            this.innerRS.updateInt(columnIndex, x);
        }
    }

    @Override
    public void updateInt(String columnLabel, int x) throws SQLException {
        this.updateFloat(this.findColumn(columnLabel), (float)x);
    }

    @Override
    public void updateLong(int columnIndex, long x) throws SQLException {
        this.checkRowSetClosed();
        if (this.innerRS != null) {
            this.innerRS.updateLong(columnIndex, x);
        }
    }

    @Override
    public void updateLong(String columnLabel, long x) throws SQLException {
        this.updateFloat(this.findColumn(columnLabel), (float)x);
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader reader) throws SQLException {
        this.checkRowSetClosed();
        if (this.innerRS != null) {
            this.innerRS.updateNCharacterStream(columnIndex, reader);
        }
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader) throws SQLException {
        this.updateNCharacterStream(this.findColumn(columnLabel), reader);
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader reader, long length) throws SQLException {
        this.checkRowSetClosed();
        if (this.innerRS != null) {
            this.innerRS.updateNCharacterStream(columnIndex, reader, length);
        }
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        this.updateNCharacterStream(this.findColumn(columnLabel), reader, length);
    }

    @Override
    public void updateNClob(int columnIndex, NClob nclob) throws SQLException {
        this.checkRowSetClosed();
        if (this.innerRS != null) {
            this.innerRS.updateNClob(columnIndex, nclob);
        }
    }

    @Override
    public void updateNClob(String columnLabel, NClob nClob) throws SQLException {
        this.updateNClob(this.findColumn(columnLabel), nClob);
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader) throws SQLException {
        this.checkRowSetClosed();
        if (this.innerRS != null) {
            this.innerRS.updateNClob(columnIndex, reader);
        }
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader) throws SQLException {
        this.updateNClob(this.findColumn(columnLabel), reader);
    }

    @Override
    public <T> T getObject(int columnIndex, Class<T> type) throws SQLException {
        return null;
    }

    @Override
    public <T> T getObject(String columnLabel, Class<T> type) throws SQLException {
        return null;
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader, long length) throws SQLException {
        this.checkRowSetClosed();
        if (this.innerRS != null) {
            this.innerRS.updateNClob(columnIndex, reader, length);
        }
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader, long length) throws SQLException {
        this.updateNClob(this.findColumn(columnLabel), reader, length);
    }

    @Override
    public void updateNString(int columnIndex, String nString) throws SQLException {
        this.checkRowSetClosed();
        if (this.innerRS != null) {
            this.innerRS.updateNString(columnIndex, nString);
        }
    }

    @Override
    public void updateNString(String columnLabel, String nString) throws SQLException {
        this.updateNString(this.findColumn(columnLabel), nString);
    }

    @Override
    public void updateNull(int columnIndex) throws SQLException {
        this.checkRowSetClosed();
        if (this.innerRS != null) {
            this.innerRS.updateNull(columnIndex);
        }
    }

    @Override
    public void updateNull(String columnLabel) throws SQLException {
        this.updateNull(this.findColumn(columnLabel));
    }

    @Override
    public void updateObject(int columnIndex, Object x) throws SQLException {
        this.checkRowSetClosed();
        if (this.innerRS != null) {
            this.innerRS.updateObject(columnIndex, x);
        }
    }

    @Override
    public void updateObject(String columnLabel, Object x) throws SQLException {
        this.updateObject(this.findColumn(columnLabel), x);
    }

    @Override
    public void updateObject(int columnIndex, Object x, int scaleOrLength) throws SQLException {
        this.checkRowSetClosed();
        if (this.innerRS != null) {
            this.innerRS.updateObject(columnIndex, x, scaleOrLength);
        }
    }

    @Override
    public void updateObject(String columnLabel, Object x, int scaleOrLength) throws SQLException {
        this.updateObject(this.findColumn(columnLabel), x, scaleOrLength);
    }

    @Override
    public void updateRef(int columnIndex, Ref x) throws SQLException {
        this.checkRowSetClosed();
        if (this.innerRS != null) {
            this.innerRS.updateRef(columnIndex, x);
        }
    }

    @Override
    public void updateRef(String columnLabel, Ref x) throws SQLException {
        this.updateRef(this.findColumn(columnLabel), x);
    }

    @Override
    public void updateRow() throws SQLException {
        this.checkRowSetClosed();
        this.checkRowSetUpdatableType();
        if (this.innerRS != null) {
            this.innerRS.updateRow();
            this.notifyRowChanged();
        }
    }

    @Override
    public void updateRowId(int columnIndex, RowId x) throws SQLException {
        this.checkRowSetClosed();
        if (this.innerRS != null) {
            this.innerRS.updateRowId(columnIndex, x);
        }
    }

    @Override
    public void updateRowId(String columnLabel, RowId x) throws SQLException {
        this.updateRowId(this.findColumn(columnLabel), x);
    }

    @Override
    public void updateSQLXML(int columnIndex, SQLXML xmlObject) throws SQLException {
        this.checkRowSetClosed();
        if (this.innerRS != null) {
            this.innerRS.updateSQLXML(columnIndex, xmlObject);
        }
    }

    @Override
    public void updateSQLXML(String columnLabel, SQLXML xmlObject) throws SQLException {
        this.updateSQLXML(this.findColumn(columnLabel), xmlObject);
    }

    @Override
    public void updateShort(int columnIndex, short x) throws SQLException {
        this.checkRowSetClosed();
        if (this.innerRS != null) {
            this.innerRS.updateShort(columnIndex, x);
        }
    }

    @Override
    public void updateShort(String columnLabel, short x) throws SQLException {
        this.updateShort(this.findColumn(columnLabel), x);
    }

    @Override
    public void updateString(int columnIndex, String x) throws SQLException {
        this.checkRowSetClosed();
        if (this.innerRS != null) {
            this.innerRS.updateString(columnIndex, x);
        }
    }

    @Override
    public void updateString(String columnLabel, String x) throws SQLException {
        this.updateString(this.findColumn(columnLabel), x);
    }

    @Override
    public void updateTime(int columnIndex, Time x) throws SQLException {
        this.checkRowSetClosed();
        if (this.innerRS != null) {
            this.innerRS.updateTime(columnIndex, x);
        }
    }

    @Override
    public void updateTime(String columnLabel, Time x) throws SQLException {
        this.updateTime(this.findColumn(columnLabel), x);
    }

    @Override
    public void updateTimestamp(int columnIndex, Timestamp x) throws SQLException {
        this.checkRowSetClosed();
        if (this.innerRS != null) {
            this.innerRS.updateTimestamp(columnIndex, x);
        }
    }

    @Override
    public void updateTimestamp(String columnLabel, Timestamp x) throws SQLException {
        this.updateTimestamp(this.findColumn(columnLabel), x);
    }

    @Override
    public boolean wasNull() throws SQLException {
        boolean wasNull = true;
        this.checkRowSetClosed();
        if (this.innerRS != null) {
            wasNull = this.innerRS.wasNull();
        }
        return wasNull;
    }

    @Override
    public boolean isWrapperFor(Class<?> arg0) throws SQLException {
        boolean isWrapperFor = true;
        this.checkRowSetClosed();
        if (this.innerRS != null) {
            isWrapperFor = this.innerRS.isWrapperFor(arg0);
        }
        return isWrapperFor;
    }

    @Override
    public <T> T unwrap(Class<T> arg0) throws SQLException {
        this.checkRowSetClosed();
        if (this.innerRS != null) {
            return this.innerRS.unwrap(arg0);
        }
        return null;
    }

    @Override
    public void addRowSetListener(RowSetListener listener) {
        for (int i = 0; i < this.eventListener.size(); ++i) {
            if (!listener.equals(this.eventListener.elementAt(i))) continue;
            return;
        }
        this.eventListener.add(listener);
    }

    @Override
    public void clearParameters() throws SQLException {
        this.checkRowSetClosed();
        if (this.rowCstm != null) {
            this.rowCstm.clearParameters();
        }
    }

    @Override
    public void execute() throws SQLException {
        this.checkRowSetClosed();
        this.rowsetConnection = this.getConnection();
        if (this.rowCstm == null) {
            this.rowCstm = this.rowsetConnection.prepareCall(this.getCommand(), this.rowsetType, this.concurrency);
        }
        this.rowCstm.setFetchSize(this.getFetchSize());
        this.rowCstm.setFetchDirection(this.getFetchDirection());
        this.rowCstm.setMaxFieldSize(this.getMaxFieldSize());
        this.rowCstm.setMaxRows(this.getMaxRows());
        this.innerRS = this.rowCstm.executeQuery();
        this.rowRsmd = new RowSetMetaDataImpl(this.innerRS.getMetaData());
        this.notifyRowSetChanged();
    }

    @Override
    public String getCommand() {
        return this.command;
    }

    @Override
    public String getDataSourceName() {
        return this.dataSourceName;
    }

    @Override
    public boolean getEscapeProcessing() throws SQLException {
        this.checkRowSetClosed();
        return false;
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        this.checkRowSetClosed();
        return this.maxFieldSize;
    }

    @Override
    public int getMaxRows() throws SQLException {
        this.checkRowSetClosed();
        return this.maxRows;
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        return 0;
    }

    @Override
    public int getTransactionIsolation() {
        return 1;
    }

    public RowSetMetaData getRowSetMetaData() throws SQLException {
        this.checkRowSetClosed();
        return this.rowRsmd;
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        throw SQLCommon.unSupportException("RowSet.getTypeMap", null);
    }

    @Override
    public String getUrl() throws SQLException {
        return this.url;
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    @Override
    public boolean isReadOnly() {
        return this.readOnly;
    }

    @Override
    public void removeRowSetListener(RowSetListener listener) {
        for (int i = 0; i < this.eventListener.size(); ++i) {
            if (!listener.equals(this.eventListener.elementAt(i))) continue;
            this.eventListener.remove(listener);
        }
    }

    protected synchronized void notifyRowSetChanged() {
        for (int i = 0; i < this.eventListener.size(); ++i) {
            this.eventListener.get(i).rowSetChanged(this.event);
        }
    }

    protected synchronized void notifyCursorMoved() {
        for (int i = 0; i < this.eventListener.size(); ++i) {
            this.eventListener.get(i).cursorMoved(this.event);
        }
    }

    protected void notifyRowChanged() {
        for (int i = 0; i < this.eventListener.size(); ++i) {
            this.eventListener.get(i).rowChanged(this.event);
        }
    }

    @Override
    public void setArray(int parameterIndex, Array x) throws SQLException {
        this.checkRowSetClosed();
        if (this.rowCstm != null) {
            this.rowCstm.setArray(parameterIndex, x);
        }
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x) throws SQLException {
        this.checkRowSetClosed();
        if (this.rowCstm != null) {
            this.rowCstm.setAsciiStream(parameterIndex, x);
        }
    }

    @Override
    public void setAsciiStream(String parameterName, InputStream x) throws SQLException {
        this.checkRowSetClosed();
        if (this.rowCstm != null) {
            this.rowCstm.setAsciiStream(parameterName, x);
        }
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.checkRowSetClosed();
        if (this.rowCstm != null) {
            this.rowCstm.setAsciiStream(parameterIndex, x, length);
        }
    }

    @Override
    public void setAsciiStream(String parameterName, InputStream x, int length) throws SQLException {
        this.checkRowSetClosed();
        if (this.rowCstm != null) {
            this.rowCstm.setAsciiStream(parameterName, x, length);
        }
    }

    @Override
    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        this.checkRowSetClosed();
        if (this.rowCstm != null) {
            this.rowCstm.setBigDecimal(parameterIndex, x);
        }
    }

    @Override
    public void setBigDecimal(String parameterName, BigDecimal x) throws SQLException {
        this.checkRowSetClosed();
        if (this.rowCstm != null) {
            this.rowCstm.setBigDecimal(parameterName, x);
        }
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x) throws SQLException {
        this.checkRowSetClosed();
        if (this.rowCstm != null) {
            this.rowCstm.setBinaryStream(parameterIndex, x);
        }
    }

    @Override
    public void setBinaryStream(String parameterName, InputStream x) throws SQLException {
        this.checkRowSetClosed();
        if (this.rowCstm != null) {
            this.rowCstm.setBinaryStream(parameterName, x);
        }
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.checkRowSetClosed();
        if (this.rowCstm != null) {
            this.rowCstm.setBinaryStream(parameterIndex, x, length);
        }
    }

    @Override
    public void setBinaryStream(String parameterName, InputStream x, int length) throws SQLException {
        this.checkRowSetClosed();
        if (this.rowCstm != null) {
            this.rowCstm.setBinaryStream(parameterName, x, length);
        }
    }

    @Override
    public void setBlob(int parameterIndex, Blob x) throws SQLException {
        this.checkRowSetClosed();
        if (this.rowCstm != null) {
            this.rowCstm.setBlob(parameterIndex, x);
        }
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream) throws SQLException {
        this.checkRowSetClosed();
        if (this.rowCstm != null) {
            this.rowCstm.setBlob(parameterIndex, inputStream);
        }
    }

    @Override
    public void setBlob(String parameterName, Blob x) throws SQLException {
        this.checkRowSetClosed();
        if (this.rowCstm != null) {
            this.rowCstm.setBlob(parameterName, x);
        }
    }

    @Override
    public void setBlob(String parameterName, InputStream inputStream) throws SQLException {
        this.checkRowSetClosed();
        if (this.rowCstm != null) {
            this.rowCstm.setBlob(parameterName, inputStream);
        }
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream, long length) throws SQLException {
        this.checkRowSetClosed();
        if (this.rowCstm != null) {
            this.rowCstm.setBlob(parameterIndex, inputStream, length);
        }
    }

    @Override
    public void setBlob(String parameterName, InputStream inputStream, long length) throws SQLException {
        this.checkRowSetClosed();
        if (this.rowCstm != null) {
            this.rowCstm.setBlob(parameterName, inputStream, length);
        }
    }

    @Override
    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        this.checkRowSetClosed();
        if (this.rowCstm != null) {
            this.rowCstm.setBoolean(parameterIndex, x);
        }
    }

    @Override
    public void setBoolean(String parameterName, boolean x) throws SQLException {
        this.checkRowSetClosed();
        if (this.rowCstm != null) {
            this.rowCstm.setBoolean(parameterName, x);
        }
    }

    @Override
    public void setByte(int parameterIndex, byte x) throws SQLException {
        this.checkRowSetClosed();
        if (this.rowCstm != null) {
            this.rowCstm.setByte(parameterIndex, x);
        }
    }

    @Override
    public void setByte(String parameterName, byte x) throws SQLException {
        this.checkRowSetClosed();
        if (this.rowCstm != null) {
            this.rowCstm.setByte(parameterName, x);
        }
    }

    @Override
    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        this.checkRowSetClosed();
        if (this.rowCstm != null) {
            this.rowCstm.setBytes(parameterIndex, x);
        }
    }

    @Override
    public void setBytes(String parameterName, byte[] x) throws SQLException {
        this.checkRowSetClosed();
        if (this.rowCstm != null) {
            this.rowCstm.setBytes(parameterName, x);
        }
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader) throws SQLException {
        this.checkRowSetClosed();
        if (this.rowCstm != null) {
            this.rowCstm.setCharacterStream(parameterIndex, reader);
        }
    }

    @Override
    public void setCharacterStream(String parameterName, Reader reader) throws SQLException {
        this.checkRowSetClosed();
        if (this.rowCstm != null) {
            this.rowCstm.setCharacterStream(parameterName, reader);
        }
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        this.checkRowSetClosed();
        if (this.rowCstm != null) {
            this.rowCstm.setCharacterStream(parameterIndex, reader, length);
        }
    }

    @Override
    public void setCharacterStream(String parameterName, Reader reader, int length) throws SQLException {
        this.checkRowSetClosed();
        if (this.rowCstm != null) {
            this.rowCstm.setCharacterStream(parameterName, reader, length);
        }
    }

    @Override
    public void setClob(int parameterIndex, Clob x) throws SQLException {
        this.checkRowSetClosed();
        if (this.rowCstm != null) {
            this.rowCstm.setClob(parameterIndex, x);
        }
    }

    @Override
    public void setClob(int parameterIndex, Reader reader) throws SQLException {
        this.checkRowSetClosed();
        if (this.rowCstm != null) {
            this.rowCstm.setClob(parameterIndex, reader);
        }
    }

    @Override
    public void setClob(String parameterName, Clob x) throws SQLException {
        this.checkRowSetClosed();
        if (this.rowCstm != null) {
            this.rowCstm.setClob(parameterName, x);
        }
    }

    @Override
    public void setClob(String parameterName, Reader reader) throws SQLException {
        this.checkRowSetClosed();
        if (this.rowCstm != null) {
            this.rowCstm.setClob(parameterName, reader);
        }
    }

    @Override
    public void setClob(int parameterIndex, Reader reader, long length) throws SQLException {
        this.checkRowSetClosed();
        if (this.rowCstm != null) {
            this.rowCstm.setClob(parameterIndex, reader, length);
        }
    }

    @Override
    public void setClob(String parameterName, Reader reader, long length) throws SQLException {
        this.checkRowSetClosed();
        if (this.rowCstm != null) {
            this.rowCstm.setClob(parameterName, reader, length);
        }
    }

    @Override
    public void setCommand(String cmd) throws SQLException {
        this.command = cmd;
        this.rowsetConnection = this.getConnection();
        if (this.rowCstm != null && !this.rowCstm.isClosed()) {
            this.rowCstm.close();
            this.rowCstm = null;
        }
        this.rowCstm = this.rowsetConnection.prepareCall(cmd, this.getType(), this.getConcurrency());
    }

    @Override
    public void setConcurrency(int concurrency) throws SQLException {
        this.concurrency = concurrency;
        if (concurrency == 1008) {
            this.readOnly = false;
        }
    }

    @Override
    public void setDataSourceName(String name) throws SQLException {
        try {
            InitialContext ctx = new InitialContext();
            Connection nameConnection = (Connection)ctx.lookup(name);
            if (nameConnection == null) {
                XgDataSource innerDataSource = new XgDataSource();
                if (this.rowsetConnection != null) {
                    innerDataSource.setConnection(this.rowsetConnection);
                } else if (this.url != null) {
                    innerDataSource.setUrl(this.url);
                    innerDataSource.setUser(this.username);
                    innerDataSource.setPassword(this.password);
                    this.rowsetConnection = innerDataSource.getConnection();
                }
                ctx.bind(name, (Object)innerDataSource);
                this.dataSourceName = name;
            }
        }
        catch (NamingException e) {
            throw Error.createSQLException(e.getMessage());
        }
    }

    @Override
    public void setDate(int parameterIndex, Date x) throws SQLException {
        this.checkRowSetClosed();
        if (this.rowCstm != null) {
            this.rowCstm.setDate(parameterIndex, x);
        }
    }

    @Override
    public void setDate(String parameterName, Date x) throws SQLException {
        this.checkRowSetClosed();
        if (this.rowCstm != null) {
            this.rowCstm.setDate(parameterName, x);
        }
    }

    @Override
    public void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
        this.checkRowSetClosed();
        if (this.rowCstm != null) {
            this.rowCstm.setDate(parameterIndex, x, cal);
        }
    }

    @Override
    public void setDate(String parameterName, Date x, Calendar cal) throws SQLException {
        this.checkRowSetClosed();
        if (this.rowCstm != null) {
            this.rowCstm.setDate(parameterName, x, cal);
        }
    }

    @Override
    public void setDouble(int parameterIndex, double x) throws SQLException {
        this.checkRowSetClosed();
        if (this.rowCstm != null) {
            this.rowCstm.setDouble(parameterIndex, x);
        }
    }

    @Override
    public void setDouble(String parameterName, double x) throws SQLException {
        this.checkRowSetClosed();
        if (this.rowCstm != null) {
            this.rowCstm.setDouble(parameterName, x);
        }
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
    }

    @Override
    public void setFloat(int parameterIndex, float x) throws SQLException {
        this.checkRowSetClosed();
        if (this.rowCstm != null) {
            this.rowCstm.setFloat(parameterIndex, x);
        }
    }

    @Override
    public void setFloat(String parameterName, float x) throws SQLException {
        this.checkRowSetClosed();
        if (this.rowCstm != null) {
            this.rowCstm.setFloat(parameterName, x);
        }
    }

    @Override
    public void setInt(int parameterIndex, int x) throws SQLException {
        this.checkRowSetClosed();
        if (this.rowCstm != null) {
            this.rowCstm.setInt(parameterIndex, x);
        }
    }

    @Override
    public void setInt(String parameterName, int x) throws SQLException {
        this.checkRowSetClosed();
        if (this.rowCstm != null) {
            this.rowCstm.setInt(parameterName, x);
        }
    }

    @Override
    public void setLong(int parameterIndex, long x) throws SQLException {
        this.checkRowSetClosed();
        if (this.rowCstm != null) {
            this.rowCstm.setLong(parameterIndex, x);
        }
    }

    @Override
    public void setLong(String parameterName, long x) throws SQLException {
        this.checkRowSetClosed();
        if (this.rowCstm != null) {
            this.rowCstm.setLong(parameterName, x);
        }
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
        this.checkRowSetClosed();
        this.maxFieldSize = max;
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
        this.checkRowSetClosed();
        this.maxRows = max;
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value) throws SQLException {
        this.checkRowSetClosed();
        if (this.rowCstm != null) {
            this.rowCstm.setNCharacterStream(parameterIndex, value);
        }
    }

    @Override
    public void setNCharacterStream(String parameterName, Reader value) throws SQLException {
        this.checkRowSetClosed();
        if (this.rowCstm != null) {
            this.rowCstm.setNCharacterStream(parameterName, value);
        }
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value, long length) throws SQLException {
        this.checkRowSetClosed();
        if (this.rowCstm != null) {
            this.rowCstm.setNCharacterStream(parameterIndex, value, length);
        }
    }

    @Override
    public void setNCharacterStream(String parameterName, Reader value, long length) throws SQLException {
        this.checkRowSetClosed();
        if (this.rowCstm != null) {
            this.rowCstm.setNCharacterStream(parameterName, value, length);
        }
    }

    @Override
    public void setNClob(String parameterName, NClob value) throws SQLException {
        this.checkRowSetClosed();
        if (this.rowCstm != null) {
            this.rowCstm.setNClob(parameterName, value);
        }
    }

    @Override
    public void setNClob(String parameterName, Reader reader) throws SQLException {
        this.checkRowSetClosed();
        if (this.rowCstm != null) {
            this.rowCstm.setNClob(parameterName, reader);
        }
    }

    @Override
    public void setNClob(int parameterIndex, NClob value) throws SQLException {
        this.checkRowSetClosed();
        if (this.rowCstm != null) {
            this.rowCstm.setNClob(parameterIndex, value);
        }
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader) throws SQLException {
        this.checkRowSetClosed();
        if (this.rowCstm != null) {
            this.rowCstm.setNClob(parameterIndex, reader);
        }
    }

    @Override
    public void setNClob(String parameterName, Reader reader, long length) throws SQLException {
        this.checkRowSetClosed();
        if (this.rowCstm != null) {
            this.rowCstm.setNClob(parameterName, reader, length);
        }
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader, long length) throws SQLException {
        this.checkRowSetClosed();
        if (this.rowCstm != null) {
            this.rowCstm.setNClob(parameterIndex, reader, length);
        }
    }

    @Override
    public void setNString(int parameterIndex, String value) throws SQLException {
        this.checkRowSetClosed();
        if (this.rowCstm != null) {
            this.rowCstm.setNString(parameterIndex, value);
        }
    }

    @Override
    public void setNString(String parameterName, String value) throws SQLException {
        this.checkRowSetClosed();
        if (this.rowCstm != null) {
            this.rowCstm.setNString(parameterName, value);
        }
    }

    @Override
    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        this.checkRowSetClosed();
        if (this.rowCstm != null) {
            this.rowCstm.setNull(parameterIndex, sqlType);
        }
    }

    @Override
    public void setNull(String parameterName, int sqlType) throws SQLException {
        this.checkRowSetClosed();
        if (this.rowCstm != null) {
            this.rowCstm.setNull(parameterName, sqlType);
        }
    }

    @Override
    public void setNull(int paramIndex, int sqlType, String typeName) throws SQLException {
        this.checkRowSetClosed();
        if (this.rowCstm != null) {
            this.rowCstm.setNull(paramIndex, sqlType, typeName);
        }
    }

    @Override
    public void setNull(String parameterName, int sqlType, String typeName) throws SQLException {
        this.checkRowSetClosed();
        if (this.rowCstm != null) {
            this.rowCstm.setNull(parameterName, sqlType, typeName);
        }
    }

    @Override
    public void setObject(String parameterName, Object x) throws SQLException {
        this.checkRowSetClosed();
        if (this.rowCstm != null) {
            this.rowCstm.setObject(parameterName, x);
        }
    }

    @Override
    public void setObject(int parameterIndex, Object x) throws SQLException {
        this.checkRowSetClosed();
        if (this.rowCstm != null) {
            this.rowCstm.setObject(parameterIndex, x);
        }
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
        this.checkRowSetClosed();
        if (this.rowCstm != null) {
            this.rowCstm.setObject(parameterIndex, x);
        }
    }

    @Override
    public void setObject(String parameterName, Object x, int targetSqlType) throws SQLException {
        this.checkRowSetClosed();
        if (this.rowCstm != null) {
            this.rowCstm.setObject(parameterName, x, targetSqlType);
        }
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType, int scaleOrLength) throws SQLException {
        this.checkRowSetClosed();
        if (this.rowCstm != null) {
            this.rowCstm.setObject(parameterIndex, x, targetSqlType, scaleOrLength);
        }
    }

    @Override
    public void setObject(String parameterName, Object x, int targetSqlType, int scale) throws SQLException {
        this.checkRowSetClosed();
        if (this.rowCstm != null) {
            this.rowCstm.setObject(parameterName, x, targetSqlType, scale);
        }
    }

    @Override
    public void setPassword(String password) throws SQLException {
        this.checkRowSetClosed();
        this.password = password;
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
    }

    @Override
    public void setReadOnly(boolean value) throws SQLException {
        this.checkRowSetClosed();
        if (value) {
            this.checkRowSetUpdatableType();
        }
        this.readOnly = value;
    }

    @Override
    public void setRef(int i, Ref x) throws SQLException {
        this.checkRowSetClosed();
        if (this.rowCstm != null) {
            this.rowCstm.setRef(i, x);
        }
    }

    @Override
    public void setRowId(int parameterIndex, RowId x) throws SQLException {
        this.checkRowSetClosed();
        if (this.rowCstm != null) {
            this.rowCstm.setRowId(parameterIndex, x);
        }
    }

    @Override
    public void setRowId(String parameterName, RowId x) throws SQLException {
        this.checkRowSetClosed();
        if (this.rowCstm != null) {
            this.rowCstm.setRowId(parameterName, x);
        }
    }

    @Override
    public void setSQLXML(int parameterIndex, SQLXML xmlObject) throws SQLException {
        this.checkRowSetClosed();
        if (this.rowCstm != null) {
            this.rowCstm.setSQLXML(parameterIndex, xmlObject);
        }
    }

    @Override
    public void setSQLXML(String parameterName, SQLXML xmlObject) throws SQLException {
        this.checkRowSetClosed();
        if (this.rowCstm != null) {
            this.rowCstm.setSQLXML(parameterName, xmlObject);
        }
    }

    @Override
    public void setShort(int parameterIndex, short x) throws SQLException {
        this.checkRowSetClosed();
        if (this.rowCstm != null) {
            this.rowCstm.setShort(parameterIndex, x);
        }
    }

    @Override
    public void setShort(String parameterName, short x) throws SQLException {
        this.checkRowSetClosed();
        if (this.rowCstm != null) {
            this.rowCstm.setShort(parameterName, x);
        }
    }

    @Override
    public void setString(int parameterIndex, String x) throws SQLException {
        this.checkRowSetClosed();
        if (this.rowCstm != null) {
            this.rowCstm.setString(parameterIndex, x);
        }
    }

    @Override
    public void setString(String parameterName, String x) throws SQLException {
        this.checkRowSetClosed();
        if (this.rowCstm != null) {
            this.rowCstm.setString(parameterName, x);
        }
    }

    @Override
    public void setTime(int parameterIndex, Time x) throws SQLException {
        this.checkRowSetClosed();
        if (this.rowCstm != null) {
            this.rowCstm.setTime(parameterIndex, x);
        }
    }

    @Override
    public void setTime(String parameterName, Time x) throws SQLException {
        this.checkRowSetClosed();
        if (this.rowCstm != null) {
            this.rowCstm.setTime(parameterName, x);
        }
    }

    @Override
    public void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
        this.checkRowSetClosed();
        if (this.rowCstm != null) {
            this.rowCstm.setTime(parameterIndex, x, cal);
        }
    }

    @Override
    public void setTime(String parameterName, Time x, Calendar cal) throws SQLException {
        this.checkRowSetClosed();
        if (this.rowCstm != null) {
            this.rowCstm.setTime(parameterName, x, cal);
        }
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        this.checkRowSetClosed();
        if (this.rowCstm != null) {
            this.rowCstm.setTimestamp(parameterIndex, x);
        }
    }

    @Override
    public void setTimestamp(String parameterName, Timestamp x) throws SQLException {
        this.checkRowSetClosed();
        if (this.rowCstm != null) {
            this.rowCstm.setTimestamp(parameterName, x);
        }
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
        this.checkRowSetClosed();
        if (this.rowCstm != null) {
            this.rowCstm.setTimestamp(parameterIndex, x);
        }
    }

    @Override
    public void setTimestamp(String parameterName, Timestamp x, Calendar cal) throws SQLException {
        this.checkRowSetClosed();
        if (this.rowCstm != null) {
            this.rowCstm.setTimestamp(parameterName, x, cal);
        }
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
    }

    @Override
    public void setType(int type) throws SQLException {
        this.checkRowSetClosed();
        this.rowsetType = type;
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
    }

    @Override
    public void setURL(int parameterIndex, URL x) throws SQLException {
        this.checkRowSetClosed();
        if (this.rowCstm != null) {
            this.rowCstm.setURL(parameterIndex, x);
        }
    }

    @Override
    public void setUrl(String url) throws SQLException {
        this.url = url;
    }

    @Override
    public void setUsername(String name) throws SQLException {
        this.username = name;
    }

    protected Connection getConnection() throws SQLException {
        Connection con = null;
        if (this.rowsetConnection != null && !this.rowsetConnection.isClosed()) {
            con = this.rowsetConnection;
        } else if (this.getDataSourceName() != null) {
            try {
                InitialContext ctx = new InitialContext();
                DataSource ds = (DataSource)ctx.lookup(this.getDataSourceName());
                if (this.getUsername() != null && this.getPassword() != null) {
                    con = ds.getConnection(this.getUsername(), this.getPassword());
                }
                con = ds.getConnection();
            }
            catch (NamingException e) {
                throw Error.createSQLException(e.getMessage());
            }
        } else if (this.getUrl() != null) {
            if (!this.driverloaded) {
                DriverManager.registerDriver(new Driver());
                this.driverloaded = true;
            }
            String driverUrl = this.getUrl();
            String driverUser = this.getUsername();
            String driverPassword = this.getPassword();
            if (driverUrl.equals("") || driverUser.equals("") || driverPassword.equals("")) {
                throw Error.createSQLException("[E50074]\u6570\u636e\u5e93\u8fde\u63a5\u5f02\u5e38\uff1a\u8fde\u63a5\u4fe1\u606f\u3001\u7528\u6237\u540d\u3001\u5bc6\u7801\u6216\u4e3a\u7a7a", ReplaceEnum.excStr.getReplaceStr() + 50074, 50074);
            }
            con = DriverManager.getConnection(driverUrl, driverUser, driverPassword);
        }
        return con;
    }

    protected void checkRowSetClosed() throws SQLException {
        if (this.isClosed()) {
            throw Error.createSQLException("[E50039]RowSet: Rowset\u5bf9\u8c61\u5df2\u5173\u95ed", ReplaceEnum.excStr.getReplaceStr() + 50039, 50039);
        }
    }

    protected void checkRowIndexType(int type) throws SQLException {
        if (type < 0 && this.rowsetType == 1003) {
            throw Error.createSQLException("[E50039]RowSet: Rowset\u5bf9\u8c61\u5df2\u5173\u95ed", ReplaceEnum.excStr.getReplaceStr() + 50039, 50039);
        }
    }

    protected void checkRowSetUpdatableType() throws SQLException {
        if (this.concurrency == 1007) {
            throw Error.createSQLException("[E50088]ResultSet\u4e3a\u4e0d\u53ef\u66f4\u65b0\u7ed3\u679c\u96c6\uff0c\u65e0\u6cd5\u66f4\u65b0\u8bb0\u5f55\u6570\u636e", ReplaceEnum.excStr.getReplaceStr() + 50088, 50088);
        }
    }

    @Override
    public void setMatchColumn(int var1) throws SQLException {
    }

    @Override
    public void setMatchColumn(int[] var1) throws SQLException {
    }

    @Override
    public void setMatchColumn(String var1) throws SQLException {
    }

    @Override
    public void setMatchColumn(String[] var1) throws SQLException {
    }

    @Override
    public int[] getMatchColumnIndexes() throws SQLException {
        return null;
    }

    @Override
    public String[] getMatchColumnNames() throws SQLException {
        return null;
    }

    @Override
    public void unsetMatchColumn(int var1) throws SQLException {
    }

    @Override
    public void unsetMatchColumn(int[] var1) throws SQLException {
    }

    @Override
    public void unsetMatchColumn(String var1) throws SQLException {
    }

    @Override
    public void unsetMatchColumn(String[] var1) throws SQLException {
    }
}

