/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.docker;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.CharMatcher;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import com.spotify.docker.AbstractDockerMojo;
import com.spotify.docker.DockerBuildInformation;
import com.spotify.docker.Git;
import com.spotify.docker.Utils;
import com.spotify.docker.client.AnsiProgressHandler;
import com.spotify.docker.client.DockerClient;
import com.spotify.docker.client.ProgressHandler;
import com.spotify.docker.client.exceptions.DockerException;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigException;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigRenderOptions;
import com.typesafe.config.ConfigValue;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.PluginParameterExpressionEvaluator;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluationException;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.FileUtils;
import org.eclipse.jgit.api.errors.GitAPIException;

@Mojo(name="build", threadSafe=true)
public class BuildMojo
extends AbstractDockerMojo {
    private static final Lock LOCK = new ReentrantLock();
    private static final char UNIX_SEPARATOR = '/';
    private static final char WINDOWS_SEPARATOR = '\\';
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    @Parameter(property="dockerDirectory")
    private String dockerDirectory;
    @Parameter(property="skipDockerBuild", defaultValue="false")
    private boolean skipDockerBuild;
    @Parameter(property="pullOnBuild", defaultValue="false")
    private boolean pullOnBuild;
    @Parameter(property="noCache", defaultValue="false")
    private boolean noCache;
    @Parameter(property="rm", defaultValue="true")
    private boolean rm;
    @Parameter(property="saveImageToTarArchive")
    private String saveImageToTarArchive;
    @Parameter(property="pushImage", defaultValue="false")
    private boolean pushImage;
    @Parameter(property="pushImageTag", defaultValue="false")
    private boolean pushImageTag;
    @Parameter(property="forceTags", defaultValue="false")
    private boolean forceTags;
    @Parameter(property="dockerMaintainer")
    private String maintainer;
    @Parameter(property="dockerBaseImage")
    private String baseImage;
    @Parameter(property="dockerEntryPoint")
    private String entryPoint;
    @Parameter(property="dockerVolumes")
    private String[] volumes;
    @Parameter(property="dockerLabels")
    private String[] labels;
    @Parameter(property="dockerCmd")
    private String cmd;
    @Parameter(property="workdir")
    private String workdir;
    @Parameter(property="user")
    private String user;
    @Parameter(property="dockerRuns")
    private List<String> runs;
    private List<String> runList;
    @Parameter(property="squashRunCommands", defaultValue="false")
    private boolean squashRunCommands;
    @Parameter(property="project.build.directory")
    protected String buildDirectory;
    @Parameter(property="dockerBuildProfile")
    private String profile;
    @Parameter(property="tagInfoFile", defaultValue="${project.build.testOutputDirectory}/image_info.json")
    protected String tagInfoFile;
    @Parameter(property="useGitCommitId", defaultValue="false")
    private boolean useGitCommitId;
    @Parameter(property="dockerResources")
    private List<Resource> resources;
    @Parameter(property="dockerImageName")
    private String imageName;
    @Parameter(property="dockerImageTags")
    private List<String> imageTags;
    @Parameter(property="dockerDefaultBuildProfile")
    private String defaultProfile;
    @Parameter(property="dockerEnv")
    private Map<String, String> env;
    @Parameter(property="dockerExposes")
    private List<String> exposes;
    private Set<String> exposesSet;
    @Parameter(defaultValue="${project}")
    private MavenProject mavenProject;
    @Parameter(property="dockerBuildArgs")
    private Map<String, String> buildArgs;
    @Parameter(property="healthcheck")
    private Map<String, String> healthcheck;
    private PluginParameterExpressionEvaluator expressionEvaluator;

    public BuildMojo() {
        this(null);
    }

    public BuildMojo(String defaultProfile) {
        this.defaultProfile = defaultProfile;
    }

    public String getImageName() {
        return this.imageName;
    }

    public boolean getPushImage() {
        return this.pushImage;
    }

    public boolean getPushImageTag() {
        return this.pushImageTag;
    }

    public boolean getForceTags() {
        return this.forceTags;
    }

    private boolean weShouldSkipDockerBuild() {
        Path path;
        if (this.skipDockerBuild) {
            this.getLog().info((CharSequence)"Property skipDockerBuild is set");
            return true;
        }
        String packaging = this.session.getCurrentProject().getPackaging();
        if ("pom".equalsIgnoreCase(packaging)) {
            this.getLog().info((CharSequence)("Project packaging is " + packaging));
            return true;
        }
        if (this.dockerDirectory != null && !(path = Paths.get(this.dockerDirectory, "Dockerfile")).toFile().exists()) {
            this.getLog().info((CharSequence)"No Dockerfile in dockerDirectory");
            return true;
        }
        return false;
    }

    public boolean isSkipDockerBuild() {
        return this.skipDockerBuild;
    }

    @Override
    public void execute() throws MojoExecutionException {
        try {
            LOCK.lock();
            super.execute();
        }
        finally {
            LOCK.unlock();
        }
    }

    @Override
    protected void execute(DockerClient docker) throws MojoExecutionException, GitAPIException, IOException, DockerException, InterruptedException {
        String commitId;
        if (this.weShouldSkipDockerBuild()) {
            this.getLog().info((CharSequence)"Skipping docker build");
            return;
        }
        this.exposesSet = Sets.newTreeSet(this.exposes);
        if (this.runs != null) {
            this.runList = Lists.newArrayList(this.runs);
        }
        this.expressionEvaluator = new PluginParameterExpressionEvaluator(this.session, this.execution);
        Git git = new Git();
        String string = commitId = git.isRepository() ? git.getCommitId() : null;
        if (commitId == null) {
            String errorMessage = "Not a git repository, cannot get commit ID. Make sure git repository is initialized.";
            if (this.useGitCommitId || this.imageName != null && this.imageName.contains("${gitShortCommitId}")) {
                throw new MojoExecutionException("Not a git repository, cannot get commit ID. Make sure git repository is initialized.");
            }
            this.getLog().debug((CharSequence)"Not a git repository, cannot get commit ID. Make sure git repository is initialized.");
        } else {
            this.mavenProject.getProperties().put("gitShortCommitId", commitId);
            if (this.imageName != null) {
                this.imageName = this.expand(this.imageName);
            }
            if (this.baseImage != null) {
                this.baseImage = this.expand(this.baseImage);
            }
        }
        this.loadProfile();
        this.validateParameters();
        String[] repoTag = Utils.parseImageName(this.imageName);
        String repo = repoTag[0];
        String tag = repoTag[1];
        if (this.useGitCommitId) {
            if (tag != null) {
                this.getLog().warn((CharSequence)"Ignoring useGitCommitId flag because tag is explicitly set in image name ");
            } else {
                if (commitId == null) {
                    throw new MojoExecutionException("Cannot tag with git commit ID because directory not a git repo");
                }
                this.imageName = repo + ":" + commitId;
            }
        }
        this.mavenProject.getProperties().put("imageName", this.imageName);
        String destination = this.getDestination();
        if (this.dockerDirectory == null) {
            List<String> copiedPaths = this.copyResources(destination);
            this.createDockerFile(destination, copiedPaths);
        } else {
            Resource resource = new Resource();
            resource.setDirectory(this.dockerDirectory);
            this.resources.add(resource);
            this.copyResources(destination);
        }
        this.buildImage(docker, destination, this.buildParams());
        this.tagImage(docker, this.forceTags);
        DockerBuildInformation buildInfo = new DockerBuildInformation(this.imageName, this.getLog());
        if ("docker".equals(this.mavenProject.getPackaging())) {
            File imageArtifact = this.createImageArtifact(this.mavenProject.getArtifact(), buildInfo);
            this.mavenProject.getArtifact().setFile(imageArtifact);
        }
        if (this.pushImageTag) {
            Utils.pushImageTag(docker, this.imageName, this.imageTags, this.getLog(), this.isSkipDockerPush());
        }
        if (this.pushImage) {
            Utils.pushImage(docker, this.imageName, this.imageTags, this.getLog(), buildInfo, this.getRetryPushCount(), this.getRetryPushTimeout(), this.isSkipDockerPush());
        }
        if (this.saveImageToTarArchive != null) {
            Utils.saveImage(docker, this.imageName, Paths.get(this.saveImageToTarArchive, new String[0]), this.getLog());
        }
        Utils.writeImageInfoFile(buildInfo, this.tagInfoFile);
    }

    private String getDestination() {
        return Paths.get(this.buildDirectory, "docker").toString();
    }

    private File createImageArtifact(Artifact mainArtifact, DockerBuildInformation buildInfo) throws IOException {
        String fileName = MessageFormat.format("{0}-{1}-docker.jar", mainArtifact.getArtifactId(), mainArtifact.getVersion());
        File f = Paths.get(this.buildDirectory, fileName).toFile();
        try (JarOutputStream out = new JarOutputStream(new FileOutputStream(f));){
            JarEntry entry = new JarEntry(MessageFormat.format("META-INF/docker/{0}/{1}/image-info.json", mainArtifact.getGroupId(), mainArtifact.getArtifactId()));
            out.putNextEntry(entry);
            out.write(buildInfo.toJsonBytes());
        }
        return f;
    }

    private void loadProfile() throws MojoExecutionException {
        Config profileConfig;
        Config profiles;
        Config config = ConfigFactory.load();
        this.defaultProfile = this.get(this.defaultProfile, config, "docker.build.defaultProfile");
        if (this.profile == null) {
            if (this.defaultProfile == null) {
                this.getLog().debug((CharSequence)"Not using any build profile");
                return;
            }
            this.getLog().info((CharSequence)("Using default build profile: " + this.defaultProfile));
            this.profile = this.defaultProfile;
        } else {
            this.getLog().info((CharSequence)("Using build profile: " + this.profile));
        }
        try {
            profiles = config.getConfig("docker.build.profiles");
        }
        catch (ConfigException.Missing e) {
            profiles = ConfigFactory.empty();
        }
        try {
            profileConfig = profiles.getConfig(this.profile);
        }
        catch (ConfigException.Missing e) {
            this.getLog().error((CharSequence)("Docker build profile not found: " + this.profile));
            this.getLog().error((CharSequence)"Docker build profiles available:");
            for (String name : Ordering.natural().sortedCopy((Iterable)profiles.root().keySet())) {
                this.getLog().error((CharSequence)name);
            }
            throw new MojoExecutionException("Docker build profile not found: " + this.profile);
        }
        this.getLog().info((CharSequence)("Build profile: " + this.profile));
        this.getLog().info((CharSequence)profileConfig.root().render(ConfigRenderOptions.concise().setJson(true).setFormatted(true)));
        List resourceConfigs = Collections.emptyList();
        try {
            resourceConfigs = profileConfig.getConfigList("resources");
        }
        catch (ConfigException.Missing missing) {
            // empty catch block
        }
        for (Object resourceConfig : resourceConfigs) {
            Resource resource = new Resource();
            try {
                resource.setDirectory(this.expand(resourceConfig.getString("directory")));
            }
            catch (ConfigException.Missing e) {
                throw new MojoExecutionException("Invalid resource config, missing directory.", (Exception)((Object)e));
            }
            try {
                resource.setTargetPath(this.expand(resourceConfig.getString("targetPath")));
            }
            catch (ConfigException.Missing e) {
                // empty catch block
            }
            try {
                List includes = resourceConfig.getStringList("includes");
                ArrayList expanded = Lists.newArrayList();
                for (String raw : includes) {
                    expanded.add(this.expand(raw));
                }
                resource.setIncludes((List)expanded);
            }
            catch (ConfigException.Missing includes) {
                // empty catch block
            }
            this.resources.add(resource);
        }
        Config envConfig = ConfigFactory.empty();
        try {
            envConfig = profileConfig.getConfig("env");
        }
        catch (ConfigException.Missing resourceConfig) {
            // empty catch block
        }
        if (this.env == null) {
            this.env = Maps.newHashMap();
        }
        for (Map.Entry entry : envConfig.root().entrySet()) {
            String key = this.expand((String)entry.getKey());
            if (this.env.containsKey(key)) continue;
            this.env.put(key, this.expand(((ConfigValue)entry.getValue()).unwrapped().toString()));
        }
        List exposesList = Collections.emptyList();
        try {
            exposesList = profileConfig.getStringList("exposes");
        }
        catch (ConfigException.Missing missing) {
            // empty catch block
        }
        for (String raw : exposesList) {
            this.exposesSet.add(this.expand(raw));
        }
        try {
            this.runList.addAll(profileConfig.getStringList("runs"));
        }
        catch (ConfigException.Missing missing) {
            // empty catch block
        }
        this.imageName = this.get(this.imageName, profileConfig, "imageName");
        this.baseImage = this.get(this.baseImage, profileConfig, "baseImage");
        this.entryPoint = this.get(this.entryPoint, profileConfig, "entryPoint");
        this.cmd = this.get(this.cmd, profileConfig, "cmd");
        this.workdir = this.get(this.workdir, profileConfig, "workdir");
        this.user = this.get(this.user, profileConfig, "user");
    }

    private String get(String override, Config config, String path) throws MojoExecutionException {
        if (override != null) {
            return override;
        }
        try {
            return this.expand(config.getString(path));
        }
        catch (ConfigException.Missing e) {
            return null;
        }
    }

    private String expand(String raw) throws MojoExecutionException {
        Object value;
        try {
            value = this.expressionEvaluator.evaluate(raw);
        }
        catch (ExpressionEvaluationException e) {
            throw new MojoExecutionException("Expression evaluation failed: " + raw, (Exception)((Object)e));
        }
        if (value == null) {
            throw new MojoExecutionException("Undefined expression: " + raw);
        }
        return value.toString();
    }

    private void validateParameters() throws MojoExecutionException {
        if (this.dockerDirectory == null) {
            if (this.baseImage == null) {
                throw new MojoExecutionException("Must specify baseImage if dockerDirectory is null");
            }
        } else {
            if (this.baseImage != null) {
                this.getLog().warn((CharSequence)"Ignoring baseImage because dockerDirectory is set");
            }
            if (this.maintainer != null) {
                this.getLog().warn((CharSequence)"Ignoring maintainer because dockerDirectory is set");
            }
            if (this.entryPoint != null) {
                this.getLog().warn((CharSequence)"Ignoring entryPoint because dockerDirectory is set");
            }
            if (this.cmd != null) {
                this.getLog().warn((CharSequence)"Ignoring cmd because dockerDirectory is set");
            }
            if (this.runList != null && !this.runList.isEmpty()) {
                this.getLog().warn((CharSequence)"Ignoring run because dockerDirectory is set");
            }
            if (this.workdir != null) {
                this.getLog().warn((CharSequence)"Ignoring workdir because dockerDirectory is set");
            }
            if (this.user != null) {
                this.getLog().warn((CharSequence)"Ignoring user because dockerDirectory is set");
            }
        }
    }

    private void buildImage(DockerClient docker, String buildDir, DockerClient.BuildParam ... buildParams) throws MojoExecutionException, DockerException, IOException, InterruptedException {
        this.getLog().info((CharSequence)("Building image " + this.imageName));
        docker.build(Paths.get(buildDir, new String[0]), this.imageName, (ProgressHandler)new AnsiProgressHandler(), buildParams);
        this.getLog().info((CharSequence)("Built " + this.imageName));
    }

    private void tagImage(DockerClient docker, boolean forceTags) throws DockerException, InterruptedException, MojoExecutionException {
        String imageNameWithoutTag = Utils.parseImageName(this.imageName)[0];
        for (String imageTag : this.imageTags) {
            if (Strings.isNullOrEmpty((String)imageTag)) continue;
            this.getLog().info((CharSequence)("Tagging " + this.imageName + " with " + imageTag));
            docker.tag(this.imageName, imageNameWithoutTag + ":" + imageTag, forceTags);
        }
    }

    private void createDockerFile(String directory, List<String> filesToAdd) throws IOException {
        ArrayList commands = Lists.newArrayList();
        if (this.baseImage != null) {
            commands.add("FROM " + this.baseImage);
        }
        if (this.maintainer != null) {
            commands.add("MAINTAINER " + this.maintainer);
        }
        if (this.env != null) {
            Iterator<String> sortedKeys = Ordering.natural().sortedCopy(this.env.keySet());
            Iterator iterator = sortedKeys.iterator();
            while (iterator.hasNext()) {
                String key = (String)iterator.next();
                String value = this.env.get(key);
                commands.add(String.format("ENV %s %s", key, value));
            }
        }
        if (this.workdir != null) {
            commands.add("WORKDIR " + this.workdir);
        }
        for (String file : filesToAdd) {
            commands.add(String.format("ADD %s %s", file.replaceAll("\\$", "\\\\\\$"), this.normalizeDest(file)));
        }
        if (this.runList != null && !this.runList.isEmpty()) {
            if (this.squashRunCommands) {
                commands.add("RUN " + Joiner.on((String)" &&\\\n\t").join(this.runList));
            } else {
                for (String run : this.runList) {
                    commands.add("RUN " + run);
                }
            }
        }
        if (this.healthcheck != null && this.healthcheck.containsKey("cmd")) {
            StringBuffer healthcheckBuffer = new StringBuffer("HEALTHCHECK ");
            if (this.healthcheck.containsKey("options")) {
                healthcheckBuffer.append(this.healthcheck.get("options"));
                healthcheckBuffer.append(" ");
            }
            healthcheckBuffer.append("CMD ");
            healthcheckBuffer.append(this.healthcheck.get("cmd"));
            commands.add(healthcheckBuffer.toString());
        }
        if (this.exposesSet.size() > 0) {
            commands.add("EXPOSE " + Joiner.on((String)" ").join(this.exposesSet));
        }
        if (this.user != null) {
            commands.add("USER " + this.user);
        }
        if (this.entryPoint != null) {
            commands.add("ENTRYPOINT " + this.entryPoint);
        }
        if (this.cmd != null) {
            if (this.entryPoint != null) {
                if (this.cmd.startsWith("[") && this.cmd.endsWith("]")) {
                    commands.add("CMD " + this.cmd);
                } else {
                    ImmutableList args = ImmutableList.copyOf((Iterable)Splitter.on((CharMatcher)CharMatcher.WHITESPACE).omitEmptyStrings().split((CharSequence)this.cmd));
                    StringBuilder cmdBuilder = new StringBuilder("[");
                    for (String arg : args) {
                        cmdBuilder.append('\"').append(arg).append('\"');
                    }
                    cmdBuilder.append(']');
                    String cmdString = cmdBuilder.toString();
                    commands.add("CMD " + cmdString);
                    this.getLog().warn((CharSequence)"Entrypoint provided but cmd is not an explicit list. Attempting to generate CMD string in the form of an argument list.");
                    this.getLog().warn((CharSequence)("CMD " + cmdString));
                }
            } else {
                commands.add("CMD " + this.cmd);
            }
        }
        if (this.volumes != null) {
            for (String volume : this.volumes) {
                commands.add("VOLUME " + volume);
            }
        }
        if (this.labels != null) {
            for (String label : this.labels) {
                commands.add("LABEL " + label);
            }
        }
        this.getLog().debug((CharSequence)("Writing Dockerfile:" + System.lineSeparator() + Joiner.on((String)System.lineSeparator()).join((Iterable)commands)));
        Files.createDirectories(Paths.get(directory, new String[0]), new FileAttribute[0]);
        Files.write(Paths.get(directory, "Dockerfile"), (Iterable<? extends CharSequence>)commands, StandardCharsets.UTF_8, new OpenOption[0]);
    }

    private String normalizeDest(String filePath) {
        File file = new File(filePath);
        String dest = new File(this.getDestination(), filePath).isFile() ? (file.getParent() != null ? BuildMojo.separatorsToUnix(file.getParent()) + "/" : ".") : BuildMojo.separatorsToUnix(file.getPath());
        return dest;
    }

    private List<String> copyResources(String destination) throws IOException {
        ArrayList allCopiedPaths = Lists.newArrayList();
        for (Resource resource : this.resources) {
            String targetPath;
            File source = new File(resource.getDirectory());
            List includes = resource.getIncludes();
            List excludes = resource.getExcludes();
            DirectoryScanner scanner = new DirectoryScanner();
            scanner.setBasedir(source);
            scanner.setIncludes(includes.isEmpty() ? null : includes.toArray(new String[includes.size()]));
            scanner.setExcludes(excludes.isEmpty() ? null : excludes.toArray(new String[excludes.size()]));
            scanner.scan();
            String[] includedFiles = scanner.getIncludedFiles();
            if (includedFiles.length == 0) {
                this.getLog().info((CharSequence)"No resources will be copied, no files match specified patterns");
            }
            ArrayList copiedPaths = Lists.newArrayList();
            boolean copyWholeDir = includes.isEmpty() && excludes.isEmpty() && resource.getTargetPath() != null;
            String string = targetPath = resource.getTargetPath() == null ? "" : resource.getTargetPath();
            if (copyWholeDir) {
                Path destPath = Paths.get(destination, targetPath);
                this.getLog().info((CharSequence)String.format("Copying dir %s -> %s", source, destPath));
                Files.createDirectories(destPath, new FileAttribute[0]);
                FileUtils.copyDirectoryStructure((File)source, (File)destPath.toFile());
                copiedPaths.add(BuildMojo.separatorsToUnix(targetPath));
            } else {
                for (String included : includedFiles) {
                    Path sourcePath = Paths.get(resource.getDirectory(), new String[0]).resolve(included);
                    Path destPath = Paths.get(destination, targetPath).resolve(included);
                    this.getLog().info((CharSequence)String.format("Copying %s -> %s", sourcePath, destPath));
                    Files.createDirectories(destPath.getParent(), new FileAttribute[0]);
                    Files.copy(sourcePath, destPath, StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.COPY_ATTRIBUTES);
                    copiedPaths.add(BuildMojo.separatorsToUnix(Paths.get(targetPath, new String[0]).resolve(included).toString()));
                }
            }
            Collections.sort(copiedPaths);
            allCopiedPaths.addAll(copiedPaths);
        }
        return allCopiedPaths;
    }

    public static String separatorsToUnix(String path) {
        if (path == null || path.indexOf(92) == -1) {
            return path;
        }
        return path.replace('\\', '/');
    }

    private DockerClient.BuildParam[] buildParams() throws UnsupportedEncodingException, JsonProcessingException {
        ArrayList buildParams = Lists.newArrayList();
        if (this.pullOnBuild) {
            buildParams.add(DockerClient.BuildParam.pullNewerImage());
        }
        if (this.noCache) {
            buildParams.add(DockerClient.BuildParam.noCache());
        }
        if (!this.rm) {
            buildParams.add(DockerClient.BuildParam.rm((boolean)false));
        }
        if (!this.buildArgs.isEmpty()) {
            buildParams.add(DockerClient.BuildParam.create((String)"buildargs", (String)URLEncoder.encode(OBJECT_MAPPER.writeValueAsString(this.buildArgs), "UTF-8")));
        }
        return buildParams.toArray(new DockerClient.BuildParam[buildParams.size()]);
    }
}

