/*
 * Decompiled with CFR 0.152.
 */
package com.redis.lettucemod.search;

import com.redis.lettucemod.protocol.SearchCommandKeyword;
import com.redis.lettucemod.search.Field;
import com.redis.lettucemod.search.SearchCommandArgs;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;

public class TagField<K>
extends Field<K> {
    private Optional<Character> separator = Optional.empty();
    private boolean caseSensitive;
    private boolean withSuffixTrie;

    private TagField(Builder<K> builder) {
        super(Field.Type.TAG, builder);
        this.separator = builder.separator;
        this.caseSensitive = builder.caseSensitive;
        this.withSuffixTrie = builder.withSuffixTrie;
    }

    public Optional<Character> getSeparator() {
        return this.separator;
    }

    public void setSeparator(char separator) {
        this.separator = Optional.of(Character.valueOf(separator));
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    public void setCaseSensitive(boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
    }

    public boolean isWithSuffixTrie() {
        return this.withSuffixTrie;
    }

    public void setWithSuffixTrie(boolean withSuffixTrie) {
        this.withSuffixTrie = withSuffixTrie;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Objects.hash(this.caseSensitive, this.separator, this.withSuffixTrie);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TagField other = (TagField)obj;
        return this.caseSensitive == other.caseSensitive && Objects.equals(this.separator, other.separator) && this.withSuffixTrie == other.withSuffixTrie;
    }

    @Override
    protected void buildField(SearchCommandArgs<K, Object> args) {
        args.add(SearchCommandKeyword.TAG);
        this.separator.ifPresent(s -> args.add(SearchCommandKeyword.SEPARATOR).add(String.valueOf(s)));
        if (this.caseSensitive) {
            args.add(SearchCommandKeyword.CASESENSITIVE);
        }
        if (this.withSuffixTrie) {
            args.add(SearchCommandKeyword.WITHSUFFIXTRIE);
        }
    }

    public static <K> Builder<K> name(K name) {
        return new Builder<K>(name);
    }

    @Generated
    public String toString() {
        return "TagField(separator=" + String.valueOf(this.getSeparator()) + ", caseSensitive=" + this.isCaseSensitive() + ", withSuffixTrie=" + this.isWithSuffixTrie() + ")";
    }

    public static class Builder<K>
    extends Field.Builder<K, Builder<K>> {
        private Optional<Character> separator = Optional.empty();
        private boolean caseSensitive;
        private boolean withSuffixTrie;

        public Builder(K name) {
            super(name);
        }

        public Builder<K> separator(char separator) {
            this.separator = Optional.of(Character.valueOf(separator));
            return this;
        }

        public Builder<K> caseSensitive() {
            return this.caseSensitive(true);
        }

        public Builder<K> caseSensitive(boolean caseSensitive) {
            this.caseSensitive = caseSensitive;
            return this;
        }

        public Builder<K> withSuffixTrie() {
            return this.withSuffixTrie(true);
        }

        public Builder<K> withSuffixTrie(boolean withSuffixTrie) {
            this.withSuffixTrie = withSuffixTrie;
            return this;
        }

        public TagField<K> build() {
            return new TagField(this);
        }
    }
}

