/*
 * Decompiled with CFR 0.152.
 */
package com.redis.lettucemod.output;

import com.redis.lettucemod.search.Document;
import com.redis.lettucemod.search.SearchResults;
import io.lettuce.core.codec.RedisCodec;
import io.lettuce.core.internal.LettuceStrings;
import io.lettuce.core.output.CommandOutput;
import io.lettuce.core.output.MapOutput;
import java.nio.ByteBuffer;
import java.util.Map;

public class SearchOutput<K, V>
extends CommandOutput<K, V, SearchResults<K, V>> {
    private final boolean withScores;
    private final boolean withSortKeys;
    private final boolean withPayloads;
    private boolean sortKeySet = false;
    private boolean scoreSet = false;
    private boolean payloadSet = false;
    private MapOutput<K, V> contentOutput;
    private Document<K, V> currentDocument;

    public SearchOutput(RedisCodec<K, V> codec) {
        this(codec, false, false, false);
    }

    public SearchOutput(RedisCodec<K, V> codec, boolean withScores, boolean withSortKeys, boolean withPayloads) {
        super(codec, new SearchResults());
        this.withScores = withScores;
        this.withSortKeys = withSortKeys;
        this.withPayloads = withPayloads;
    }

    public void set(ByteBuffer bytes) {
        if (this.currentDocument == null) {
            this.currentDocument = new Document();
            if (bytes != null) {
                this.currentDocument.setId(this.codec.decodeKey(bytes));
            }
            return;
        }
        if (this.withScores && !this.scoreSet) {
            if (bytes != null) {
                this.currentDocument.setScore(LettuceStrings.toDouble((String)this.decodeString(bytes)));
            }
            this.scoreSet = true;
            return;
        }
        if (this.withPayloads && !this.payloadSet) {
            if (bytes != null) {
                this.currentDocument.setPayload(this.codec.decodeValue(bytes));
            }
            this.payloadSet = true;
            return;
        }
        if (this.withSortKeys && !this.sortKeySet) {
            if (bytes != null) {
                this.currentDocument.setSortKey(this.codec.decodeValue(bytes));
            }
            this.sortKeySet = true;
            return;
        }
        if (this.contentOutput != null) {
            this.contentOutput.set(bytes);
            return;
        }
        if (bytes == null) {
            this.startNewDocument();
        }
    }

    public void set(long integer) {
        ((SearchResults)this.output).setCount(integer);
    }

    public void set(double number) {
        if (this.withScores && !this.scoreSet) {
            this.currentDocument.setScore(number);
            this.scoreSet = true;
        }
    }

    public void complete(int depth) {
        if (this.contentOutput != null && depth == 1) {
            this.currentDocument.putAll((Map)this.contentOutput.get());
            ((SearchResults)this.output).add(this.currentDocument);
            this.startNewDocument();
        }
    }

    private void startNewDocument() {
        this.currentDocument = null;
        this.contentOutput = null;
        this.payloadSet = false;
        this.scoreSet = false;
        this.sortKeySet = false;
    }

    public void multi(int count) {
        if (this.currentDocument != null) {
            this.contentOutput = new MapOutput(this.codec);
            this.contentOutput.multi(count);
        }
    }

    public boolean hasError() {
        return super.hasError() && !this.getError().startsWith("Success");
    }
}

