/*
 * Decompiled with CFR 0.152.
 */
package com.redis.lettucemod.bloom;

import com.redis.lettucemod.protocol.BloomCommandKeyword;
import io.lettuce.core.CompositeArgument;
import io.lettuce.core.protocol.CommandArgs;
import io.lettuce.core.protocol.ProtocolKeyword;
import java.util.OptionalInt;

public class BloomFilterReserveOptions
implements CompositeArgument {
    private OptionalInt expansion = OptionalInt.empty();
    private boolean nonScaling;

    public BloomFilterReserveOptions() {
    }

    private BloomFilterReserveOptions(Builder builder) {
        this.nonScaling = builder.nonScaling;
        this.expansion = builder.expansion;
    }

    public OptionalInt getExpansion() {
        return this.expansion;
    }

    public void setExpansion(OptionalInt expansion) {
        this.expansion = expansion;
    }

    public boolean isNonScaling() {
        return this.nonScaling;
    }

    public void setNonScaling(boolean nonScaling) {
        this.nonScaling = nonScaling;
    }

    public <K, V> void build(CommandArgs<K, V> args) {
        this.expansion.ifPresent(e -> args.add((ProtocolKeyword)BloomCommandKeyword.EXPANSION).add((long)e));
        if (this.nonScaling) {
            args.add((ProtocolKeyword)BloomCommandKeyword.NONSCALING);
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private OptionalInt expansion = OptionalInt.empty();
        private boolean nonScaling;

        public Builder nonScaling(boolean nonScaling) {
            this.nonScaling = nonScaling;
            return this;
        }

        public Builder expansion(int expansion) {
            this.expansion = OptionalInt.of(expansion);
            return this;
        }

        public BloomFilterReserveOptions build() {
            return new BloomFilterReserveOptions(this);
        }
    }
}

