/*
 * Decompiled with CFR 0.152.
 */
package com.redis.lettucemod.search;

import com.redis.lettucemod.protocol.SearchCommandKeyword;
import com.redis.lettucemod.search.Field;
import com.redis.lettucemod.search.SearchCommandArgs;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;

public class VectorField<K>
extends Field<K> {
    private final SearchCommandKeyword algorithm;
    private final SearchCommandKeyword vectorType;
    private final int dim;
    private final SearchCommandKeyword distanceMetric;
    private final Optional<Integer> initialCap;
    private final Optional<Integer> blockSize;
    private final Optional<Integer> m;
    private final Optional<Integer> efConstruction;
    private final Optional<Integer> efRuntime;
    private final Optional<Float> epsilon;

    private VectorField(Builder<K> builder) {
        super(Field.Type.VECTOR, builder);
        this.algorithm = ((Builder)builder).algorithm;
        this.vectorType = ((Builder)builder).vectorType;
        this.dim = ((Builder)builder).dim;
        this.distanceMetric = ((Builder)builder).distanceMetric;
        this.initialCap = Optional.ofNullable(((Builder)builder).initialCap);
        this.blockSize = Optional.ofNullable(((Builder)builder).blockSize);
        this.m = Optional.ofNullable(((Builder)builder).m);
        this.efConstruction = Optional.ofNullable(((Builder)builder).efConstruction);
        this.efRuntime = Optional.ofNullable(((Builder)builder).efRuntime);
        this.epsilon = Optional.ofNullable(((Builder)builder).epsilon);
    }

    public static <K> Builder<K> name(K name) {
        return new Builder<K>(name);
    }

    @Override
    protected void buildField(SearchCommandArgs<K, Object> args) {
        args.add(SearchCommandKeyword.VECTOR).add(this.algorithm).add(this.getOptionSize()).add(SearchCommandKeyword.TYPE).add(this.vectorType).add(SearchCommandKeyword.DIM).addValue(String.valueOf(this.dim)).add(SearchCommandKeyword.DISTANCE_METRIC).add(this.distanceMetric);
        this.initialCap.ifPresent(i -> args.add(SearchCommandKeyword.INITIAL_CAP).add(i.intValue()));
        if (SearchCommandKeyword.FLAT.equals((Object)this.algorithm)) {
            this.blockSize.ifPresent(i -> args.add(SearchCommandKeyword.BLOCK_SIZE).add(i.intValue()));
        } else if (SearchCommandKeyword.HNSW.equals((Object)this.algorithm)) {
            this.m.ifPresent(i -> args.add(SearchCommandKeyword.M).add(i.intValue()));
            this.efConstruction.ifPresent(i -> args.add(SearchCommandKeyword.EF_CONSTRUCTION).add(i.intValue()));
            this.efRuntime.ifPresent(i -> args.add(SearchCommandKeyword.EF_RUNTIME).add(i.intValue()));
            this.epsilon.ifPresent(f -> args.add(SearchCommandKeyword.EPSILON).add(f.floatValue()));
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        VectorField that = (VectorField)o;
        return this.dim == that.dim && this.algorithm == that.algorithm && this.vectorType == that.vectorType && this.distanceMetric == that.distanceMetric && Objects.equals(this.initialCap, that.initialCap) && Objects.equals(this.blockSize, that.blockSize) && Objects.equals(this.m, that.m) && Objects.equals(this.efConstruction, that.efConstruction) && Objects.equals(this.efRuntime, that.efRuntime) && Objects.equals(this.epsilon, that.epsilon);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.algorithm, this.vectorType, this.dim, this.distanceMetric, this.initialCap, this.blockSize, this.m, this.efConstruction, this.efRuntime, this.epsilon});
    }

    private int getOptionSize() {
        int optionSize = 6;
        if (SearchCommandKeyword.FLAT.equals((Object)this.algorithm)) {
            if (this.initialCap.isPresent()) {
                optionSize += 2;
            }
            if (this.blockSize.isPresent()) {
                optionSize += 2;
            }
            return optionSize;
        }
        if (SearchCommandKeyword.HNSW.equals((Object)this.algorithm)) {
            if (this.initialCap.isPresent()) {
                optionSize += 2;
            }
            if (this.m.isPresent()) {
                optionSize += 2;
            }
            if (this.efConstruction.isPresent()) {
                optionSize += 2;
            }
            if (this.efRuntime.isPresent()) {
                optionSize += 2;
            }
            if (this.epsilon.isPresent()) {
                optionSize += 2;
            }
            return optionSize;
        }
        throw new IllegalArgumentException("Unknown vector algorithm type: " + (Object)((Object)this.algorithm));
    }

    @Generated
    public String toString() {
        return "VectorField(algorithm=" + (Object)((Object)this.algorithm) + ", vectorType=" + (Object)((Object)this.vectorType) + ", dim=" + this.dim + ", distanceMetric=" + (Object)((Object)this.distanceMetric) + ", initialCap=" + this.initialCap + ", blockSize=" + this.blockSize + ", m=" + this.m + ", efConstruction=" + this.efConstruction + ", efRuntime=" + this.efRuntime + ", epsilon=" + this.epsilon + ")";
    }

    public static class Builder<K>
    extends Field.Builder<K, Builder<K>> {
        private SearchCommandKeyword algorithm;
        private SearchCommandKeyword vectorType;
        private int dim;
        private SearchCommandKeyword distanceMetric;
        private Integer initialCap;
        private Integer blockSize;
        private Integer m;
        private Integer efConstruction;
        private Integer efRuntime;
        private Float epsilon;

        public Builder(K name) {
            super(name);
        }

        public Builder<K> algorithm(SearchCommandKeyword algorithm) {
            this.algorithm = algorithm;
            return this;
        }

        public Builder<K> vectorType(SearchCommandKeyword type) {
            this.vectorType = type;
            return this;
        }

        public Builder<K> dim(int dim) {
            this.dim = dim;
            return this;
        }

        public Builder<K> distanceMetric(SearchCommandKeyword distanceMetric) {
            this.distanceMetric = distanceMetric;
            return this;
        }

        public Builder<K> initialCap(Integer initialCap) {
            this.initialCap = initialCap;
            return this;
        }

        public Builder<K> blockSize(Integer blockSize) {
            this.blockSize = blockSize;
            return this;
        }

        public Builder<K> m(Integer m) {
            this.m = m;
            return this;
        }

        public Builder<K> efConstruction(Integer efConstruction) {
            this.efConstruction = efConstruction;
            return this;
        }

        public Builder<K> efRuntime(Integer efRuntime) {
            this.efRuntime = efRuntime;
            return this;
        }

        public Builder<K> epsilon(Float epsilon) {
            this.epsilon = epsilon;
            return this;
        }

        public VectorField<K> build() {
            return new VectorField(this);
        }
    }
}

