/*
 * Decompiled with CFR 0.152.
 */
package com.redis.lettucemod.search;

import com.redis.lettucemod.protocol.SearchCommandKeyword;
import com.redis.lettucemod.search.AggregateOperation;
import com.redis.lettucemod.search.Reducer;
import com.redis.lettucemod.search.Reducers;
import com.redis.lettucemod.search.SearchCommandArgs;
import io.lettuce.core.internal.LettuceAssert;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import lombok.Generated;

public class Group
implements AggregateOperation {
    private final String[] properties;
    private final Reducer[] reducers;

    public Group(String[] properties, Reducer[] reducers) {
        LettuceAssert.notNull((Object)properties, (String)"Properties must not be null");
        LettuceAssert.noNullElements((Object[])properties, (String)"Property elements must not be null");
        LettuceAssert.notEmpty((Object[])reducers, (String)"Group must have at least one reducer");
        LettuceAssert.noNullElements((Object[])reducers, (String)"Reducer elements must not be null");
        this.properties = properties;
        this.reducers = reducers;
    }

    @Override
    public AggregateOperation.Type getType() {
        return AggregateOperation.Type.GROUP;
    }

    public String[] getProperties() {
        return this.properties;
    }

    public Reducer[] getReducers() {
        return this.reducers;
    }

    @Override
    public void build(SearchCommandArgs args) {
        args.add(SearchCommandKeyword.GROUPBY);
        args.add(this.properties.length);
        for (String property : this.properties) {
            args.addProperty(property);
        }
        for (Reducer reducer : this.reducers) {
            reducer.build(args);
        }
    }

    public static Builder by(String ... properties) {
        return new Builder(properties);
    }

    @Generated
    public String toString() {
        return "Group(properties=" + Arrays.deepToString(this.getProperties()) + ", reducers=" + Arrays.deepToString(this.getReducers()) + ")";
    }

    public static class Builder {
        private final List<String> properties = new ArrayList<String>();
        private final List<Reducer> reducers = new ArrayList<Reducer>();

        public Builder(String ... properties) {
            Collections.addAll(this.properties, properties);
        }

        public Builder property(String property) {
            return new Builder(property);
        }

        public Builder avg(Reducers.Avg avg) {
            return this.reducer(avg);
        }

        public Builder count(Reducers.Count count) {
            return this.reducer(count);
        }

        public Builder countDistinct(Reducers.CountDistinct countDistinct) {
            return this.reducer(countDistinct);
        }

        public Builder countDistinctish(Reducers.CountDistinctish countDistinctish) {
            return this.reducer(countDistinctish);
        }

        public Builder firstValue(Reducers.FirstValue firstValue) {
            return this.reducer(firstValue);
        }

        public Builder min(Reducers.Min min) {
            return this.reducer(min);
        }

        public Builder max(Reducers.Max max) {
            return this.reducer(max);
        }

        public Builder quantile(Reducers.Quantile quantile) {
            return this.reducer(quantile);
        }

        public Builder randomSample(Reducers.RandomSample randomSample) {
            return this.reducer(randomSample);
        }

        public Builder stdDev(Reducers.StdDev stdDev) {
            return this.reducer(stdDev);
        }

        public Builder sum(Reducers.Sum sum) {
            return this.reducer(sum);
        }

        public Builder toList(Reducers.ToList toList) {
            return this.reducer(toList);
        }

        public Builder reducer(Reducer reducer) {
            return this.reducers(reducer);
        }

        public Builder reducers(Reducer ... reducers) {
            Collections.addAll(this.reducers, reducers);
            return this;
        }

        public Group build() {
            return new Group(this.properties.toArray(new String[0]), this.reducers.toArray(new Reducer[0]));
        }
    }
}

