/*
 * Decompiled with CFR 0.152.
 */
package com.redis.lettucemod.output;

import com.redis.lettucemod.output.OutputFactory;
import io.lettuce.core.codec.RedisCodec;
import io.lettuce.core.internal.LettuceAssert;
import io.lettuce.core.output.CommandOutput;
import io.lettuce.core.output.ListSubscriber;
import io.lettuce.core.output.StreamingOutput;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

public class OptionalValueListOutput<K, V>
extends CommandOutput<K, V, List<Optional<V>>>
implements StreamingOutput<Optional<V>> {
    private boolean initialized;
    private StreamingOutput.Subscriber<Optional<V>> subscriber;

    public OptionalValueListOutput(RedisCodec<K, V> codec) {
        super(codec, Collections.emptyList());
        this.setSubscriber((StreamingOutput.Subscriber<Optional<V>>)ListSubscriber.instance());
    }

    public void set(ByteBuffer bytes) {
        this.subscriber.onNext((Collection)this.output, bytes == null ? Optional.empty() : Optional.of(this.codec.decodeValue(bytes)));
    }

    public void multi(int count) {
        if (!this.initialized) {
            this.output = OutputFactory.newList(count);
            this.initialized = true;
        }
    }

    public void setSubscriber(StreamingOutput.Subscriber<Optional<V>> subscriber) {
        LettuceAssert.notNull(subscriber, (String)"Subscriber must not be null");
        this.subscriber = subscriber;
    }

    public StreamingOutput.Subscriber<Optional<V>> getSubscriber() {
        return this.subscriber;
    }
}

