/**
 *
 * (c) Copyright Ascensio System SIA 2025
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */


package com.onlyoffice.model.documenteditor;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.onlyoffice.model.documenteditor.formdata.FormSpecificType;
import lombok.Builder;
import lombok.Getter;
import lombok.Setter;

/**
 * Defines the submitted form data.
 */
@Getter
@Setter
@Builder
@JsonInclude(JsonInclude.Include.NON_ABSENT)
public class FormData {

    /**
     * The form key. If the current form is a radio button, then this field contains the form group key.
     */
    private String key;

    /**
     * The form tag.
     */
    private String tag;

    /**
     *  The current form value.
     */
    private String value;

    /**
     *  The form type.
     */
    private FormSpecificType type;
}
