/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.jdbc.credential;

public class Credential {
    private String user;
    private String password;
    private String proxyUser;

    public Credential(String user, String password) {
        this.user = user;
        this.password = password;
    }

    public Credential(String user, String password, boolean useProxyUser) {
        this.user = user;
        this.password = password;
        if (useProxyUser) {
            this.setUsernameAndProxyUsername();
        }
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getPassword() {
        return this.password;
    }

    public String getProxyUser() {
        return this.proxyUser;
    }

    public void setProxyUser(String proxyUser) {
        this.proxyUser = proxyUser;
    }

    private void setUsernameAndProxyUsername() {
        String originUsername = this.user;
        String username = this.user;
        try {
            username = username.trim();
            int len = username.length();
            int[] user_pos = new int[]{0, len};
            int[] proxy_user_pos = new int[2];
            int left_info_pos = len;
            int lastChar = 0;
            boolean hasQuota = false;
            char[] usernameCharArray = username.toCharArray();
            for (int i = 0; i < usernameCharArray.length; ++i) {
                int currentChar = usernameCharArray[i];
                if (i == 0 && (currentChar == 39 || currentChar == 34)) {
                    hasQuota = true;
                }
                if (hasQuota && currentChar == 91 && (lastChar == 39 || lastChar == 34)) {
                    user_pos[1] = i;
                    proxy_user_pos[0] = i + 1;
                }
                if (!hasQuota && currentChar == 91 && proxy_user_pos[0] == 0) {
                    user_pos[1] = i;
                    proxy_user_pos[0] = i + 1;
                }
                if (currentChar == 93 && proxy_user_pos[0] != 0) {
                    proxy_user_pos[1] = i;
                    left_info_pos = i;
                }
                lastChar = currentChar;
            }
            if (proxy_user_pos[0] != 0 && proxy_user_pos[1] >= proxy_user_pos[0]) {
                this.user = username.substring(user_pos[0], user_pos[1]) + username.substring(Math.min(left_info_pos + 1, len));
                this.proxyUser = username.substring(proxy_user_pos[0], proxy_user_pos[1]);
            } else {
                this.user = originUsername;
                this.proxyUser = "";
            }
        }
        catch (Exception e) {
            this.user = originUsername;
            this.proxyUser = "";
        }
    }
}

