/*
 * Decompiled with CFR 0.152.
 */
package com.mybatisflex.core.dialect;

import com.mybatisflex.core.FlexGlobalConfig;
import com.mybatisflex.core.dialect.DbType;
import com.mybatisflex.core.dialect.DialectFactory;
import com.mybatisflex.core.exception.FlexExceptions;
import com.mybatisflex.core.exception.locale.LocalizedFormats;
import com.mybatisflex.core.util.StringUtil;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.util.regex.Pattern;
import javax.sql.DataSource;

public class DbTypeUtil {
    private DbTypeUtil() {
    }

    public static DbType getCurrentDbType() {
        DbType dbType = FlexGlobalConfig.getDefaultConfig().getDbType();
        if (dbType == null) {
            dbType = DialectFactory.getHintDbType();
        }
        return dbType;
    }

    public static DbType getDbType(DataSource dataSource) {
        String jdbcUrl = DbTypeUtil.getJdbcUrl(dataSource);
        if (StringUtil.hasText(jdbcUrl)) {
            DbType sqlserverDbType;
            if (jdbcUrl.contains(":sqlserver:") && (sqlserverDbType = DbTypeUtil.getSqlserverDbType(dataSource)) != null) {
                return sqlserverDbType;
            }
            return DbTypeUtil.parseDbType(jdbcUrl);
        }
        throw new IllegalStateException("Can not get dataSource jdbcUrl: " + dataSource.getClass().getName());
    }

    /*
     * Exception decompiling
     */
    private static DbType getSqlserverDbType(DataSource dataSource) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getJdbcUrl(DataSource dataSource) {
        String[] methodNames;
        for (String methodName : methodNames = new String[]{"getUrl", "getJdbcUrl"}) {
            try {
                Method method = dataSource.getClass().getMethod(methodName, new Class[0]);
                return (String)method.invoke((Object)dataSource, new Object[0]);
            }
            catch (Exception exception) {
            }
        }
        try (Connection connection = dataSource.getConnection();){
            String string = connection.getMetaData().getURL();
            return string;
        }
        catch (Exception e) {
            throw FlexExceptions.wrap((Throwable)e, LocalizedFormats.DATASOURCE_JDBC_URL, new Object[0]);
        }
    }

    public static DbType parseDbType(String jdbcUrl) {
        if ((jdbcUrl = jdbcUrl.toLowerCase()).contains(":ch:") || jdbcUrl.contains(":clickhouse:")) {
            return DbType.CLICK_HOUSE;
        }
        if (jdbcUrl.contains(":cobar:")) {
            return DbType.MYSQL;
        }
        if (jdbcUrl.contains(":csiidb:")) {
            return DbType.CSIIDB;
        }
        if (jdbcUrl.contains(":cubrid:")) {
            return DbType.CUBRID;
        }
        if (jdbcUrl.contains(":db2:")) {
            return DbType.DB2;
        }
        if (jdbcUrl.contains(":derby:")) {
            return DbType.DERBY;
        }
        if (DbTypeUtil.isMatchedRegex(":dm\\d*:", jdbcUrl)) {
            return DbType.DM;
        }
        if (jdbcUrl.contains(":duckdb:")) {
            return DbType.DUCKDB;
        }
        if (jdbcUrl.contains(":firebirdsql:")) {
            return DbType.FIREBIRD;
        }
        if (jdbcUrl.contains(":gaussdb:") || jdbcUrl.contains(":zenith:")) {
            return DbType.GAUSS;
        }
        if (jdbcUrl.contains(":gbase:")) {
            return DbType.GBASE;
        }
        if (jdbcUrl.contains(":gbase8c:")) {
            return DbType.GBASE_8C;
        }
        if (jdbcUrl.contains(":gbase8s-pg:")) {
            return DbType.GBASE_8S_PG;
        }
        if (jdbcUrl.contains(":gbasedbt-sqli:") || jdbcUrl.contains(":informix-sqli:")) {
            return DbType.GBASE_8S;
        }
        if (jdbcUrl.contains(":goldendb:")) {
            return DbType.GOLDENDB;
        }
        if (jdbcUrl.contains(":goldilocks:")) {
            return DbType.GOLDILOCKS;
        }
        if (jdbcUrl.contains(":greenplum:")) {
            return DbType.GREENPLUM;
        }
        if (jdbcUrl.contains(":h2:")) {
            return DbType.H2;
        }
        if (jdbcUrl.contains(":highgo:")) {
            return DbType.HIGH_GO;
        }
        if (jdbcUrl.contains(":hive2:") || jdbcUrl.contains(":inceptor2:")) {
            return DbType.HIVE;
        }
        if (jdbcUrl.contains(":hsqldb:")) {
            return DbType.HSQL;
        }
        if (jdbcUrl.contains(":impala:")) {
            return DbType.IMPALA;
        }
        if (jdbcUrl.contains(":informix")) {
            return DbType.INFORMIX;
        }
        if (jdbcUrl.contains(":kingbase\\d*:") && DbTypeUtil.isMatchedRegex(":kingbase\\d*:", jdbcUrl)) {
            return DbType.KINGBASE_ES;
        }
        if (jdbcUrl.contains(":lealone:")) {
            return DbType.LEALONE;
        }
        if (jdbcUrl.contains(":mariadb:")) {
            return DbType.MARIADB;
        }
        if (jdbcUrl.contains(":mysql:")) {
            return DbType.MYSQL;
        }
        if (jdbcUrl.contains(":oceanbase:")) {
            return DbType.OCEAN_BASE;
        }
        if (jdbcUrl.contains(":opengauss:")) {
            return DbType.OPENGAUSS;
        }
        if (jdbcUrl.contains(":oracle:")) {
            return DbType.ORACLE;
        }
        if (jdbcUrl.contains(":oscar:")) {
            return DbType.OSCAR;
        }
        if (jdbcUrl.contains(":phoenix:")) {
            return DbType.PHOENIX;
        }
        if (jdbcUrl.contains(":postgresql:")) {
            return DbType.POSTGRE_SQL;
        }
        if (jdbcUrl.contains(":presto:")) {
            return DbType.PRESTO;
        }
        if (jdbcUrl.contains(":redshift:")) {
            return DbType.REDSHIFT;
        }
        if (jdbcUrl.contains(":sap:")) {
            return DbType.SAP_HANA;
        }
        if (jdbcUrl.contains(":sinodb")) {
            return DbType.SINODB;
        }
        if (jdbcUrl.contains(":sqlite:")) {
            return DbType.SQLITE;
        }
        if (jdbcUrl.contains(":sqlserver:")) {
            return DbType.SQLSERVER_2005;
        }
        if (jdbcUrl.contains(":sqlserver2012:")) {
            return DbType.SQLSERVER;
        }
        if (jdbcUrl.contains(":sundb:")) {
            return DbType.SUNDB;
        }
        if (jdbcUrl.contains(":sybase:")) {
            return DbType.SYBASE;
        }
        if (jdbcUrl.contains(":taos:") || jdbcUrl.contains(":taos-rs:")) {
            return DbType.TDENGINE;
        }
        if (jdbcUrl.contains(":trino:")) {
            return DbType.TRINO;
        }
        if (jdbcUrl.contains(":uxdb:")) {
            return DbType.UXDB;
        }
        if (jdbcUrl.contains(":vastbase:")) {
            return DbType.VASTBASE;
        }
        if (jdbcUrl.contains(":vertica:")) {
            return DbType.VERTICA;
        }
        if (jdbcUrl.contains(":xcloud:")) {
            return DbType.XCloud;
        }
        if (jdbcUrl.contains(":xugu:")) {
            return DbType.XUGU;
        }
        if (jdbcUrl.contains(":yasdb:")) {
            return DbType.YASDB;
        }
        return DbType.OTHER;
    }

    public static boolean isMatchedRegex(String regex, String jdbcUrl) {
        if (null == jdbcUrl) {
            return false;
        }
        return Pattern.compile(regex).matcher(jdbcUrl).find();
    }
}

