/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.tio.websocket.server;

import com.litongjava.aio.AioId;
import com.litongjava.tio.server.ServerTioConfig;
import com.litongjava.tio.server.TioServer;
import com.litongjava.tio.server.intf.ServerAioHandler;
import com.litongjava.tio.server.intf.ServerAioListener;
import com.litongjava.tio.utils.thread.pool.SynThreadPoolExecutor;
import com.litongjava.tio.websocket.common.WebSocketSnowflakeId;
import com.litongjava.tio.websocket.server.WebSocketServerAioListener;
import com.litongjava.tio.websocket.server.WebsocketServerAioHandler;
import com.litongjava.tio.websocket.server.WebsocketServerConfig;
import com.litongjava.tio.websocket.server.handler.IWebSocketHandler;
import java.io.IOException;
import java.util.concurrent.ThreadPoolExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WsServerStarter {
    private static Logger log = LoggerFactory.getLogger(WsServerStarter.class);
    private WebsocketServerConfig wsServerConfig = null;
    private IWebSocketHandler wsMsgHandler = null;
    private WebsocketServerAioHandler wsServerAioHandler = null;
    private WebSocketServerAioListener wsServerAioListener = null;
    private ServerTioConfig serverTioConfig = null;
    private TioServer tioServer = null;

    public TioServer getTioServer() {
        return this.tioServer;
    }

    public WebsocketServerConfig getWsServerConfig() {
        return this.wsServerConfig;
    }

    public IWebSocketHandler getWsMsgHandler() {
        return this.wsMsgHandler;
    }

    public WebsocketServerAioHandler getWsServerAioHandler() {
        return this.wsServerAioHandler;
    }

    public WebSocketServerAioListener getWsServerAioListener() {
        return this.wsServerAioListener;
    }

    public ServerTioConfig getServerTioConfig() {
        return this.serverTioConfig;
    }

    public WsServerStarter(int port, IWebSocketHandler wsMsgHandler) throws IOException {
        this(port, wsMsgHandler, null, null);
    }

    public WsServerStarter(int port, IWebSocketHandler wsMsgHandler, SynThreadPoolExecutor tioExecutor, ThreadPoolExecutor groupExecutor) throws IOException {
        this(new WebsocketServerConfig(port), wsMsgHandler, tioExecutor, groupExecutor);
    }

    public WsServerStarter(WebsocketServerConfig wsServerConfig, IWebSocketHandler wsMsgHandler) throws IOException {
        this(wsServerConfig, wsMsgHandler, null, null);
    }

    public WsServerStarter(WebsocketServerConfig wsServerConfig, IWebSocketHandler wsMsgHandler, SynThreadPoolExecutor tioExecutor, ThreadPoolExecutor groupExecutor) throws IOException {
        WebSocketSnowflakeId wsTioUuid = new WebSocketSnowflakeId();
        this.wsServerConfig = wsServerConfig;
        this.wsMsgHandler = wsMsgHandler;
        this.wsServerAioHandler = new WebsocketServerAioHandler(wsServerConfig, wsMsgHandler);
        this.wsServerAioListener = new WebSocketServerAioListener();
        this.serverTioConfig = new ServerTioConfig("Tio Websocket Server");
        this.serverTioConfig.setServerAioHandler((ServerAioHandler)this.wsServerAioHandler);
        this.serverTioConfig.setServerAioListener((ServerAioListener)this.wsServerAioListener);
        this.serverTioConfig.setHeartbeatTimeout(0L);
        this.serverTioConfig.setTioUuid((AioId)wsTioUuid);
        this.serverTioConfig.setReadBufferSize(30720);
        this.tioServer = new TioServer(this.serverTioConfig);
    }

    public void start() throws IOException {
        this.tioServer.start(this.wsServerConfig.getBindIp(), this.wsServerConfig.getBindPort().intValue());
    }
}

