/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.tio.websocket.common;

import com.litongjava.tio.core.ChannelContext;
import com.litongjava.tio.core.TioConfig;
import com.litongjava.tio.core.utils.ByteBufferUtils;
import com.litongjava.tio.websocket.common.WebSocketResponse;
import java.nio.ByteBuffer;

public class WebSocketServerEncoder {
    public static final int MAX_HEADER_LENGTH = 20480;

    private static void checkLength(byte[] bytes, int length, int offset) {
        if (bytes == null) {
            throw new IllegalArgumentException("null");
        }
        if (offset < 0) {
            throw new IllegalArgumentException("invalidate offset " + offset);
        }
        if (bytes.length - offset < length) {
            throw new IllegalArgumentException("invalidate length " + bytes.length);
        }
    }

    public static ByteBuffer encode(WebSocketResponse wsResponse, TioConfig tioConfig, ChannelContext channelContext) {
        byte[] wsBody = wsResponse.getBody();
        byte[][] wsBodies = wsResponse.getBodys();
        int wsBodyLength = 0;
        if (wsBody != null) {
            wsBodyLength += wsBody.length;
        } else if (wsBodies != null) {
            for (int i = 0; i < wsBodies.length; ++i) {
                byte[] bs = wsBodies[i];
                wsBodyLength += bs.length;
            }
        }
        byte header0 = (byte)(0x8F & (wsResponse.getWsOpcode().getCode() | 0xF0));
        ByteBuffer buf = null;
        if (wsBodyLength < 126) {
            buf = ByteBuffer.allocate(2 + wsBodyLength);
            buf.put(header0);
            buf.put((byte)wsBodyLength);
        } else if (wsBodyLength < 65535) {
            buf = ByteBuffer.allocate(4 + wsBodyLength);
            buf.put(header0);
            buf.put((byte)126);
            ByteBufferUtils.writeUB2WithBigEdian((ByteBuffer)buf, (int)wsBodyLength);
        } else {
            buf = ByteBuffer.allocate(10 + wsBodyLength);
            buf.put(header0);
            buf.put((byte)127);
            buf.position(buf.position() + 4);
            ByteBufferUtils.writeUB4WithBigEdian((ByteBuffer)buf, (long)wsBodyLength);
        }
        if (wsBody != null && wsBody.length > 0) {
            buf.put(wsBody);
        } else if (wsBodies != null) {
            for (int i = 0; i < wsBodies.length; ++i) {
                byte[] bs = wsBodies[i];
                buf.put(bs);
            }
        }
        return buf;
    }

    public static void int2Byte(byte[] bytes, int value, int offset) {
        WebSocketServerEncoder.checkLength(bytes, 4, offset);
        bytes[offset + 3] = (byte)(value & 0xFF);
        bytes[offset + 2] = (byte)(value >> 8 & 0xFF);
        bytes[offset + 1] = (byte)(value >> 16 & 0xFF);
        bytes[offset + 0] = (byte)(value >> 24);
    }
}

