/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.tio.websocket.common;

import com.litongjava.tio.core.ChannelContext;
import com.litongjava.tio.core.exception.TioDecodeException;
import com.litongjava.tio.core.utils.ByteBufferUtils;
import com.litongjava.tio.websocket.common.Opcode;
import com.litongjava.tio.websocket.common.WebSocketResponse;
import java.nio.ByteBuffer;

public class WebSocketClientDecoder {
    public static WebSocketResponse decode(ByteBuffer buf, ChannelContext channelContext) throws TioDecodeException {
        byte second;
        boolean hasMask;
        int headLength;
        int initPosition = buf.position();
        int readableLength = buf.limit() - initPosition;
        if (readableLength < (headLength = 2)) {
            return null;
        }
        byte first = buf.get();
        boolean fin = (first & 0x80) > 0;
        byte opCodeByte = (byte)(first & 0xF);
        Opcode opcode = Opcode.valueOf(opCodeByte);
        if (opcode == Opcode.CLOSE) {
            // empty if block
        }
        boolean bl = hasMask = ((second = buf.get()) & 0xFF) >> 7 == 1;
        if (hasMask) {
            headLength += 4;
        }
        int payloadLength = second & 0x7F;
        byte[] mask = null;
        if (payloadLength == 126) {
            if (readableLength < (headLength += 2)) {
                return null;
            }
            payloadLength = ByteBufferUtils.readUB2WithBigEdian((ByteBuffer)buf);
        } else if (payloadLength == 127) {
            if (readableLength < (headLength += 8)) {
                return null;
            }
            payloadLength = (int)buf.getLong();
        }
        if (payloadLength < 0) {
            throw new TioDecodeException("body length(" + payloadLength + ") is not right");
        }
        if (readableLength < headLength + payloadLength) {
            return null;
        }
        if (hasMask) {
            mask = ByteBufferUtils.readBytes((ByteBuffer)buf, (int)4);
        }
        WebSocketResponse websocketPacket = new WebSocketResponse();
        websocketPacket.setWsEof(fin);
        websocketPacket.setWsHasMask(hasMask);
        websocketPacket.setWsMask(mask);
        websocketPacket.setWsOpcode(opcode);
        websocketPacket.setWsBodyLength(payloadLength);
        if (payloadLength == 0) {
            return websocketPacket;
        }
        byte[] array = ByteBufferUtils.readBytes((ByteBuffer)buf, (int)payloadLength);
        if (hasMask) {
            for (int i = 0; i < array.length; ++i) {
                array[i] = (byte)(array[i] ^ mask[i % 4]);
            }
        }
        websocketPacket.setBody(array);
        return websocketPacket;
    }
}

