/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.tio.utils.page;

import com.litongjava.model.func.Converter;
import com.litongjava.model.page.Page;
import com.litongjava.tio.utils.lock.SetWithLock;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class PageUtils {
    public static <T> Page<T> fromList(List<T> list, int pageNumber, int pageSize) {
        return PageUtils.fromList(list, pageNumber, pageSize, null);
    }

    public static <T> Page<T> fromList(List<?> list, int pageNumber, int pageSize, Converter<T> converter) {
        if (list == null) {
            return null;
        }
        Page<Object> page = PageUtils.pre(list, pageNumber, pageSize);
        List pageData = page.getList();
        if (pageData == null) {
            return page;
        }
        int startIndex = Math.min((page.getPageNumber() - 1) * page.getPageSize(), list.size());
        int endIndex = Math.min(page.getPageNumber() * page.getPageSize(), list.size());
        for (int i = startIndex; i < endIndex; ++i) {
            if (converter != null) {
                pageData.add(converter.convert(list.get(i)));
                continue;
            }
            pageData.add(list.get(i));
        }
        page.setList(pageData);
        return page;
    }

    public static <T> Page<T> fromSet(Set<T> set, int pageNumber, int pageSize) {
        return PageUtils.fromSet(set, pageNumber, pageSize, null);
    }

    public static <T> Page<T> fromSet(Set<?> set, int pageNumber, int pageSize, Converter<T> converter) {
        if (set == null) {
            return null;
        }
        Page<Object> page = PageUtils.pre(set, pageNumber, pageSize);
        List pageData = page.getList();
        if (pageData == null) {
            return page;
        }
        int startIndex = Math.min((page.getPageNumber() - 1) * page.getPageSize(), set.size());
        int endIndex = Math.min(page.getPageNumber() * page.getPageSize(), set.size());
        int i = 0;
        for (Object t : set) {
            if (i >= endIndex) break;
            if (i < startIndex) {
                ++i;
                continue;
            }
            if (converter != null) {
                pageData.add(converter.convert(t));
            } else {
                pageData.add(t);
            }
            ++i;
        }
        page.setList(pageData);
        return page;
    }

    public static <T> Page<T> fromSetWithLock(SetWithLock<T> setWithLock, int pageNumber, int pageSize) {
        return PageUtils.fromSetWithLock(setWithLock, pageNumber, pageSize, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> Page<T> fromSetWithLock(SetWithLock<?> setWithLock, int pageNumber, int pageSize, Converter<T> converter) {
        if (setWithLock == null) {
            return null;
        }
        ReentrantReadWriteLock.ReadLock lock = setWithLock.readLock();
        lock.lock();
        try {
            Set set = (Set)setWithLock.getObj();
            Page<T> page = PageUtils.fromSet(set, pageNumber, pageSize, converter);
            return page;
        }
        finally {
            lock.unlock();
        }
    }

    private static Page<Object> pre(Collection<?> allList, int pageNumber, int pageSize) {
        if (allList == null) {
            return new Page(null, pageNumber, pageSize, 0);
        }
        pageSize = PageUtils.processPageSize(pageSize);
        pageNumber = PageUtils.processpageNumber(pageNumber);
        int recordCount = allList.size();
        if (pageSize > recordCount) {
            pageSize = recordCount;
        }
        ArrayList pageData = new ArrayList(pageSize);
        Page ret = new Page(pageData, pageNumber, pageSize, recordCount);
        return ret;
    }

    private static int processpageNumber(int pageNumber) {
        return pageNumber <= 0 ? 1 : pageNumber;
    }

    private static int processPageSize(int pageSize) {
        return pageSize <= 0 ? Integer.MAX_VALUE : pageSize;
    }
}

