/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.tio.utils.notification;

import com.litongjava.tio.utils.environment.EnvUtils;
import com.litongjava.tio.utils.http.HttpUtils;
import com.litongjava.tio.utils.json.JsonUtils;
import com.litongjava.tio.utils.notification.NotifactionWarmModel;
import java.util.HashMap;
import java.util.Map;
import okhttp3.Response;

public class WeComNotificationUtils {
    public static Response send(Map<String, Object> reqMap) {
        String webHookUrl = EnvUtils.get("notification.webhook.url");
        return WeComNotificationUtils.send(webHookUrl, reqMap);
    }

    public static Response send(String webHookUrl, Map<String, Object> reqMap) {
        String reqBody = JsonUtils.toJson(reqMap);
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("cache-control", "no-cache");
        return HttpUtils.post(webHookUrl, header, reqBody);
    }

    public static Response sendWarm(NotifactionWarmModel model) {
        String webHookUrl = EnvUtils.get("notification.webhook.url");
        return WeComNotificationUtils.sendWarm(webHookUrl, model);
    }

    public static Response sendWarm(String webHookUrl, NotifactionWarmModel model) {
        Map<String, Object> reqMap = WeComNotificationUtils.getReqMap(model.format());
        return WeComNotificationUtils.send(webHookUrl, reqMap);
    }

    public static Map<String, Object> getReqMap(String msg) {
        HashMap<String, String> markdown = new HashMap<String, String>();
        markdown.put("content", msg);
        HashMap<String, Object> reqMap = new HashMap<String, Object>();
        reqMap.put("msgtype", "markdown");
        reqMap.put("markdown", markdown);
        reqMap.put("safe", 0);
        return reqMap;
    }

    public static Response sendTextMsg(String msg) {
        HashMap<String, String> text = new HashMap<String, String>();
        text.put("content", msg);
        HashMap<String, Object> req = new HashMap<String, Object>();
        req.put("msgtype", "text");
        req.put("text", text);
        req.put("safe", 0);
        String webHookUrl = EnvUtils.get("notification.webhook.url");
        return WeComNotificationUtils.send(webHookUrl, req);
    }
}

