/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.tio.utils.notification;

import com.litongjava.tio.utils.json.JsonUtils;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Map;

public class NotifactionWarmModel {
    public static final DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss XXX");
    private ZonedDateTime time;
    private String appEnv;
    private String appGroupName;
    private String appName;
    private String warningName;
    private String level;
    private String deviceName;
    private String userIp;
    private String userId;
    private String requestId;
    private String host;
    private String referer;
    private String userAgent;
    private String requestLine;
    private String requestBody;
    private Integer statusCode;
    private String exceptionId;
    private String stackTrace;
    private String content;
    private Map<String, String> headers;
    private Map<String, Object[]> params;

    public NotifactionWarmModel(ZonedDateTime time, String env, String appGroupName, String appName, String warningName, String level, String deviceName, String content) {
        this.time = time;
        this.appEnv = env;
        this.appGroupName = appGroupName;
        this.appName = appName;
        this.warningName = warningName;
        this.level = level;
        this.deviceName = deviceName;
        this.content = content;
    }

    public String format() {
        StringBuilder sb = new StringBuilder();
        ZonedDateTime time = this.getTime();
        if (time != null) {
            sb.append(String.format("- Alarm Time : %s\n", time.format(dateTimeFormatter)));
        }
        if (this.getAppEnv() != null) {
            sb.append(String.format("- App Env : %s\n", this.getAppEnv()));
        }
        if (this.getAppGroupName() != null) {
            sb.append(String.format("- App Group Name : %s\n", this.getAppGroupName()));
        }
        if (this.getAppName() != null) {
            sb.append(String.format("- App Name : %s\n", this.getAppName()));
        }
        if (this.getWarningName() != null) {
            sb.append(String.format("- Alarm Name : %s\n", this.getWarningName()));
        }
        if (this.getLevel() != null) {
            sb.append(String.format("- Alarm Level : %s\n", this.getLevel()));
        }
        if (this.getDeviceName() != null) {
            sb.append(String.format("- Alarm Device : %s\n", this.getDeviceName()));
        }
        if (this.getUserIp() != null) {
            sb.append(String.format("- User Ip : %s\n", this.getUserIp()));
        }
        if (this.getUserId() != null) {
            sb.append(String.format("- User Id : %s\n", this.getUserId()));
        }
        if (this.getRequestId() != null) {
            sb.append(String.format("- Request Id : %s\n", this.getRequestId()));
        }
        if (this.getRequestLine() != null) {
            sb.append(String.format("- Request Line : %s\n", this.getRequestLine()));
        }
        if (this.getHost() != null) {
            sb.append(String.format("- Host : %s\n", this.getHost()));
        }
        if (this.getReferer() != null) {
            sb.append(String.format("- Referer : %s\n", this.getReferer()));
        }
        if (this.getUserAgent() != null) {
            sb.append(String.format("- UserAgent : %s\n", this.getUserAgent()));
        }
        if (this.getHeaders() != null) {
            sb.append(String.format("- UserAgent : %s\n", JsonUtils.toJson(this.getHeaders())));
        }
        if (this.getParams() != null) {
            sb.append(String.format("- UserAgent : %s\n", JsonUtils.toJson(this.getParams())));
        }
        if (this.getRequestBody() != null) {
            sb.append(String.format("- Request Body : %s\n", this.getRequestBody()));
        }
        if (this.getStatusCode() != null) {
            sb.append(String.format("- Status Code : %d\n", this.getStatusCode()));
        }
        if (this.getExceptionId() != null) {
            sb.append(String.format("- Exception Id : %s\n", this.getExceptionId()));
        }
        if (this.getStackTrace() != null) {
            sb.append(String.format("- Stack Trace : %s\n", this.getStackTrace()));
        }
        if (this.getContent() != null) {
            sb.append("- Alarm Content : \n");
            sb.append(String.format("%s\n", this.getContent()));
        }
        return sb.toString();
    }

    public ZonedDateTime getTime() {
        return this.time;
    }

    public String getAppEnv() {
        return this.appEnv;
    }

    public String getAppGroupName() {
        return this.appGroupName;
    }

    public String getAppName() {
        return this.appName;
    }

    public String getWarningName() {
        return this.warningName;
    }

    public String getLevel() {
        return this.level;
    }

    public String getDeviceName() {
        return this.deviceName;
    }

    public String getUserIp() {
        return this.userIp;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public String getHost() {
        return this.host;
    }

    public String getReferer() {
        return this.referer;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public String getRequestLine() {
        return this.requestLine;
    }

    public String getRequestBody() {
        return this.requestBody;
    }

    public Integer getStatusCode() {
        return this.statusCode;
    }

    public String getExceptionId() {
        return this.exceptionId;
    }

    public String getStackTrace() {
        return this.stackTrace;
    }

    public String getContent() {
        return this.content;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public Map<String, Object[]> getParams() {
        return this.params;
    }

    public NotifactionWarmModel setTime(ZonedDateTime time) {
        this.time = time;
        return this;
    }

    public NotifactionWarmModel setAppEnv(String appEnv) {
        this.appEnv = appEnv;
        return this;
    }

    public NotifactionWarmModel setAppGroupName(String appGroupName) {
        this.appGroupName = appGroupName;
        return this;
    }

    public NotifactionWarmModel setAppName(String appName) {
        this.appName = appName;
        return this;
    }

    public NotifactionWarmModel setWarningName(String warningName) {
        this.warningName = warningName;
        return this;
    }

    public NotifactionWarmModel setLevel(String level) {
        this.level = level;
        return this;
    }

    public NotifactionWarmModel setDeviceName(String deviceName) {
        this.deviceName = deviceName;
        return this;
    }

    public NotifactionWarmModel setUserIp(String userIp) {
        this.userIp = userIp;
        return this;
    }

    public NotifactionWarmModel setUserId(String userId) {
        this.userId = userId;
        return this;
    }

    public NotifactionWarmModel setRequestId(String requestId) {
        this.requestId = requestId;
        return this;
    }

    public NotifactionWarmModel setHost(String host) {
        this.host = host;
        return this;
    }

    public NotifactionWarmModel setReferer(String referer) {
        this.referer = referer;
        return this;
    }

    public NotifactionWarmModel setUserAgent(String userAgent) {
        this.userAgent = userAgent;
        return this;
    }

    public NotifactionWarmModel setRequestLine(String requestLine) {
        this.requestLine = requestLine;
        return this;
    }

    public NotifactionWarmModel setRequestBody(String requestBody) {
        this.requestBody = requestBody;
        return this;
    }

    public NotifactionWarmModel setStatusCode(Integer statusCode) {
        this.statusCode = statusCode;
        return this;
    }

    public NotifactionWarmModel setExceptionId(String exceptionId) {
        this.exceptionId = exceptionId;
        return this;
    }

    public NotifactionWarmModel setStackTrace(String stackTrace) {
        this.stackTrace = stackTrace;
        return this;
    }

    public NotifactionWarmModel setContent(String content) {
        this.content = content;
        return this;
    }

    public NotifactionWarmModel setHeaders(Map<String, String> headers) {
        this.headers = headers;
        return this;
    }

    public NotifactionWarmModel setParams(Map<String, Object[]> params) {
        this.params = params;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof NotifactionWarmModel)) {
            return false;
        }
        NotifactionWarmModel other = (NotifactionWarmModel)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$statusCode = this.getStatusCode();
        Integer other$statusCode = other.getStatusCode();
        if (this$statusCode == null ? other$statusCode != null : !((Object)this$statusCode).equals(other$statusCode)) {
            return false;
        }
        ZonedDateTime this$time = this.getTime();
        ZonedDateTime other$time = other.getTime();
        if (this$time == null ? other$time != null : !((Object)this$time).equals(other$time)) {
            return false;
        }
        String this$appEnv = this.getAppEnv();
        String other$appEnv = other.getAppEnv();
        if (this$appEnv == null ? other$appEnv != null : !this$appEnv.equals(other$appEnv)) {
            return false;
        }
        String this$appGroupName = this.getAppGroupName();
        String other$appGroupName = other.getAppGroupName();
        if (this$appGroupName == null ? other$appGroupName != null : !this$appGroupName.equals(other$appGroupName)) {
            return false;
        }
        String this$appName = this.getAppName();
        String other$appName = other.getAppName();
        if (this$appName == null ? other$appName != null : !this$appName.equals(other$appName)) {
            return false;
        }
        String this$warningName = this.getWarningName();
        String other$warningName = other.getWarningName();
        if (this$warningName == null ? other$warningName != null : !this$warningName.equals(other$warningName)) {
            return false;
        }
        String this$level = this.getLevel();
        String other$level = other.getLevel();
        if (this$level == null ? other$level != null : !this$level.equals(other$level)) {
            return false;
        }
        String this$deviceName = this.getDeviceName();
        String other$deviceName = other.getDeviceName();
        if (this$deviceName == null ? other$deviceName != null : !this$deviceName.equals(other$deviceName)) {
            return false;
        }
        String this$userIp = this.getUserIp();
        String other$userIp = other.getUserIp();
        if (this$userIp == null ? other$userIp != null : !this$userIp.equals(other$userIp)) {
            return false;
        }
        String this$userId = this.getUserId();
        String other$userId = other.getUserId();
        if (this$userId == null ? other$userId != null : !this$userId.equals(other$userId)) {
            return false;
        }
        String this$requestId = this.getRequestId();
        String other$requestId = other.getRequestId();
        if (this$requestId == null ? other$requestId != null : !this$requestId.equals(other$requestId)) {
            return false;
        }
        String this$host = this.getHost();
        String other$host = other.getHost();
        if (this$host == null ? other$host != null : !this$host.equals(other$host)) {
            return false;
        }
        String this$referer = this.getReferer();
        String other$referer = other.getReferer();
        if (this$referer == null ? other$referer != null : !this$referer.equals(other$referer)) {
            return false;
        }
        String this$userAgent = this.getUserAgent();
        String other$userAgent = other.getUserAgent();
        if (this$userAgent == null ? other$userAgent != null : !this$userAgent.equals(other$userAgent)) {
            return false;
        }
        String this$requestLine = this.getRequestLine();
        String other$requestLine = other.getRequestLine();
        if (this$requestLine == null ? other$requestLine != null : !this$requestLine.equals(other$requestLine)) {
            return false;
        }
        String this$requestBody = this.getRequestBody();
        String other$requestBody = other.getRequestBody();
        if (this$requestBody == null ? other$requestBody != null : !this$requestBody.equals(other$requestBody)) {
            return false;
        }
        String this$exceptionId = this.getExceptionId();
        String other$exceptionId = other.getExceptionId();
        if (this$exceptionId == null ? other$exceptionId != null : !this$exceptionId.equals(other$exceptionId)) {
            return false;
        }
        String this$stackTrace = this.getStackTrace();
        String other$stackTrace = other.getStackTrace();
        if (this$stackTrace == null ? other$stackTrace != null : !this$stackTrace.equals(other$stackTrace)) {
            return false;
        }
        String this$content = this.getContent();
        String other$content = other.getContent();
        if (this$content == null ? other$content != null : !this$content.equals(other$content)) {
            return false;
        }
        Map<String, String> this$headers = this.getHeaders();
        Map<String, String> other$headers = other.getHeaders();
        if (this$headers == null ? other$headers != null : !((Object)this$headers).equals(other$headers)) {
            return false;
        }
        Map<String, Object[]> this$params = this.getParams();
        Map<String, Object[]> other$params = other.getParams();
        return !(this$params == null ? other$params != null : !((Object)this$params).equals(other$params));
    }

    protected boolean canEqual(Object other) {
        return other instanceof NotifactionWarmModel;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $statusCode = this.getStatusCode();
        result = result * 59 + ($statusCode == null ? 43 : ((Object)$statusCode).hashCode());
        ZonedDateTime $time = this.getTime();
        result = result * 59 + ($time == null ? 43 : ((Object)$time).hashCode());
        String $appEnv = this.getAppEnv();
        result = result * 59 + ($appEnv == null ? 43 : $appEnv.hashCode());
        String $appGroupName = this.getAppGroupName();
        result = result * 59 + ($appGroupName == null ? 43 : $appGroupName.hashCode());
        String $appName = this.getAppName();
        result = result * 59 + ($appName == null ? 43 : $appName.hashCode());
        String $warningName = this.getWarningName();
        result = result * 59 + ($warningName == null ? 43 : $warningName.hashCode());
        String $level = this.getLevel();
        result = result * 59 + ($level == null ? 43 : $level.hashCode());
        String $deviceName = this.getDeviceName();
        result = result * 59 + ($deviceName == null ? 43 : $deviceName.hashCode());
        String $userIp = this.getUserIp();
        result = result * 59 + ($userIp == null ? 43 : $userIp.hashCode());
        String $userId = this.getUserId();
        result = result * 59 + ($userId == null ? 43 : $userId.hashCode());
        String $requestId = this.getRequestId();
        result = result * 59 + ($requestId == null ? 43 : $requestId.hashCode());
        String $host = this.getHost();
        result = result * 59 + ($host == null ? 43 : $host.hashCode());
        String $referer = this.getReferer();
        result = result * 59 + ($referer == null ? 43 : $referer.hashCode());
        String $userAgent = this.getUserAgent();
        result = result * 59 + ($userAgent == null ? 43 : $userAgent.hashCode());
        String $requestLine = this.getRequestLine();
        result = result * 59 + ($requestLine == null ? 43 : $requestLine.hashCode());
        String $requestBody = this.getRequestBody();
        result = result * 59 + ($requestBody == null ? 43 : $requestBody.hashCode());
        String $exceptionId = this.getExceptionId();
        result = result * 59 + ($exceptionId == null ? 43 : $exceptionId.hashCode());
        String $stackTrace = this.getStackTrace();
        result = result * 59 + ($stackTrace == null ? 43 : $stackTrace.hashCode());
        String $content = this.getContent();
        result = result * 59 + ($content == null ? 43 : $content.hashCode());
        Map<String, String> $headers = this.getHeaders();
        result = result * 59 + ($headers == null ? 43 : ((Object)$headers).hashCode());
        Map<String, Object[]> $params = this.getParams();
        result = result * 59 + ($params == null ? 43 : ((Object)$params).hashCode());
        return result;
    }

    public String toString() {
        return "NotifactionWarmModel(time=" + this.getTime() + ", appEnv=" + this.getAppEnv() + ", appGroupName=" + this.getAppGroupName() + ", appName=" + this.getAppName() + ", warningName=" + this.getWarningName() + ", level=" + this.getLevel() + ", deviceName=" + this.getDeviceName() + ", userIp=" + this.getUserIp() + ", userId=" + this.getUserId() + ", requestId=" + this.getRequestId() + ", host=" + this.getHost() + ", referer=" + this.getReferer() + ", userAgent=" + this.getUserAgent() + ", requestLine=" + this.getRequestLine() + ", requestBody=" + this.getRequestBody() + ", statusCode=" + this.getStatusCode() + ", exceptionId=" + this.getExceptionId() + ", stackTrace=" + this.getStackTrace() + ", content=" + this.getContent() + ", headers=" + this.getHeaders() + ", params=" + this.getParams() + ")";
    }

    public NotifactionWarmModel() {
    }

    public NotifactionWarmModel(ZonedDateTime time, String appEnv, String appGroupName, String appName, String warningName, String level, String deviceName, String userIp, String userId, String requestId, String host, String referer, String userAgent, String requestLine, String requestBody, Integer statusCode, String exceptionId, String stackTrace, String content, Map<String, String> headers, Map<String, Object[]> params) {
        this.time = time;
        this.appEnv = appEnv;
        this.appGroupName = appGroupName;
        this.appName = appName;
        this.warningName = warningName;
        this.level = level;
        this.deviceName = deviceName;
        this.userIp = userIp;
        this.userId = userId;
        this.requestId = requestId;
        this.host = host;
        this.referer = referer;
        this.userAgent = userAgent;
        this.requestLine = requestLine;
        this.requestBody = requestBody;
        this.statusCode = statusCode;
        this.exceptionId = exceptionId;
        this.stackTrace = stackTrace;
        this.content = content;
        this.headers = headers;
        this.params = params;
    }
}

