/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.tio.utils.json;

import com.litongjava.tio.utils.hutool.StrUtil;
import com.litongjava.tio.utils.json.JsonResult;
import com.litongjava.tio.utils.json.TioToJson;
import com.litongjava.tio.utils.map.SyncWriteMap;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.temporal.Temporal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Function;

public class TioJsonKit {
    public static final TioJsonKit me = new TioJsonKit();
    protected static SyncWriteMap<Class<?>, TioToJson<?>> cache = new SyncWriteMap(512, 0.25f);
    protected static SyncWriteMap<Class<?>, TioToJson<?>> cacheSkipNull = new SyncWriteMap(512, 0.25f);
    protected static int maxBufferSize = 524288;
    protected static boolean treatModelAsBean = false;
    protected static Function<String, String> modelAndRecordFieldNameConverter = null;
    protected static Function<Object, TioToJson<?>> toJsonFactory = null;
    protected boolean skipNullValueField;

    public TioToJson getToJson(Object object, boolean skipNullValueField) {
        this.skipNullValueField = skipNullValueField;
        TioToJson ret = null;
        if (skipNullValueField) {
            ret = (TioToJson)cacheSkipNull.get(object.getClass());
            if (ret == null) {
                ret = this.createToJson(object, skipNullValueField);
                cacheSkipNull.putIfAbsent(object.getClass(), ret);
            }
        } else {
            ret = (TioToJson)cache.get(object.getClass());
            if (ret == null) {
                ret = this.createToJson(object, false);
                cache.putIfAbsent(object.getClass(), ret);
            }
        }
        return ret;
    }

    public static void addToJson(Class<?> type, TioToJson<?> toJson) {
        Objects.requireNonNull(type, "type can not be null");
        Objects.requireNonNull(toJson, "toJson can not be null");
        cache.put(type, toJson);
    }

    protected TioToJson<?> createToJson(Object value, boolean skipNullValueField) {
        TioToJson<?> tj;
        if (toJsonFactory != null && (tj = toJsonFactory.apply(value)) != null) {
            return tj;
        }
        if (value instanceof String) {
            return new StrToJson();
        }
        if (value instanceof Number) {
            if (value instanceof Integer) {
                return new IntToJson();
            }
            if (value instanceof Long) {
                return new LongToJson();
            }
            if (value instanceof Double) {
                return new DoubleToJson();
            }
            if (value instanceof Float) {
                return new FloatToJson();
            }
            return new NumberToJson();
        }
        if (value instanceof Boolean) {
            return new BooleanToJson();
        }
        if (value instanceof Character) {
            return new CharacterToJson();
        }
        if (value instanceof Enum) {
            return new EnumToJson();
        }
        if (value instanceof Date) {
            if (value instanceof Timestamp) {
                return new TimestampToJson();
            }
            if (value instanceof Time) {
                return new TimeToJson();
            }
            return new DateToJson();
        }
        if (value instanceof Temporal) {
            if (value instanceof LocalDateTime) {
                return new LocalDateTimeToJson();
            }
            if (value instanceof LocalDate) {
                return new LocalDateToJson();
            }
            if (value instanceof LocalTime) {
                return new LocalTimeToJson();
            }
        }
        if (value instanceof Map) {
            return new MapToJson(skipNullValueField);
        }
        if (value instanceof Collection) {
            return new CollectionToJson(skipNullValueField);
        }
        if (value.getClass().isArray()) {
            return new ArrayToJson(skipNullValueField);
        }
        if (value instanceof Enumeration) {
            return new EnumerationToJson(skipNullValueField);
        }
        if (value instanceof Iterator) {
            return new IteratorToJson(skipNullValueField);
        }
        if (value instanceof Iterable) {
            return new IterableToJson(skipNullValueField);
        }
        if (value instanceof UUID) {
            return new UUIDToJson();
        }
        BeanToJson beanToJson = this.buildBeanToJson(value, skipNullValueField);
        if (beanToJson != null) {
            return beanToJson;
        }
        return new UnknownToJson();
    }

    public static boolean checkDepth(int depth, JsonResult ret) {
        if (depth < 0) {
            ret.addNull();
            return true;
        }
        return false;
    }

    public void modelAndRecordToJson(Map<String, Object> map, int depth, JsonResult ret) {
        Iterator<Map.Entry<String, Object>> iter = map.entrySet().iterator();
        boolean first = true;
        ret.addChar('{');
        while (iter.hasNext()) {
            Map.Entry<String, Object> entry = iter.next();
            Object value = entry.getValue();
            if (value == null && this.skipNullValueField) continue;
            if (first) {
                first = false;
            } else {
                ret.addChar(',');
            }
            String fieldName = entry.getKey();
            if (modelAndRecordFieldNameConverter != null) {
                fieldName = modelAndRecordFieldNameConverter.apply(fieldName);
            }
            ret.addStrNoEscape(fieldName);
            ret.addChar(':');
            if (value != null) {
                TioToJson tj = me.getToJson(value, this.skipNullValueField);
                tj.toJson(value, depth, ret);
                continue;
            }
            ret.addNull();
        }
        ret.addChar('}');
    }

    public static void mapToJson(Map<?, ?> map, int depth, JsonResult ret, boolean skipNullValueField) {
        Iterator<Map.Entry<?, ?>> iter = map.entrySet().iterator();
        boolean first = true;
        ret.addChar('{');
        while (iter.hasNext()) {
            Map.Entry<?, ?> entry = iter.next();
            Object value = entry.getValue();
            if (value == null && skipNullValueField) continue;
            if (first) {
                first = false;
            } else {
                ret.addChar(',');
            }
            ret.addMapKey(entry.getKey());
            ret.addChar(':');
            if (value != null) {
                TioToJson tj = me.getToJson(value, skipNullValueField);
                tj.toJson(value, depth, ret);
                continue;
            }
            ret.addNull();
        }
        ret.addChar('}');
    }

    public static void iteratorToJson(Iterator it, int depth, JsonResult ret, boolean skipNullValueField) {
        boolean first = true;
        ret.addChar('[');
        while (it.hasNext()) {
            if (first) {
                first = false;
            } else {
                ret.addChar(',');
            }
            Object value = it.next();
            if (value != null) {
                TioToJson tj = me.getToJson(value, skipNullValueField);
                tj.toJson(value, depth, ret);
                continue;
            }
            ret.addNull();
        }
        ret.addChar(']');
    }

    public BeanToJson buildBeanToJson(Object bean, boolean skipNullValueField) {
        Method[] methodArray;
        ArrayList<String> fields = new ArrayList<String>();
        ArrayList<Method> methods = new ArrayList<Method>();
        for (Method m : methodArray = bean.getClass().getMethods()) {
            if (m.getParameterCount() != 0 || m.getReturnType() == Void.TYPE) continue;
            String methodName = m.getName();
            int indexOfGet = methodName.indexOf("get");
            if (indexOfGet == 0 && methodName.length() > 3) {
                String attrName = methodName.substring(3);
                if (attrName.equals("Class")) continue;
                fields.add(StrUtil.firstCharToLowerCase(attrName));
                methods.add(m);
                continue;
            }
            int indexOfIs = methodName.indexOf("is");
            if (indexOfIs != 0 || methodName.length() <= 2) continue;
            String attrName = methodName.substring(2);
            fields.add(StrUtil.firstCharToLowerCase(attrName));
            methods.add(m);
        }
        int size = fields.size();
        if (size > 0) {
            return new BeanToJson(fields.toArray(new String[size]), methods.toArray(new Method[size]), skipNullValueField);
        }
        return null;
    }

    public static void escape(String s, StringBuilder sb) {
        sb.append('\"');
        int len = s.length();
        block9: for (int i = 0; i < len; ++i) {
            char ch = s.charAt(i);
            switch (ch) {
                case '\"': {
                    sb.append("\\\"");
                    continue block9;
                }
                case '\\': {
                    sb.append("\\\\");
                    continue block9;
                }
                case '\b': {
                    sb.append("\\b");
                    continue block9;
                }
                case '\f': {
                    sb.append("\\f");
                    continue block9;
                }
                case '\n': {
                    sb.append("\\n");
                    continue block9;
                }
                case '\r': {
                    sb.append("\\r");
                    continue block9;
                }
                case '\t': {
                    sb.append("\\t");
                    continue block9;
                }
                default: {
                    if (ch >= '\u0000' && ch <= '\u001f' || ch >= '\u007f' && ch <= '\u009f' || ch >= '\u2000' && ch <= '\u20ff') {
                        String str = Integer.toHexString(ch);
                        sb.append("\\u");
                        for (int k = 0; k < 4 - str.length(); ++k) {
                            sb.append('0');
                        }
                        sb.append(str.toUpperCase());
                        continue block9;
                    }
                    sb.append(ch);
                }
            }
        }
        sb.append('\"');
    }

    public static void setMaxBufferSize(int maxBufferSize) {
        int size = 1024;
        if (maxBufferSize < size) {
            throw new IllegalArgumentException("maxBufferSize can not less than " + size);
        }
        TioJsonKit.maxBufferSize = maxBufferSize;
    }

    public static void setTreatModelAsBean(boolean treatModelAsBean) {
        TioJsonKit.treatModelAsBean = treatModelAsBean;
    }

    public static void setModelAndRecordFieldNameConverter(Function<String, String> converter) {
        modelAndRecordFieldNameConverter = converter;
    }

    public static void setModelAndRecordFieldNameToCamelCase(boolean toLowerCaseAnyway) {
        modelAndRecordFieldNameConverter = fieldName -> StrUtil.toCamelCase(fieldName, toLowerCaseAnyway);
    }

    public static void setModelAndRecordFieldNameToCamelCase() {
        TioJsonKit.setModelAndRecordFieldNameToCamelCase(true);
    }

    public static void setToJsonFactory(Function<Object, TioToJson<?>> toJsonFactory) {
        TioJsonKit.toJsonFactory = toJsonFactory;
    }

    static class UnknownToJson
    implements TioToJson<Object> {
        UnknownToJson() {
        }

        @Override
        public void toJson(Object object, int depth, JsonResult ret) {
            ret.addUnknown(object);
        }
    }

    static class BeanToJson
    implements TioToJson<Object> {
        private static final Object[] NULL_ARGS = new Object[0];
        private String[] fields;
        private Method[] methods;
        private boolean skipNullValueField;

        public BeanToJson(String[] fields, Method[] methods, boolean skipNullValueField) {
            if (fields.length != methods.length) {
                throw new IllegalArgumentException("fields \u4e0e methods \u957f\u5ea6\u5fc5\u987b\u76f8\u540c");
            }
            this.fields = fields;
            this.methods = methods;
            this.skipNullValueField = skipNullValueField;
        }

        @Override
        public void toJson(Object bean, int depth, JsonResult ret) {
            if (TioJsonKit.checkDepth(depth--, ret)) {
                return;
            }
            try {
                ret.addChar('{');
                boolean first = true;
                for (int i = 0; i < this.fields.length; ++i) {
                    Object value = this.methods[i].invoke(bean, NULL_ARGS);
                    if (value == null && this.skipNullValueField) continue;
                    if (first) {
                        first = false;
                    } else {
                        ret.addChar(',');
                    }
                    ret.addStrNoEscape(this.fields[i]);
                    ret.addChar(':');
                    if (value != null) {
                        TioToJson tj = me.getToJson(value, this.skipNullValueField);
                        tj.toJson(value, depth, ret);
                        continue;
                    }
                    ret.addNull();
                }
                ret.addChar('}');
            }
            catch (ReflectiveOperationException e) {
                throw new RuntimeException(e);
            }
        }
    }

    static class IterableToJson
    implements TioToJson<Iterable> {
        boolean skipNullValueField;

        public IterableToJson(Boolean skipNullValueField) {
            this.skipNullValueField = skipNullValueField;
        }

        @Override
        public void toJson(Iterable iterable, int depth, JsonResult ret) {
            if (TioJsonKit.checkDepth(depth--, ret)) {
                return;
            }
            TioJsonKit.iteratorToJson(iterable.iterator(), depth, ret, this.skipNullValueField);
        }
    }

    static class IteratorToJson
    implements TioToJson<Iterator> {
        boolean skipNullValueField;

        public IteratorToJson(Boolean skipNullValueField) {
            this.skipNullValueField = skipNullValueField;
        }

        @Override
        public void toJson(Iterator it, int depth, JsonResult ret) {
            if (TioJsonKit.checkDepth(depth--, ret)) {
                return;
            }
            TioJsonKit.iteratorToJson(it, depth, ret, this.skipNullValueField);
        }
    }

    static class EnumerationToJson
    implements TioToJson<Enumeration> {
        boolean skipNullValueField;

        public EnumerationToJson(Boolean skipNullValueField) {
            this.skipNullValueField = skipNullValueField;
        }

        @Override
        public void toJson(Enumeration en, int depth, JsonResult ret) {
            if (TioJsonKit.checkDepth(depth--, ret)) {
                return;
            }
            ArrayList list = Collections.list(en);
            TioJsonKit.iteratorToJson(list.iterator(), depth, ret, this.skipNullValueField);
        }
    }

    static class ArrayIterator
    implements Iterator<Object> {
        private Object array;
        private int size;
        private int index;

        public ArrayIterator(Object array) {
            this.array = array;
            this.size = Array.getLength(array);
            this.index = 0;
        }

        @Override
        public boolean hasNext() {
            return this.index < this.size;
        }

        @Override
        public Object next() {
            return Array.get(this.array, this.index++);
        }
    }

    static class ArrayToJson
    implements TioToJson<Object> {
        boolean skipNullValueField;

        public ArrayToJson(Boolean skipNullValueField) {
            this.skipNullValueField = skipNullValueField;
        }

        @Override
        public void toJson(Object object, int depth, JsonResult ret) {
            if (TioJsonKit.checkDepth(depth--, ret)) {
                return;
            }
            TioJsonKit.iteratorToJson(new ArrayIterator(object), depth, ret, this.skipNullValueField);
        }
    }

    static class CollectionToJson
    implements TioToJson<Collection> {
        boolean skipNullValueField;

        public CollectionToJson(Boolean skipNullValueField) {
            this.skipNullValueField = skipNullValueField;
        }

        @Override
        public void toJson(Collection c, int depth, JsonResult ret) {
            if (TioJsonKit.checkDepth(depth--, ret)) {
                return;
            }
            TioJsonKit.iteratorToJson(c.iterator(), depth, ret, this.skipNullValueField);
        }
    }

    static class MapToJson
    implements TioToJson<Map<?, ?>> {
        boolean skipNullValueField;

        public MapToJson() {
        }

        public MapToJson(boolean skipNullValueField) {
            this.skipNullValueField = skipNullValueField;
        }

        @Override
        public void toJson(Map<?, ?> map, int depth, JsonResult ret) {
            if (TioJsonKit.checkDepth(depth--, ret)) {
                return;
            }
            TioJsonKit.mapToJson(map, depth, ret, this.skipNullValueField);
        }
    }

    static class UUIDToJson
    implements TioToJson<UUID> {
        UUIDToJson() {
        }

        @Override
        public void toJson(UUID value, int depth, JsonResult ret) {
            TioJsonKit.escape(value.toString(), ret.sb);
        }
    }

    static class LocalTimeToJson
    implements TioToJson<LocalTime> {
        LocalTimeToJson() {
        }

        @Override
        public void toJson(LocalTime value, int depth, JsonResult ret) {
            ret.addLocalTime(value);
        }
    }

    static class LocalDateToJson
    implements TioToJson<LocalDate> {
        LocalDateToJson() {
        }

        @Override
        public void toJson(LocalDate value, int depth, JsonResult ret) {
            ret.addLocalDate(value);
        }
    }

    static class LocalDateTimeToJson
    implements TioToJson<LocalDateTime> {
        LocalDateTimeToJson() {
        }

        @Override
        public void toJson(LocalDateTime value, int depth, JsonResult ret) {
            ret.addLocalDateTime(value);
        }
    }

    static class DateToJson
    implements TioToJson<Date> {
        DateToJson() {
        }

        @Override
        public void toJson(Date value, int depth, JsonResult ret) {
            ret.addDate(value);
        }
    }

    static class TimeToJson
    implements TioToJson<Time> {
        TimeToJson() {
        }

        @Override
        public void toJson(Time t, int depth, JsonResult ret) {
            ret.addTime(t);
        }
    }

    static class TimestampToJson
    implements TioToJson<Timestamp> {
        TimestampToJson() {
        }

        @Override
        public void toJson(Timestamp ts, int depth, JsonResult ret) {
            ret.addTimestamp(ts);
        }
    }

    static class EnumToJson
    implements TioToJson<Enum> {
        EnumToJson() {
        }

        @Override
        public void toJson(Enum en, int depth, JsonResult ret) {
            ret.addEnum(en);
        }
    }

    static class BooleanToJson
    implements TioToJson<Boolean> {
        BooleanToJson() {
        }

        @Override
        public void toJson(Boolean value, int depth, JsonResult ret) {
            ret.addBoolean(value);
        }
    }

    static class NumberToJson
    implements TioToJson<Number> {
        NumberToJson() {
        }

        @Override
        public void toJson(Number value, int depth, JsonResult ret) {
            ret.addNumber(value);
        }
    }

    static class FloatToJson
    implements TioToJson<Float> {
        FloatToJson() {
        }

        @Override
        public void toJson(Float value, int depth, JsonResult ret) {
            if (value.isInfinite() || value.isNaN()) {
                ret.addNull();
            } else {
                ret.addFloat(value.floatValue());
            }
        }
    }

    static class DoubleToJson
    implements TioToJson<Double> {
        DoubleToJson() {
        }

        @Override
        public void toJson(Double value, int depth, JsonResult ret) {
            if (value.isInfinite() || value.isNaN()) {
                ret.addNull();
            } else {
                ret.addDouble(value);
            }
        }
    }

    static class LongToJson
    implements TioToJson<Long> {
        LongToJson() {
        }

        @Override
        public void toJson(Long value, int depth, JsonResult ret) {
            ret.addLong(value);
        }
    }

    static class IntToJson
    implements TioToJson<Integer> {
        IntToJson() {
        }

        @Override
        public void toJson(Integer value, int depth, JsonResult ret) {
            ret.addInt(value);
        }
    }

    static class CharacterToJson
    implements TioToJson<Character> {
        CharacterToJson() {
        }

        @Override
        public void toJson(Character ch, int depth, JsonResult ret) {
            TioJsonKit.escape(ch.toString(), ret.sb);
        }
    }

    static class StrToJson
    implements TioToJson<String> {
        StrToJson() {
        }

        @Override
        public void toJson(String str, int depth, JsonResult ret) {
            TioJsonKit.escape(str, ret.sb);
        }
    }
}

