/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.tio.utils.json;

import com.litongjava.model.type.TioTypeReference;
import com.litongjava.tio.utils.json.IJsonFactory;
import com.litongjava.tio.utils.json.MixedJsonFactory;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public abstract class Json {
    private static IJsonFactory defaultJsonFactory = new MixedJsonFactory();
    private static String defaultDatePattern = "yyyy-MM-dd HH:mm:ss";
    private static String timestampPattern = null;
    protected String datePattern = null;
    private static boolean longToString = true;

    public static void setDefaultJsonFactory(IJsonFactory defaultJsonFactory) {
        Objects.requireNonNull(defaultJsonFactory, "defaultJsonFactory can not be null");
        Json.defaultJsonFactory = defaultJsonFactory;
    }

    public static IJsonFactory getJsonFactory() {
        return defaultJsonFactory;
    }

    public static void setDefaultDatePattern(String defaultDatePattern) {
        Json.defaultDatePattern = defaultDatePattern;
    }

    public Json setDatePattern(String datePattern) {
        this.datePattern = datePattern;
        return this;
    }

    public String getDatePattern() {
        return this.datePattern;
    }

    public String getDefaultDatePattern() {
        return defaultDatePattern;
    }

    public static Json getJson() {
        return defaultJsonFactory.getJson();
    }

    public static Json getSkipNullJson() {
        return defaultJsonFactory.getSkipNullJson();
    }

    public static void setTimestampPattern(String timestampPattern) {
        Json.timestampPattern = timestampPattern;
    }

    public static String getTimestampPattern() {
        return timestampPattern;
    }

    public static boolean isLongToString() {
        return longToString;
    }

    public static void setLongToString(boolean longToString) {
        Json.longToString = longToString;
    }

    public abstract String toJson(Object var1);

    public abstract byte[] toJsonBytes(Object var1);

    public abstract Object parse(String var1);

    public abstract <T> T parse(String var1, Class<T> var2);

    public abstract Object parseObject(String var1);

    public abstract Object parseArray(String var1);

    public abstract <T> List<T> parseArray(String var1, Class<T> var2);

    public abstract Map<?, ?> parseToMap(String var1);

    public abstract <K, V> Map<K, V> parseToMap(String var1, Class<K> var2, Class<V> var3);

    public abstract <K, V> List<Map<K, V>> parseToListMap(String var1, Class<K> var2, Class<V> var3);

    public abstract <T> T parse(String var1, Type var2);

    public abstract <T> T parse(byte[] var1, Type var2);

    public abstract <T> T parse(String var1, TioTypeReference<T> var2);
}

