/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.tio.utils.json;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.litongjava.model.type.TioTypeReference;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;

public class JacksonUtils {
    private static boolean defaultGenerateNullValue = true;
    protected static Boolean generateNullValue = null;
    protected static final ObjectMapper objectMapper = new ObjectMapper();

    public static void setDefaultGenerateNullValue(boolean defaultGenerateNullValue) {
        JacksonUtils.defaultGenerateNullValue = defaultGenerateNullValue;
    }

    public static void setGenerateNullValue(boolean generateNullValue) {
        JacksonUtils.generateNullValue = generateNullValue;
    }

    public static ObjectMapper getObjectMapper() {
        return objectMapper;
    }

    public static JacksonUtils getJson() {
        return new JacksonUtils();
    }

    public static String toJson(Object object) {
        boolean pnv;
        boolean bl = pnv = generateNullValue != null ? generateNullValue : defaultGenerateNullValue;
        if (!pnv) {
            objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        }
        try {
            return objectMapper.writeValueAsString(object);
        }
        catch (Exception e) {
            throw e instanceof RuntimeException ? (RuntimeException)e : new RuntimeException(e);
        }
    }

    public static byte[] toJsonBytes(Object object) {
        boolean pnv;
        boolean bl = pnv = generateNullValue != null ? generateNullValue : defaultGenerateNullValue;
        if (!pnv) {
            objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        }
        try {
            return objectMapper.writeValueAsBytes(object);
        }
        catch (Exception e) {
            throw e instanceof RuntimeException ? (RuntimeException)e : new RuntimeException(e);
        }
    }

    public static <T> T parse(String jsonString, Class<T> type) {
        try {
            return (T)objectMapper.readValue(jsonString, type);
        }
        catch (Exception e) {
            throw e instanceof RuntimeException ? (RuntimeException)e : new RuntimeException(e);
        }
    }

    public static Map<?, ?> parseToMap(String json) {
        try {
            return (Map)objectMapper.readValue(json, Map.class);
        }
        catch (Exception e) {
            throw e instanceof RuntimeException ? (RuntimeException)e : new RuntimeException(e);
        }
    }

    public static <K, V> Map<K, V> parseToMap(String json, Class<K> kType, Class<V> vType) {
        TypeReference typeReference = new TypeReference<Map<K, V>>(){};
        try {
            return (Map)objectMapper.readValue(json, typeReference);
        }
        catch (Exception e) {
            throw e instanceof RuntimeException ? (RuntimeException)e : new RuntimeException(e);
        }
    }

    public static Object parseObject(String jsonString) {
        try {
            return objectMapper.readTree(jsonString);
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Object parseArray(String jsonString) {
        try {
            return objectMapper.readTree(jsonString);
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static <T> List<T> parseArray(String str, Class<T> elementType) {
        try {
            return (List)objectMapper.readValue(str, (JavaType)objectMapper.getTypeFactory().constructCollectionType(List.class, elementType));
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static <K, V> List<Map<K, V>> parseToListMap(String stringValue, Class<K> kType, Class<V> vType) {
        try {
            TypeReference typeReference = new TypeReference<List<Map<K, V>>>(){};
            return (List)objectMapper.readValue(stringValue, typeReference);
        }
        catch (Exception e) {
            throw e instanceof RuntimeException ? (RuntimeException)e : new RuntimeException(e);
        }
    }

    public static Object parse(String stringValue) {
        try {
            return objectMapper.readValue(stringValue, Object.class);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T parse(String body, Type type) {
        try {
            JavaType javaType = objectMapper.getTypeFactory().constructType(type);
            return (T)objectMapper.readValue(body, javaType);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T parse(byte[] body, Type type) {
        JavaType javaType = objectMapper.getTypeFactory().constructType(type);
        try {
            return (T)objectMapper.readValue(body, javaType);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T parse(String body, TioTypeReference<T> tioTypeReference) {
        Type type = tioTypeReference.getType();
        JavaType javaType = objectMapper.getTypeFactory().constructType(type);
        try {
            return (T)objectMapper.readValue(body, javaType);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static {
        objectMapper.configure(JsonParser.Feature.ALLOW_UNQUOTED_CONTROL_CHARS, true);
        objectMapper.configure(JsonParser.Feature.ALLOW_BACKSLASH_ESCAPING_ANY_CHARACTER, true);
        objectMapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
    }
}

