/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.tio.utils.hutool;

import com.litongjava.tio.utils.hutool.FastByteArrayOutputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class ZipUtil {
    public static byte[] gzip(byte[] input) {
        FastByteArrayOutputStream bos = new FastByteArrayOutputStream(input.length);
        try (GZIPOutputStream gos = new GZIPOutputStream(bos);){
            gos.write(input, 0, input.length);
            gos.finish();
            gos.flush();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return bos.toByteArray();
    }

    public static byte[] unGzip(byte[] input) {
        try (FastByteArrayOutputStream bos = new FastByteArrayOutputStream(input.length);){
            try (GZIPInputStream gis = new GZIPInputStream(new ByteArrayInputStream(input));){
                int len;
                byte[] buffer = new byte[input.length];
                while ((len = gis.read(buffer)) != -1) {
                    bos.write(buffer, 0, len);
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            byte[] byArray = bos.toByteArray();
            return byArray;
        }
    }
}

