/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.tio.utils.hutool;

import com.litongjava.tio.utils.hutool.StrUtil;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.stream.Stream;

public class ResourceUtil {
    private static String CLASSPATH_PRE = "classpath:";

    public static String getAbsolutePath(String path) {
        return ResourceUtil.getDecodedPath(ResourceUtil.getResource(path));
    }

    public static URL getResource(String path) {
        if (StrUtil.startWithIgnoreCase(path, CLASSPATH_PRE)) {
            path = path.substring(CLASSPATH_PRE.length());
        }
        return ResourceUtil.getClassLoader().getResource(path);
    }

    public static InputStream getResourceAsStream(String path) {
        if (StrUtil.startWithIgnoreCase(path, CLASSPATH_PRE)) {
            path = path.substring(CLASSPATH_PRE.length());
        }
        return ResourceUtil.getClassLoader().getResourceAsStream(path);
    }

    private static ClassLoader getClassLoader() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null && null == (classLoader = ResourceUtil.class.getClassLoader())) {
            classLoader = ClassLoader.getSystemClassLoader();
        }
        return classLoader;
    }

    private static String getDecodedPath(URL url) {
        if (null == url) {
            return null;
        }
        String path = null;
        try {
            path = url.toURI().getPath();
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        return null != path ? path : url.getPath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<URL> listResources(String dirPath, String fileExtension) {
        Enumeration<URL> dirUrls;
        ArrayList<URL> result = new ArrayList<URL>();
        try {
            dirUrls = Thread.currentThread().getContextClassLoader().getResources(dirPath);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to get resources for directory: " + dirPath, e);
        }
        while (dirUrls.hasMoreElements()) {
            URL dirUrl = dirUrls.nextElement();
            String protocol = dirUrl.getProtocol();
            if ("file".equals(protocol)) {
                String urlPath = dirUrl.getPath();
                if (System.getProperty("os.name").toLowerCase().contains("win") && urlPath.startsWith("/")) {
                    urlPath = urlPath.substring(1);
                }
                Path dirPathObj = Paths.get(urlPath, new String[0]);
                try {
                    Stream<Path> stream = Files.walk(dirPathObj, new FileVisitOption[0]);
                    Throwable throwable = null;
                    try {
                        Iterator it = stream.iterator();
                        while (it.hasNext()) {
                            Path p = (Path)it.next();
                            if (!p.toString().endsWith(fileExtension)) continue;
                            result.add(p.toUri().toURL());
                        }
                        continue;
                    }
                    catch (Throwable it) {
                        throwable = it;
                        throw it;
                    }
                    finally {
                        if (stream == null) continue;
                        if (throwable != null) {
                            try {
                                stream.close();
                            }
                            catch (Throwable it) {
                                throwable.addSuppressed(it);
                            }
                            continue;
                        }
                        stream.close();
                        continue;
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException("Failed to walk file tree for: " + dirUrl, e);
                }
            }
            if (!"jar".equals(protocol)) continue;
            try {
                JarURLConnection conn = (JarURLConnection)dirUrl.openConnection();
                JarFile outerJar = conn.getJarFile();
                String entryName = conn.getEntryName();
                if (entryName != null && entryName.contains(".jar!/")) {
                    String nestedJarEntry = entryName.substring(0, entryName.indexOf("!/"));
                    JarEntry nested = outerJar.getJarEntry(nestedJarEntry);
                    InputStream is = outerJar.getInputStream(nested);
                    Throwable throwable = null;
                    try {
                        Path tmp = Files.createTempFile("nested-", ".jar", new FileAttribute[0]);
                        Files.copy(is, tmp, StandardCopyOption.REPLACE_EXISTING);
                        try {
                            JarFile innerJar = new JarFile(tmp.toFile());
                            Throwable throwable2 = null;
                            try {
                                ResourceUtil.scanJar(innerJar, dirPath, fileExtension, result);
                                continue;
                            }
                            catch (Throwable throwable3) {
                                throwable2 = throwable3;
                                throw throwable3;
                            }
                            finally {
                                if (innerJar == null) continue;
                                if (throwable2 != null) {
                                    try {
                                        innerJar.close();
                                    }
                                    catch (Throwable throwable4) {
                                        throwable2.addSuppressed(throwable4);
                                    }
                                    continue;
                                }
                                innerJar.close();
                                continue;
                            }
                        }
                        finally {
                            Files.deleteIfExists(tmp);
                            continue;
                        }
                    }
                    catch (Throwable throwable5) {
                        throwable = throwable5;
                        throw throwable5;
                    }
                    finally {
                        if (is == null) continue;
                        if (throwable != null) {
                            try {
                                is.close();
                            }
                            catch (Throwable throwable6) {
                                throwable.addSuppressed(throwable6);
                            }
                            continue;
                        }
                        is.close();
                        continue;
                    }
                }
                ResourceUtil.scanJar(outerJar, dirPath, fileExtension, result);
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to read JAR resources for: " + dirUrl, e);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<URL> listResources(String dirPath) {
        Enumeration<URL> dirUrls;
        ArrayList<URL> result = new ArrayList<URL>();
        try {
            dirUrls = Thread.currentThread().getContextClassLoader().getResources(dirPath);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to get resources for directory: " + dirPath, e);
        }
        while (dirUrls.hasMoreElements()) {
            URL dirUrl = dirUrls.nextElement();
            String protocol = dirUrl.getProtocol();
            if ("file".equals(protocol)) {
                String urlPath = dirUrl.getPath();
                if (System.getProperty("os.name").toLowerCase().contains("win") && urlPath.startsWith("/")) {
                    urlPath = urlPath.substring(1);
                }
                Path dirPathObj = Paths.get(urlPath, new String[0]);
                try {
                    Stream<Path> stream = Files.walk(dirPathObj, new FileVisitOption[0]);
                    Throwable throwable = null;
                    try {
                        stream.forEach(p -> result.add(dirUrl));
                        continue;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (stream == null) continue;
                        if (throwable != null) {
                            try {
                                stream.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        stream.close();
                        continue;
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException("Failed to walk file tree for: " + dirUrl, e);
                }
            }
            if (!"jar".equals(protocol)) continue;
            try {
                JarURLConnection conn = (JarURLConnection)dirUrl.openConnection();
                JarFile outerJar = conn.getJarFile();
                String entryName = conn.getEntryName();
                if (entryName != null && entryName.contains(".jar!/")) {
                    String nestedJarEntry = entryName.substring(0, entryName.indexOf("!/"));
                    JarEntry nested = outerJar.getJarEntry(nestedJarEntry);
                    InputStream is = outerJar.getInputStream(nested);
                    Throwable throwable = null;
                    try {
                        Path tmp = Files.createTempFile("nested-", ".jar", new FileAttribute[0]);
                        Files.copy(is, tmp, StandardCopyOption.REPLACE_EXISTING);
                        try {
                            JarFile innerJar = new JarFile(tmp.toFile());
                            Throwable throwable4 = null;
                            try {
                                ResourceUtil.scanJar(innerJar, dirPath, result);
                                continue;
                            }
                            catch (Throwable throwable5) {
                                throwable4 = throwable5;
                                throw throwable5;
                            }
                            finally {
                                if (innerJar == null) continue;
                                if (throwable4 != null) {
                                    try {
                                        innerJar.close();
                                    }
                                    catch (Throwable throwable6) {
                                        throwable4.addSuppressed(throwable6);
                                    }
                                    continue;
                                }
                                innerJar.close();
                                continue;
                            }
                        }
                        finally {
                            Files.deleteIfExists(tmp);
                            continue;
                        }
                    }
                    catch (Throwable throwable7) {
                        throwable = throwable7;
                        throw throwable7;
                    }
                    finally {
                        if (is == null) continue;
                        if (throwable != null) {
                            try {
                                is.close();
                            }
                            catch (Throwable throwable8) {
                                throwable.addSuppressed(throwable8);
                            }
                            continue;
                        }
                        is.close();
                        continue;
                    }
                }
                ResourceUtil.scanJar(outerJar, dirPath, result);
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to read JAR resources for: " + dirUrl, e);
            }
        }
        return result;
    }

    public static void scanJar(JarFile jar, String dirPath, List<URL> result) {
        String jarFilePath = Paths.get(jar.getName(), new String[0]).toUri().toString();
        String jarUrlPrefix = "jar:" + jarFilePath + "!/";
        Enumeration<JarEntry> entries = jar.entries();
        while (entries.hasMoreElements()) {
            JarEntry entry = entries.nextElement();
            String name = entry.getName();
            if (!name.startsWith(dirPath + "/") || entry.isDirectory()) continue;
            try {
                URL resourceUrl = new URL(jarUrlPrefix + name);
                result.add(resourceUrl);
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
        }
    }

    public static void scanJar(JarFile jar, String dirPath, String fileExtension, List<URL> result) {
        String jarFilePath = Paths.get(jar.getName(), new String[0]).toUri().toString();
        String jarUrlPrefix = "jar:" + jarFilePath + "!/";
        Enumeration<JarEntry> entries = jar.entries();
        while (entries.hasMoreElements()) {
            JarEntry entry = entries.nextElement();
            String name = entry.getName();
            if (!name.startsWith(dirPath + "/") || !name.endsWith(fileExtension) || entry.isDirectory()) continue;
            try {
                URL resourceUrl = new URL(jarUrlPrefix + name);
                result.add(resourceUrl);
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
        }
    }
}

