/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.tio.utils.hutool;

import com.litongjava.tio.utils.hutool.StrUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;

public class FileUtil {
    private static final char UNIX_SEPARATOR = '/';
    private static final char WINDOWS_SEPARATOR = '\\';

    public static String extName(File file) {
        if (null == file) {
            return null;
        }
        if (file.isDirectory()) {
            return null;
        }
        return FileUtil.extName(file.getName());
    }

    public static String extName(String fileName) {
        if (fileName == null) {
            return null;
        }
        int index = fileName.lastIndexOf(".");
        if (index == -1) {
            return "";
        }
        String ext = fileName.substring(index + 1);
        return ext.contains(String.valueOf('/')) || ext.contains(String.valueOf('\\')) ? "" : ext;
    }

    public static void writeBytes(byte[] data, File file) {
        if (!file.exists()) {
            try {
                file.createNewFile();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        String canonicalPath = null;
        try {
            canonicalPath = file.getCanonicalPath();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        try (OutputStream fos = Files.newOutputStream(Paths.get(canonicalPath, new String[0]), new OpenOption[0]);){
            fos.write(data);
            fos.flush();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void writeString(String content, String path, String charset) throws UnsupportedEncodingException {
        byte[] data = content.getBytes(charset);
        File file = new File(path);
        FileUtil.writeBytes(data, file);
    }

    public static void writeString(String content, String path) {
        File file = new File(path);
        FileUtil.writeString(content, file);
    }

    public static void writeString(String content, File file) {
        byte[] data = content.getBytes();
        FileUtil.writeBytes(data, file);
    }

    public static boolean clean(File directory) throws Exception {
        File[] files;
        if (directory == null || !directory.exists() || !directory.isDirectory()) {
            return true;
        }
        for (File childFile : files = directory.listFiles()) {
            boolean isOk = FileUtil.del(childFile);
            if (isOk) continue;
            return false;
        }
        return true;
    }

    public static boolean del(File file) throws Exception {
        if (file == null || !file.exists()) {
            return false;
        }
        if (file.isDirectory()) {
            FileUtil.clean(file);
        }
        try {
            Files.delete(file.toPath());
        }
        catch (IOException e) {
            throw new Exception(e);
        }
        return true;
    }

    public static byte[] readBytes(File file) {
        Path fileLocation = file.toPath();
        byte[] data = null;
        try {
            data = Files.readAllBytes(fileLocation);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return data;
    }

    public static String readString(File file) {
        byte[] data = FileUtil.readBytes(file);
        return new String(data);
    }

    public static String readUTF8String(File file) {
        byte[] data = FileUtil.readBytes(file);
        try {
            return new String(data, "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static List<File> loopFiles(String path, FileFilter fileFilter) {
        return FileUtil.loopFiles(FileUtil.file(path), fileFilter);
    }

    public static List<File> loopFiles(File file, FileFilter fileFilter) {
        ArrayList<File> fileList = new ArrayList<File>();
        if (null == file) {
            return fileList;
        }
        if (!file.exists()) {
            return fileList;
        }
        if (file.isDirectory()) {
            File[] subFiles = file.listFiles();
            if (subFiles != null && subFiles.length > 0) {
                for (File tmp : subFiles) {
                    fileList.addAll(FileUtil.loopFiles(tmp, fileFilter));
                }
            }
        } else if (null == fileFilter || fileFilter.accept(file)) {
            fileList.add(file);
        }
        return fileList;
    }

    public static List<File> loopFiles(String path) {
        return FileUtil.loopFiles(FileUtil.file(path));
    }

    public static List<File> loopFiles(File file) {
        return FileUtil.loopFiles(file, null);
    }

    public static File file(String path) {
        if (StrUtil.isBlank(path)) {
            throw new NullPointerException("File path is blank!");
        }
        return new File(path);
    }

    public static String readString(URL resource) {
        if (resource == null) {
            throw new RuntimeException();
        }
        StringBuilder text = new StringBuilder();
        try (InputStream inputStream = resource.openStream();
             BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));){
            int bytesRead;
            char[] buffer = new char[1024];
            while ((bytesRead = reader.read(buffer, 0, buffer.length)) != -1) {
                text.append(buffer, 0, bytesRead);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return text.toString();
    }

    /*
     * Exception decompiling
     */
    public static byte[] readBytes(URL resource) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public static List<String> readURLAsLines(URL resource) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

