/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.tio.utils.http.useragent;

import com.litongjava.model.http.useragent.UserAgent;
import com.litongjava.model.http.useragent.UserAgentBrowser;
import com.litongjava.model.http.useragent.UserAgentEngine;
import com.litongjava.model.http.useragent.UserAgentOS;
import com.litongjava.model.http.useragent.UserAgentPlatform;
import com.litongjava.tio.utils.hutool.ReUtil;
import java.util.regex.Pattern;

public class UserAgentParser {
    public static UserAgent parse(String userAgentString) {
        UserAgent userAgent = new UserAgent();
        UserAgentBrowser browser = UserAgentParser.parseBrowser(userAgentString);
        userAgent.setBrowser(UserAgentParser.parseBrowser(userAgentString));
        userAgent.setVersion(browser.getVersion(userAgentString));
        UserAgentEngine engine = UserAgentParser.parseEngine(userAgentString);
        userAgent.setEngine(engine);
        if (!engine.isUnknown()) {
            userAgent.setEngineVersion(UserAgentParser.parseEngineVersion(engine, userAgentString));
        }
        userAgent.setOs(UserAgentParser.parseOS(userAgentString));
        UserAgentPlatform platform = UserAgentParser.parsePlatform(userAgentString);
        userAgent.setPlatform(platform);
        userAgent.setMobile(platform.isMobile() || browser.isMobile());
        return userAgent;
    }

    private static UserAgentBrowser parseBrowser(String userAgentString) {
        for (UserAgentBrowser brower : UserAgentBrowser.browers) {
            if (!brower.isMatch(userAgentString)) continue;
            return brower;
        }
        return UserAgentBrowser.Unknown;
    }

    private static UserAgentEngine parseEngine(String userAgentString) {
        for (UserAgentEngine engine : UserAgentEngine.engines) {
            if (!engine.isMatch(userAgentString)) continue;
            return engine;
        }
        return UserAgentEngine.Unknown;
    }

    private static String parseEngineVersion(UserAgentEngine engine, String userAgentString) {
        String regexp = engine.getName() + "[\\/\\- ]([\\d\\w\\.\\-]+)";
        Pattern pattern = Pattern.compile(regexp, 2);
        return ReUtil.getGroup1(pattern, userAgentString);
    }

    private static UserAgentOS parseOS(String userAgentString) {
        for (UserAgentOS os : UserAgentOS.oses) {
            if (!os.isMatch(userAgentString)) continue;
            return os;
        }
        return UserAgentOS.Unknown;
    }

    private static UserAgentPlatform parsePlatform(String userAgentString) {
        for (UserAgentPlatform platform : UserAgentPlatform.platforms) {
            if (!platform.isMatch(userAgentString)) continue;
            return platform;
        }
        return UserAgentPlatform.Unknown;
    }
}

