/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.tio.utils.environment;

import com.litongjava.tio.utils.environment.Prop;
import com.litongjava.tio.utils.hutool.ResourceUtil;
import com.litongjava.tio.utils.hutool.StrUtil;
import java.io.File;
import java.nio.charset.Charset;
import java.util.concurrent.ConcurrentHashMap;

public class PropUtils {
    private static String envKey = "app.env";
    private static Prop prop = null;
    private static final ConcurrentHashMap<String, Prop> cache = new ConcurrentHashMap();

    private PropUtils() {
    }

    public static void setEnvKey(String envKey) {
        PropUtils.envKey = envKey;
    }

    public static String getEnvKey() {
        return envKey;
    }

    public static String getEnv() {
        return PropUtils.getProp().get(envKey);
    }

    public static Prop use(String fileName) {
        return PropUtils.use(fileName, Prop.DEFAULT_ENCODING);
    }

    public static Prop use(String fileName, String env) {
        return PropUtils.use(fileName, env, Prop.DEFAULT_ENCODING);
    }

    private static Prop use(String fileName, Charset encoding) {
        return PropUtils.use(fileName, null, encoding);
    }

    public static Prop use(String fileName, String env, Charset encoding) {
        return cache.computeIfAbsent(fileName, key -> {
            Prop ret = new Prop((String)key, encoding);
            PropUtils.handleEnv(ret, key, env);
            if (prop == null) {
                prop = ret;
            }
            return ret;
        });
    }

    private static void handleEnv(Prop ret, String key) {
        PropUtils.handleEnv(ret, key, null);
    }

    private static void handleEnv(Prop result, String fileName, String env) {
        int index;
        String envConfigName;
        if (env == null) {
            env = result.get(envKey);
        }
        if (StrUtil.isNotBlank(env) && ResourceUtil.getResource(envConfigName = fileName.substring(0, index = fileName.lastIndexOf(46)) + "-" + env + fileName.substring(index)) != null) {
            Prop envConfig = new Prop(envConfigName);
            result.append(envConfig);
        }
    }

    public static Prop use(File file) {
        return PropUtils.use(file, Prop.DEFAULT_ENCODING);
    }

    public static Prop use(File file, Charset encoding) {
        return cache.computeIfAbsent(file.getName(), key -> {
            Prop ret = new Prop(file, encoding);
            PropUtils.handleEnv(ret, key);
            if (prop == null) {
                prop = ret;
            }
            return ret;
        });
    }

    public static Prop useless(String fileName) {
        Prop previous = cache.remove(fileName);
        if (prop == previous) {
            prop = null;
        }
        return previous;
    }

    public static void clear() {
        prop = null;
        cache.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Prop append(Prop prop) {
        Class<PropUtils> clazz = PropUtils.class;
        synchronized (PropUtils.class) {
            if (PropUtils.prop != null) {
                PropUtils.prop.append(prop);
            } else {
                PropUtils.prop = prop;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return PropUtils.prop;
        }
    }

    public static Prop append(String fileName, Charset encoding) {
        return PropUtils.append(new Prop(fileName, encoding));
    }

    public static Prop append(String fileName) {
        return PropUtils.append(fileName, Prop.DEFAULT_ENCODING);
    }

    public static Prop appendIfExists(String fileName, Charset encoding) {
        try {
            return PropUtils.append(new Prop(fileName, encoding));
        }
        catch (Exception e) {
            return prop;
        }
    }

    public static Prop appendIfExists(String fileName) {
        return PropUtils.appendIfExists(fileName, Prop.DEFAULT_ENCODING);
    }

    public static Prop append(File file, Charset encoding) {
        return PropUtils.append(new Prop(file, encoding));
    }

    public static Prop append(File file) {
        return PropUtils.append(file, Prop.DEFAULT_ENCODING);
    }

    public static Prop appendIfExists(File file, Charset encoding) {
        if (file.exists()) {
            PropUtils.append(new Prop(file, encoding));
        }
        return prop;
    }

    public static Prop appendIfExists(File file) {
        return PropUtils.appendIfExists(file, Prop.DEFAULT_ENCODING);
    }

    public static Prop useFirstFound(String ... fileNames) {
        for (String fn : fileNames) {
            try {
                return PropUtils.use(fn, Prop.DEFAULT_ENCODING);
            }
            catch (Exception exception) {
            }
        }
        throw new IllegalArgumentException("\u6ca1\u6709\u914d\u7f6e\u6587\u4ef6\u53ef\u88ab\u4f7f\u7528");
    }

    public static boolean isLoad() {
        return prop != null;
    }

    public static Prop getProp() {
        if (prop == null) {
            throw new IllegalStateException("Load propties file by invoking PropKit.use(String fileName) method first.");
        }
        return prop;
    }

    public static Prop getProp(String fileName) {
        return cache.get(fileName);
    }

    public static String get(String key) {
        return PropUtils.getProp().get(key);
    }

    public static String get(String key, String defaultValue) {
        return PropUtils.getProp().get(key, defaultValue);
    }

    public static Integer getInt(String key) {
        return PropUtils.getProp().getInt(key);
    }

    public static Integer getInt(String key, Integer defaultValue) {
        return PropUtils.getProp().getInt(key, defaultValue);
    }

    public static Long getLong(String key) {
        return PropUtils.getProp().getLong(key);
    }

    public static Long getLong(String key, Long defaultValue) {
        return PropUtils.getProp().getLong(key, defaultValue);
    }

    public static Double getDouble(String key) {
        return PropUtils.getProp().getDouble(key);
    }

    public static Double getDouble(String key, Double defaultValue) {
        return PropUtils.getProp().getDouble(key, defaultValue);
    }

    public static Boolean getBoolean(String key) {
        return PropUtils.getProp().getBoolean(key);
    }

    public static Boolean getBoolean(String key, Boolean defaultValue) {
        return PropUtils.getProp().getBoolean(key, defaultValue);
    }

    public static boolean containsKey(String key) {
        return PropUtils.getProp().containsKey(key);
    }
}

