/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.tio.utils.caffeine;

import com.github.benmanes.caffeine.cache.CacheLoader;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.github.benmanes.caffeine.cache.RemovalListener;
import com.litongjava.tio.utils.cache.caffeine.DefaultRemovalListener;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;

public class CaffeineUtils {
    private static final ConcurrentHashMap<String, LoadingCache<?, ?>> cacheMap = new ConcurrentHashMap();

    public static <K, V> LoadingCache<K, V> createLoadingCache(String cacheName, Long timeToLiveSeconds, Long timeToIdleSeconds, Integer initialCapacity, Integer maximumSize, boolean recordStats) {
        return CaffeineUtils.createLoadingCache(cacheName, timeToLiveSeconds, timeToIdleSeconds, initialCapacity, maximumSize, recordStats, null);
    }

    public static <K, V> LoadingCache<K, V> createLoadingCache(String cacheName, Long timeToLiveSeconds, Long timeToIdleSeconds, Integer initialCapacity, Integer maximumSize, boolean recordStats, RemovalListener<K, V> removalListener) {
        if (removalListener == null) {
            removalListener = new DefaultRemovalListener(cacheName);
        }
        Caffeine cacheBuilder = Caffeine.newBuilder().removalListener(removalListener);
        if (timeToLiveSeconds != null && timeToLiveSeconds > 0L) {
            cacheBuilder.expireAfterWrite(timeToLiveSeconds.longValue(), TimeUnit.SECONDS);
        }
        if (timeToIdleSeconds != null && timeToIdleSeconds > 0L) {
            cacheBuilder.expireAfterAccess(timeToIdleSeconds.longValue(), TimeUnit.SECONDS);
        }
        cacheBuilder.initialCapacity(initialCapacity.intValue());
        cacheBuilder.maximumSize((long)maximumSize.intValue());
        if (recordStats) {
            cacheBuilder.recordStats();
        }
        LoadingCache loadingCache = cacheBuilder.build(new CacheLoader<K, V>(){

            public V load(K key) throws Exception {
                return null;
            }
        });
        return loadingCache;
    }

    public static <K, V> LoadingCache<K, V> getCache(String name, Long timeToLiveSeconds, Long timeToIdleSeconds, Integer initialCapacity, Integer maximumSize, boolean recordStats) {
        return cacheMap.computeIfAbsent(name, key -> CaffeineUtils.createLoadingCache(name, timeToLiveSeconds, timeToIdleSeconds, initialCapacity, maximumSize, recordStats));
    }

    public static <K, V> LoadingCache<K, V> getCache(String name) {
        Long timeToLiveSeconds = 600L;
        Long timeToIdleSeconds = 600L;
        Integer initialCapacity = 500;
        Integer maximumSize = Integer.MAX_VALUE;
        boolean recordStats = true;
        return cacheMap.computeIfAbsent(name, key -> CaffeineUtils.createLoadingCache(name, timeToLiveSeconds, timeToIdleSeconds, initialCapacity, maximumSize, recordStats));
    }
}

