/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.tio.utils.cache.redis;

import com.litongjava.tio.utils.cache.AbsCache;
import com.litongjava.tio.utils.cache.CacheFactory;
import com.litongjava.tio.utils.cache.CacheName;
import com.litongjava.tio.utils.cache.RemovalListenerWrapper;
import com.litongjava.tio.utils.cache.redis.RedisExpireUpdateTask;
import com.litongjava.tio.utils.cache.redis.TioRedisCache;
import java.util.HashMap;
import java.util.Map;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum RedisCacheFactory implements CacheFactory
{
    INSTANCE;

    private Logger log = LoggerFactory.getLogger(RedisCacheFactory.class);
    private Map<String, TioRedisCache> map = new HashMap<String, TioRedisCache>();
    private RedissonClient redisson;
    private Object lock = new Object();

    public RedissonClient getRedisson() {
        return this.redisson;
    }

    public void setRedisson(RedissonClient redisson) {
        this.redisson = redisson;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TioRedisCache register(String cacheName, Long timeToLiveSeconds, Long timeToIdleSeconds) {
        RedisExpireUpdateTask.start(this);
        TioRedisCache redisCache = this.map.get(cacheName);
        if (redisCache == null) {
            Object object = this.lock;
            synchronized (object) {
                redisCache = this.map.get(cacheName);
                if (redisCache == null) {
                    redisCache = new TioRedisCache(this.redisson, cacheName, timeToLiveSeconds, timeToIdleSeconds);
                    redisCache.setTimeToIdleSeconds(timeToIdleSeconds);
                    redisCache.setTimeToLiveSeconds(timeToLiveSeconds);
                    this.map.put(cacheName, redisCache);
                }
            }
        }
        return redisCache;
    }

    @Override
    public <T> TioRedisCache register(String cacheName, Long timeToLiveSeconds, Long timeToIdleSeconds, RemovalListenerWrapper<T> removalListenerWrapper) {
        return null;
    }

    @Override
    public TioRedisCache getCache(String cacheName, boolean skipNull) {
        TioRedisCache redisCache = this.map.get(cacheName);
        if (redisCache == null) {
            this.log.error("cacheName[{}] is not yet registered, please register first.", (Object)cacheName);
        }
        return redisCache;
    }

    @Override
    public TioRedisCache getCache(String cacheName) {
        return this.map.get(cacheName);
    }

    @Override
    public Map<String, ? extends AbsCache> getMap() {
        return this.map;
    }

    @Override
    public TioRedisCache register(CacheName cacheName) {
        return this.register(cacheName.getName(), cacheName.getTimeToLiveSeconds(), cacheName.getTimeToIdleSeconds());
    }
}

