/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.tio.utils.cache.mapcache;

import com.litongjava.tio.utils.cache.AbsCache;
import com.litongjava.tio.utils.cache.CacheRemovalListener;
import com.litongjava.tio.utils.cache.RemovalCause;
import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class ConcurrentMapCache
extends AbsCache {
    private CacheRemovalListener<String, Serializable> removalListener;
    private final ConcurrentHashMap<String, Serializable> map = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, Long> expirationTimes = new ConcurrentHashMap();
    private final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);

    public ConcurrentMapCache(String cacheName, Long timeToLiveSeconds, Long timeToIdleSeconds, CacheRemovalListener<String, Serializable> removalListener) {
        super(cacheName, timeToLiveSeconds, timeToIdleSeconds);
        this.removalListener = removalListener;
    }

    public void clear() {
        this.map.clear();
        this.expirationTimes.clear();
    }

    @Override
    public Serializable _get(String key) {
        Serializable value = this.map.get(key);
        if (value != null && this.getTimeToIdleSeconds() != null) {
            long newExpirationTime = System.currentTimeMillis() + TimeUnit.SECONDS.toMillis(this.getTimeToIdleSeconds());
            this.expirationTimes.put(key, newExpirationTime);
        }
        return value;
    }

    public Iterable<String> keys() {
        Set keySet = this.map.keySet();
        return keySet;
    }

    public Collection<String> keysCollection() {
        return this.map.keySet();
    }

    public void put(String key, Serializable value) {
        this.map.put(key, value);
        this.scheduleExpiration(key, this.getTimeToLiveSeconds());
    }

    public void remove(String key) {
        Serializable value = this.map.remove(key);
        this.expirationTimes.remove(key);
        if (this.removalListener != null && value != null) {
            this.removalListener.onCacheRemoval(key, value, RemovalCause.EXPLICIT);
        }
    }

    public void putTemporary(String key, Serializable value) {
        this.map.put(key, value);
        this.scheduleExpiration(key, 600L);
    }

    public long ttl(String key) {
        Long expirationTime = this.expirationTimes.get(key);
        return expirationTime != null ? expirationTime - System.currentTimeMillis() : -1L;
    }

    private void scheduleExpiration(String key, Long ttl) {
        long ttlExpirationTime = ttl != null ? System.currentTimeMillis() + TimeUnit.SECONDS.toMillis(ttl) : Long.MAX_VALUE;
        long ttiExpirationTime = this.getTimeToIdleSeconds() != null ? System.currentTimeMillis() + TimeUnit.SECONDS.toMillis(this.getTimeToIdleSeconds()) : Long.MAX_VALUE;
        long expirationTime = Math.min(ttlExpirationTime, ttiExpirationTime);
        this.expirationTimes.put(key, expirationTime);
        this.scheduler.schedule(() -> {
            Long storedExpirationTime = this.expirationTimes.get(key);
            if (storedExpirationTime != null && System.currentTimeMillis() >= storedExpirationTime) {
                Serializable value = this.map.remove(key);
                this.expirationTimes.remove(key);
                if (this.removalListener != null && value != null) {
                    RemovalCause cause = System.currentTimeMillis() >= ttlExpirationTime ? RemovalCause.EXPIRED : RemovalCause.EVICTED;
                    this.removalListener.onCacheRemoval(key, value, cause);
                }
            }
        }, expirationTime - System.currentTimeMillis(), TimeUnit.MILLISECONDS);
    }

    public Map<String, Serializable> asMap() {
        return this.map;
    }

    public long size() {
        return this.map.size();
    }
}

