/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.tio.utils;

import com.litongjava.tio.utils.thread.pool.DefaultThreadFactory;
import com.litongjava.tio.utils.thread.pool.SynThreadPoolExecutor;
import com.litongjava.tio.utils.thread.pool.TioCallerRunsPolicy;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Threads {
    private static final Logger log = LoggerFactory.getLogger(Threads.class);
    public static final int AVAILABLE_PROCESSORS;
    public static final int CORE_POOL_SIZE;
    public static final int MAX_POOL_SIZE_FOR_TIO;
    public static final int MAX_POOL_SIZE_FOR_GROUP;
    public static final long KEEP_ALIVE_TIME = 0L;
    public static final String GROUP_THREAD_NAME = "tio-group";
    public static final String WORKER_THREAD_NAME = "tio-worker";
    private static ExecutorService groupExecutor;
    private static SynThreadPoolExecutor tioExecutor;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ExecutorService getGroupExecutor() {
        if (groupExecutor != null) {
            return groupExecutor;
        }
        Class<Threads> clazz = Threads.class;
        synchronized (Threads.class) {
            if (groupExecutor == null) {
                groupExecutor = Threads.newGroupExecutor();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return groupExecutor;
        }
    }

    private static ExecutorService newGroupExecutor() {
        return Executors.newCachedThreadPool(DefaultThreadFactory.getInstance(GROUP_THREAD_NAME, 10));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SynThreadPoolExecutor getTioExecutor() {
        if (tioExecutor != null) {
            return tioExecutor;
        }
        Class<Threads> clazz = Threads.class;
        synchronized (Threads.class) {
            if (tioExecutor == null) {
                tioExecutor = Threads.newTioExecutor();
                log.info("new worker thead pool:{}", (Object)tioExecutor);
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return tioExecutor;
        }
    }

    private static SynThreadPoolExecutor newTioExecutor() {
        LinkedBlockingQueue<Runnable> runnableQueue = new LinkedBlockingQueue<Runnable>();
        DefaultThreadFactory defaultThreadFactory = DefaultThreadFactory.getInstance(WORKER_THREAD_NAME, 10);
        TioCallerRunsPolicy callerRunsPolicy = new TioCallerRunsPolicy();
        SynThreadPoolExecutor executor = new SynThreadPoolExecutor(MAX_POOL_SIZE_FOR_TIO, MAX_POOL_SIZE_FOR_TIO, 0L, runnableQueue, defaultThreadFactory, WORKER_THREAD_NAME, (RejectedExecutionHandler)callerRunsPolicy);
        executor.prestartCoreThread();
        return executor;
    }

    public static StringBuffer status() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(Threads.printThreadPoolStatus(tioExecutor, WORKER_THREAD_NAME));
        return stringBuffer;
    }

    public static StringBuffer printThreadPoolStatus(ThreadPoolExecutor executor, String poolName) {
        if (executor == null) {
            return new StringBuffer("Thread pool " + poolName + " is not initialized.\n");
        }
        int corePoolSize = executor.getCorePoolSize();
        int maximumPoolSize = executor.getMaximumPoolSize();
        int poolSize = executor.getPoolSize();
        int activeCount = executor.getActiveCount();
        int queueSize = executor.getQueue().size();
        long taskCount = executor.getTaskCount();
        long completedTaskCount = executor.getCompletedTaskCount();
        RejectedExecutionHandler handler = executor.getRejectedExecutionHandler();
        int remainingCapacity = executor.getQueue().remainingCapacity();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Thread Pool Name: " + poolName).append("\n");
        stringBuffer.append("Core Pool Size: " + corePoolSize).append("\n");
        stringBuffer.append("Maximum Pool Size: " + maximumPoolSize).append("\n");
        stringBuffer.append("Current Pool Size: " + poolSize).append("\n");
        stringBuffer.append("Active Thread Count: " + activeCount).append("\n");
        stringBuffer.append("Tasks in Queue: " + queueSize).append("\n");
        stringBuffer.append("Total Task Count: " + taskCount).append("\n");
        stringBuffer.append("Completed Task Count: " + completedTaskCount).append("\n");
        stringBuffer.append("Current Rejection Policy: " + handler.getClass().getSimpleName()).append("\n");
        stringBuffer.append("Queue Remaining Capacity: " + remainingCapacity).append("\n");
        return stringBuffer;
    }

    public static boolean close() {
        boolean ret = true;
        if (groupExecutor != null) {
            groupExecutor.shutdown();
            try {
                ret = groupExecutor.awaitTermination(6000L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            log.info("shutdown group thead pool:{}", (Object)groupExecutor);
            groupExecutor = null;
        }
        if (tioExecutor != null) {
            tioExecutor.shutdown();
            try {
                ret = tioExecutor.awaitTermination(6000L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            log.info("shutdown worker thead pool:{}", (Object)tioExecutor);
            tioExecutor = null;
        }
        return ret;
    }

    private Threads() {
    }

    static {
        CORE_POOL_SIZE = AVAILABLE_PROCESSORS = Runtime.getRuntime().availableProcessors();
        MAX_POOL_SIZE_FOR_TIO = Integer.getInteger("TIO_MAX_POOL_SIZE_FOR_TIO", Math.max(CORE_POOL_SIZE * 3, 64));
        MAX_POOL_SIZE_FOR_GROUP = Integer.getInteger("TIO_MAX_POOL_SIZE_FOR_GROUP", Math.max(CORE_POOL_SIZE * 16, 256));
        groupExecutor = null;
        tioExecutor = null;
    }
}

