/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.tio.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

public class SystemTimer {
    private static volatile List<TimerListener> list = null;
    private static final ScheduledExecutorService EXECUTOR = new ScheduledThreadPoolExecutor(1, new ThreadFactory(){

        @Override
        public Thread newThread(Runnable runnable) {
            Thread thread = new Thread(runnable, "TioSystemTimer");
            thread.setDaemon(true);
            return thread;
        }
    });
    private static final long PERIOD = Long.parseLong(System.getProperty("tio.system.timer.period", "10"));
    public static volatile long currTime = System.currentTimeMillis();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static void addTimerListener(TimerListener timerListener) {
        if (list == null) {
            Class<TimerTask> clazz = TimerTask.class;
            // MONITORENTER : com.litongjava.tio.utils.SystemTimer$TimerTask.class
            if (list == null) {
                list = new ArrayList<TimerListener>();
            }
            // MONITOREXIT : clazz
        }
        list.add(timerListener);
    }

    public static long currentTimeMillis() {
        return currTime;
    }

    static {
        EXECUTOR.scheduleAtFixedRate(new TimerTask(), PERIOD, PERIOD, TimeUnit.MILLISECONDS);
        Runtime.getRuntime().addShutdownHook(new Thread("TioSystemTimer-Shutdown"){

            @Override
            public void run() {
                EXECUTOR.shutdown();
            }
        });
    }

    public static interface TimerListener {
        public void onChange(long var1);
    }

    private static class TimerTask
    implements Runnable {
        private TimerTask() {
        }

        @Override
        public void run() {
            currTime = System.currentTimeMillis();
            if (list != null) {
                for (TimerListener timerListener : list) {
                    timerListener.onChange(currTime);
                }
            }
        }
    }
}

