/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.tio.utils;

import java.util.Random;

public class BinaryUtils {
    private static final char[] r = "abcdefghijk23456789mnpqrstuvwxy".toCharArray();
    private static final char b = 'z';
    private static final int binLen = r.length;
    private static final int s = 6;

    public static String encode(int id) {
        char[] buf = new char[32];
        int charPos = 32;
        while (id / binLen > 0) {
            int ind = id % binLen;
            buf[--charPos] = r[ind];
            id /= binLen;
        }
        buf[--charPos] = r[id % binLen];
        String str = new String(buf, charPos, 32 - charPos);
        if (str.length() < 6) {
            StringBuilder sb = new StringBuilder();
            sb.append('z');
            Random rnd = new Random();
            for (int i = 1; i < 6 - str.length(); ++i) {
                sb.append(r[rnd.nextInt(binLen)]);
            }
            str = str + sb.toString();
        }
        return str;
    }

    public static long decode(String code) {
        char[] chs = code.toCharArray();
        long res = 0L;
        for (int i = 0; i < chs.length; ++i) {
            int ind = 0;
            for (int j = 0; j < binLen; ++j) {
                if (chs[i] != r[j]) continue;
                ind = j;
                break;
            }
            if (chs[i] == 'z') break;
            res = i > 0 ? res * (long)binLen + (long)ind : (long)ind;
        }
        return res;
    }

    public static void main(String[] args) {
        int start = 1000000000;
        int end = start + 1000;
        for (int i = start; i < end; ++i) {
            int id = i;
            String code = BinaryUtils.encode(id);
            int nid = (int)BinaryUtils.decode(code);
            if (id != nid) {
                System.out.println(id + " -> " + code + " -> " + nid);
            }
            System.out.println(id + " -> " + code + " -> " + nid);
        }
    }
}

