/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.tio.utils.url;

import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.BitSet;

public class UrlUtils {
    private static final String UNRESERVED = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789-._~";
    private static final BitSet UNRESERVED_CHARACTERS = new BitSet(256);

    public static String encode(String value) {
        byte[] bytes;
        if (value == null) {
            return null;
        }
        StringBuilder encoded = new StringBuilder();
        for (byte b : bytes = value.getBytes(StandardCharsets.UTF_8)) {
            int c = b & 0xFF;
            if (UNRESERVED_CHARACTERS.get(c)) {
                encoded.append((char)c);
                continue;
            }
            encoded.append(String.format("%%%02X", c));
        }
        return encoded.toString();
    }

    public static String decode(String value) {
        if (value == null) {
            return null;
        }
        int length = value.length();
        byte[] buffer = new byte[length];
        int pos = 0;
        for (int i = 0; i < length; ++i) {
            char c = value.charAt(i);
            if (c == '%') {
                if (i + 2 < length) {
                    String hex = value.substring(i + 1, i + 3);
                    buffer[pos++] = (byte)Integer.parseInt(hex, 16);
                    i += 2;
                    continue;
                }
                throw new IllegalArgumentException("Invalid percent-encoding in: " + value);
            }
            buffer[pos++] = (byte)c;
        }
        return new String(buffer, 0, pos, StandardCharsets.UTF_8);
    }

    public static String encodeUrl(String url) {
        if (url == null) {
            return null;
        }
        try {
            URI uri = new URI(url);
            String scheme = uri.getScheme();
            String authority = uri.getRawAuthority();
            String path = uri.getPath();
            String encodedPath = UrlUtils.encodePath(path);
            String query = uri.getRawQuery();
            String fragment = uri.getRawFragment();
            StringBuilder result = new StringBuilder();
            if (scheme != null) {
                result.append(scheme).append(":");
            }
            if (authority != null) {
                result.append("//").append(authority);
            }
            result.append(encodedPath);
            if (query != null) {
                result.append("?").append(query);
            }
            if (fragment != null) {
                result.append("#").append(fragment);
            }
            return result.toString();
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Invalid URL: " + url, e);
        }
    }

    private static String encodePath(String path) {
        byte[] bytes;
        if (path == null) {
            return null;
        }
        StringBuilder encoded = new StringBuilder();
        BitSet allowed = new BitSet(256);
        for (char c : UNRESERVED.toCharArray()) {
            allowed.set(c);
        }
        allowed.set(47);
        for (byte b : bytes = path.getBytes(StandardCharsets.UTF_8)) {
            int c = b & 0xFF;
            if (allowed.get(c)) {
                encoded.append((char)c);
                continue;
            }
            encoded.append(String.format("%%%02X", c));
        }
        return encoded.toString();
    }

    static {
        for (char c : UNRESERVED.toCharArray()) {
            UNRESERVED_CHARACTERS.set(c);
        }
    }
}

