/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.tio.utils.json;

import com.litongjava.model.type.TioTypeReference;
import com.litongjava.tio.utils.json.Json;
import com.litongjava.tio.utils.json.JsonResult;
import com.litongjava.tio.utils.json.TioJsonKit;
import com.litongjava.tio.utils.json.TioToJson;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

public class TioJson
extends Json {
    private String notSupportJsonToObjectMesage = "The default json implementation currently does not support json to object conversion. It is recommended to use MixedJsonFactory and support it by setting Json.setDefaultJsonFactory(new MixedJsonFactory()).";
    protected static final TioJsonKit kit = TioJsonKit.me;
    protected static final ThreadLocal<JsonResult> TL = ThreadLocal.withInitial(() -> new JsonResult());
    protected static int defaultConvertDepth = 16;
    protected int convertDepth = defaultConvertDepth;
    protected boolean skipNullValueField;

    public TioJson() {
    }

    public TioJson(boolean skipNullValueField) {
        this.skipNullValueField = skipNullValueField;
    }

    public static TioJson getJson() {
        return new TioJson();
    }

    public static TioJson getSkipNullTioJson() {
        return new TioJson(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] toJsonBytes(Object object) {
        if (object == null) {
            return null;
        }
        JsonResult ret = TL.get();
        try {
            if (ret.isInUse()) {
                ret = new JsonResult();
            }
            String dp = this.datePattern != null ? this.datePattern : this.getDefaultDatePattern();
            ret.init(dp, TioJson.getTimestampPattern(), Json.isLongToString());
            TioToJson toJson = kit.getToJson(object, this.skipNullValueField);
            toJson.toJson(object, this.convertDepth, ret);
            byte[] byArray = ret.toBytes();
            return byArray;
        }
        finally {
            ret.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String toJson(Object object) {
        if (object == null) {
            return "null";
        }
        JsonResult ret = TL.get();
        try {
            if (ret.isInUse()) {
                ret = new JsonResult();
            }
            String dp = this.datePattern != null ? this.datePattern : this.getDefaultDatePattern();
            ret.init(dp, TioJson.getTimestampPattern(), Json.isLongToString());
            TioToJson toJson = kit.getToJson(object, this.skipNullValueField);
            toJson.toJson(object, this.convertDepth, ret);
            String string = ret.toString();
            return string;
        }
        finally {
            ret.clear();
        }
    }

    public static void addToJson(Class<?> type, TioToJson<?> toJson) {
        TioJsonKit.addToJson(type, toJson);
    }

    public static void setDefaultConvertDepth(int defaultConvertDepth) {
        if (defaultConvertDepth < 2) {
            throw new IllegalArgumentException("defaultConvertDepth depth can not less than 2.");
        }
        TioJson.defaultConvertDepth = defaultConvertDepth;
    }

    public TioJson setConvertDepth(int convertDepth) {
        if (convertDepth < 2) {
            throw new IllegalArgumentException("convert depth can not less than 2.");
        }
        this.convertDepth = convertDepth;
        return this;
    }

    public static void setMaxBufferSize(int maxBufferSize) {
        TioJsonKit.setMaxBufferSize(maxBufferSize);
    }

    public static void setTreatModelAsBean(boolean treatModelAsBean) {
        TioJsonKit.setTreatModelAsBean(treatModelAsBean);
    }

    public static void setModelAndRecordFieldNameConverter(Function<String, String> converter) {
        TioJsonKit.setModelAndRecordFieldNameConverter(converter);
    }

    public static void setModelAndRecordFieldNameToCamelCase(boolean toLowerCaseAnyway) {
        TioJsonKit.setModelAndRecordFieldNameToCamelCase(toLowerCaseAnyway);
    }

    public static void setModelAndRecordFieldNameToCamelCase() {
        TioJsonKit.setModelAndRecordFieldNameToCamelCase();
    }

    public static void setToJsonFactory(Function<Object, TioToJson<?>> toJsonFactory) {
        TioJsonKit.setToJsonFactory(toJsonFactory);
    }

    public void setSkipNullValueField(boolean skipNullValueField) {
        this.skipNullValueField = skipNullValueField;
    }

    @Override
    public <T> T parse(String jsonString, Class<T> type) {
        throw new RuntimeException(this.notSupportJsonToObjectMesage);
    }

    @Override
    public Map<?, ?> parseToMap(String bodyString) {
        throw new RuntimeException(this.notSupportJsonToObjectMesage);
    }

    @Override
    public <K, V> Map<K, V> parseToMap(String json, Class<K> kType, Class<V> vType) {
        throw new RuntimeException(this.notSupportJsonToObjectMesage);
    }

    @Override
    public Object parseObject(String jsonString) {
        throw new RuntimeException(this.notSupportJsonToObjectMesage);
    }

    @Override
    public Object parseArray(String jsonString) {
        throw new RuntimeException(this.notSupportJsonToObjectMesage);
    }

    @Override
    public <K, V> List<Map<K, V>> parseToListMap(String stringValue, Class<K> kType, Class<V> vType) {
        throw new RuntimeException(this.notSupportJsonToObjectMesage);
    }

    @Override
    public Object parse(String stringValue) {
        throw new RuntimeException(this.notSupportJsonToObjectMesage);
    }

    @Override
    public <T> T parse(String body, Type type) {
        throw new RuntimeException(this.notSupportJsonToObjectMesage);
    }

    @Override
    public <T> T parse(byte[] body, Type type) {
        throw new RuntimeException(this.notSupportJsonToObjectMesage);
    }

    @Override
    public <T> List<T> parseArray(String str, Class<T> elementType) {
        throw new RuntimeException(this.notSupportJsonToObjectMesage);
    }

    @Override
    public <T> T parse(String body, TioTypeReference<T> tioTypeReference) {
        throw new RuntimeException(this.notSupportJsonToObjectMesage);
    }
}

