/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.tio.utils.hutool;

import com.litongjava.tio.utils.hutool.ArrayUtil;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CollUtil {
    private static Logger log = LoggerFactory.getLogger(CollUtil.class);

    private CollUtil() {
    }

    public static boolean isEmpty(Collection<?> collection) {
        return collection == null || collection.isEmpty();
    }

    public static boolean isNotEmpty(Collection<?> collection) {
        return false == CollUtil.isEmpty(collection);
    }

    public static <T> List<T> list(boolean isLinked) {
        return isLinked ? new LinkedList() : new ArrayList();
    }

    @SafeVarargs
    public static <T> List<T> list(boolean isLinked, T ... values) {
        if (ArrayUtil.isEmpty(values)) {
            return CollUtil.list(isLinked);
        }
        AbstractList arrayList = isLinked ? new LinkedList() : new ArrayList(values.length);
        Collections.addAll(arrayList, values);
        return arrayList;
    }

    public static <T> List<T> list(boolean isLinked, Collection<T> collection) {
        if (null == collection) {
            return CollUtil.list(isLinked);
        }
        return isLinked ? new LinkedList<T>(collection) : new ArrayList<T>(collection);
    }

    public static <T> List<T> list(boolean isLinked, Iterable<T> iterable) {
        if (null == iterable) {
            return CollUtil.list(isLinked);
        }
        return CollUtil.list(isLinked, iterable.iterator());
    }

    public static <T> List<T> list(boolean isLinked, Iterator<T> iter) {
        List<T> list = CollUtil.list(isLinked);
        if (null != iter) {
            while (iter.hasNext()) {
                list.add(iter.next());
            }
        }
        return list;
    }

    public static <T> List<T> list(boolean isLinked, Enumeration<T> enumration) {
        List<T> list = CollUtil.list(isLinked);
        if (null != enumration) {
            while (enumration.hasMoreElements()) {
                list.add(enumration.nextElement());
            }
        }
        return list;
    }

    @SafeVarargs
    public static <T> ArrayList<T> newArrayList(T ... values) {
        return (ArrayList)CollUtil.list(false, values);
    }

    @SafeVarargs
    public static <T> ArrayList<T> toList(T ... values) {
        return CollUtil.newArrayList(values);
    }

    public static <T> ArrayList<T> newArrayList(Collection<T> collection) {
        return (ArrayList)CollUtil.list(false, collection);
    }

    public static <T> ArrayList<T> newArrayList(Iterable<T> iterable) {
        return (ArrayList)CollUtil.list(false, iterable);
    }

    public static <T> ArrayList<T> newArrayList(Iterator<T> iter) {
        return (ArrayList)CollUtil.list(false, iter);
    }

    public static <T> ArrayList<T> newArrayList(Enumeration<T> enumration) {
        return (ArrayList)CollUtil.list(false, enumration);
    }
}

