/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.tio.utils.http;

import com.litongjava.model.http.response.ResponseVo;
import com.litongjava.tio.utils.http.ContentTypeUtils;
import com.litongjava.tio.utils.http.OkHttpClientPool;
import com.litongjava.tio.utils.hutool.StrUtil;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import okhttp3.Call;
import okhttp3.FormBody;
import okhttp3.Headers;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class HttpUtils {
    public static final MediaType MEDIATYPE_JSON_UTF8 = MediaType.parse((String)"application/json; charset=utf-8");

    public static Response get(String url, Map<String, String> headerMap) throws Exception {
        Request.Builder builder = new Request.Builder().url(url);
        if (headerMap != null) {
            Headers headers = Headers.of(headerMap);
            builder.headers(headers);
        }
        builder.get();
        Request request = builder.build();
        OkHttpClient client = OkHttpClientPool.getHttpClient();
        Response response = client.newCall(request).execute();
        return response;
    }

    public static ResponseVo get(String url) {
        Request request = new Request.Builder().url(url).get().build();
        return HttpUtils.call(request);
    }

    public static ResponseVo upload(String url, File file) {
        String contentType = ContentTypeUtils.getContentType(file.getName());
        RequestBody fileBody = RequestBody.create((File)file, (MediaType)MediaType.parse((String)contentType));
        MultipartBody.Builder builder = new MultipartBody.Builder().setType(MultipartBody.FORM);
        builder.addFormDataPart("file", file.getName(), fileBody);
        MultipartBody requestBody = builder.build();
        Request request = new Request.Builder().url(url).post((RequestBody)requestBody).build();
        ResponseVo responseVo = HttpUtils.call(request);
        return responseVo;
    }

    private static Response post(String url, Map<String, String> headerMap, MediaType mediaType, String bodyString, Map<String, String> paramMap, List<String> paramNames, List<String> paramValues) {
        Request.Builder builder = new Request.Builder().url(url);
        if (headerMap != null) {
            Headers headers = Headers.of(headerMap);
            builder.headers(headers);
        }
        if (!StrUtil.isBlank(bodyString)) {
            if (mediaType == null) {
                mediaType = MEDIATYPE_JSON_UTF8;
            }
            RequestBody body = RequestBody.create((MediaType)mediaType, (String)bodyString);
            builder.post(body);
        } else {
            int xx;
            FormBody.Builder formBodyBuilder = new FormBody.Builder();
            if (paramMap != null && paramMap.size() > 0) {
                Set<Map.Entry<String, String>> set = paramMap.entrySet();
                for (Map.Entry<String, String> entry : set) {
                    formBodyBuilder.add(entry.getKey(), entry.getValue());
                }
            } else if (paramNames != null && (xx = paramNames.size()) > 0) {
                for (int i = 0; i < xx; ++i) {
                    formBodyBuilder.add(paramNames.get(i), paramValues.get(i));
                }
            }
            FormBody formBody = formBodyBuilder.build();
            builder.post((RequestBody)formBody);
        }
        Request request = builder.build();
        Response response = null;
        OkHttpClient client = OkHttpClientPool.getHttpClient();
        try {
            response = client.newCall(request).execute();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return response;
    }

    public static Response post(String url, Map<String, String> headerMap, List<String> paramNames, List<String> paramValues) throws Exception {
        return HttpUtils.post(url, headerMap, null, null, null, paramNames, paramValues);
    }

    public static Response post(String url, Map<String, String> headerMap, Map<String, String> paramMap) throws Exception {
        return HttpUtils.post(url, headerMap, null, null, paramMap, null, null);
    }

    public static Response post(String url, Map<String, String> headerMap, String bodyString) {
        return HttpUtils.post(url, headerMap, null, bodyString, null, null, null);
    }

    public static Response post(String url, Map<String, String> headerMap) throws Exception {
        return HttpUtils.post(url, headerMap, null, null, null, null, null);
    }

    public static Response post(String url) throws Exception {
        return HttpUtils.post(url, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ResponseVo call(Request request) {
        Call call = OkHttpClientPool.getHttpClient().newCall(request);
        try (Response response = call.execute();){
            Headers headers = response.headers();
            String body = response.body().string();
            if (response.isSuccessful()) {
                ResponseVo responseVo = ResponseVo.ok((Headers)headers, (String)body);
                return responseVo;
            }
            ResponseVo responseVo = ResponseVo.fail((Headers)headers, (String)body);
            return responseVo;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ResponseVo get(String url, String key) {
        OkHttpClient client = OkHttpClientPool.get60HttpClient();
        Request request = new Request.Builder().get().url(url).addHeader("Authorization", "Bearer " + key).build();
        try (Response response = client.newCall(request).execute();){
            int code = response.code();
            String string = response.body().string();
            ResponseVo responseVo = new ResponseVo(true, code, string);
            return responseVo;
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to request:" + url, e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ResponseVo postJson(String url, String key, String payload) {
        OkHttpClient client = OkHttpClientPool.get60HttpClient();
        MediaType mediaType = MediaType.parse((String)"application/json");
        RequestBody body = RequestBody.create((String)payload, (MediaType)mediaType);
        Request request = new Request.Builder().url(url).post(body).addHeader("Authorization", "Bearer " + key).build();
        try (Response response = client.newCall(request).execute();){
            String string = response.body().string();
            int code = response.code();
            if (response.isSuccessful()) {
                ResponseVo responseVo = new ResponseVo(true, code, string);
                return responseVo;
            }
            ResponseVo responseVo = new ResponseVo(false, code, string);
            return responseVo;
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to request:" + url, e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ResponseVo download(String url) {
        Request request = new Request.Builder().url(url).get().build();
        try (Response response = OkHttpClientPool.getHttpClient().newCall(request).execute();){
            Headers headers = response.headers();
            int code = response.code();
            if (response.isSuccessful()) {
                byte[] bytes = response.body().bytes();
                ResponseVo responseVo = ResponseVo.ok((Headers)headers, (byte[])bytes);
                responseVo.setCode(code);
                ResponseVo responseVo2 = responseVo;
                return responseVo2;
            }
            String bodyString = response.body() != null ? response.body().string() : "";
            ResponseVo responseVo = ResponseVo.fail((Headers)headers, (String)bodyString);
            responseVo.setCode(code);
            ResponseVo responseVo3 = responseVo;
            return responseVo3;
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to download content from " + url, e);
        }
    }
}

