/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.tio.utils.hex;

public class HexUtils {
    private static final char[] HEX_ARRAY = "0123456789abcdef".toCharArray();

    public static byte[] decodeHex(String hexStr) {
        if (hexStr == null) {
            throw new IllegalArgumentException("Input hex string must not be null");
        }
        int len = hexStr.length();
        if ((len & 1) != 0) {
            throw new IllegalArgumentException("Hex string length must be even: " + hexStr);
        }
        byte[] result = new byte[len / 2];
        for (int i = 0; i < len; i += 2) {
            int high = HexUtils.charToHexDigit(hexStr.charAt(i));
            int low = HexUtils.charToHexDigit(hexStr.charAt(i + 1));
            result[i / 2] = (byte)(high << 4 | low);
        }
        return result;
    }

    public static String encode(byte[] bytes) {
        if (bytes == null) {
            throw new IllegalArgumentException("Input byte array must not be null");
        }
        char[] hexChars = new char[bytes.length * 2];
        for (int j = 0; j < bytes.length; ++j) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = HEX_ARRAY[v >>> 4];
            hexChars[j * 2 + 1] = HEX_ARRAY[v & 0xF];
        }
        return new String(hexChars);
    }

    private static int charToHexDigit(char c) {
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        if (c >= 'A' && c <= 'F') {
            return 10 + (c - 65);
        }
        if (c >= 'a' && c <= 'f') {
            return 10 + (c - 97);
        }
        throw new IllegalArgumentException("Invalid hex character: " + c);
    }
}

