/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.tio.utils.environment;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Prop {
    private static final Logger log = LoggerFactory.getLogger(Prop.class);
    public static final Charset DEFAULT_ENCODING = StandardCharsets.UTF_8;
    protected Properties properties;

    public Prop() {
        this.properties = new Properties();
    }

    public Prop(String fileName) {
        this(fileName, DEFAULT_ENCODING);
    }

    public Prop(String fileName, Charset encoding) {
        encoding.toString();
        InputStream inputStream = null;
        this.properties = new Properties();
        try {
            inputStream = this.getClassLoader().getResourceAsStream(fileName);
            if (inputStream != null) {
                this.properties.load(new InputStreamReader(inputStream, encoding));
            } else {
                File file = new File(fileName);
                if (!file.exists()) {
                    if (file.createNewFile()) {
                        log.info("file created successful\uff1a" + fileName);
                        inputStream = new FileInputStream(file);
                        this.properties.load(new InputStreamReader(inputStream, encoding));
                    } else {
                        log.info("failed to create file" + fileName);
                    }
                } else {
                    log.info("load file\uff1a" + fileName);
                    inputStream = new FileInputStream(file);
                    this.properties.load(new InputStreamReader(inputStream, encoding));
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Error loading properties file.", e);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private ClassLoader getClassLoader() {
        ClassLoader ret = Thread.currentThread().getContextClassLoader();
        return ret != null ? ret : this.getClass().getClassLoader();
    }

    public Prop(File file) {
        this(file, DEFAULT_ENCODING);
    }

    public Prop(File file, Charset encoding) {
        if (file == null) {
            throw new IllegalArgumentException("File can not be null.");
        }
        if (!file.isFile()) {
            throw new IllegalArgumentException("File not found : " + file.getName());
        }
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(file);
            this.properties = new Properties();
            this.properties.load(new InputStreamReader((InputStream)inputStream, encoding));
        }
        catch (IOException e) {
            throw new RuntimeException("Error loading properties file.", e);
        }
        finally {
            if (inputStream != null) {
                try {
                    ((InputStream)inputStream).close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public Prop append(Prop prop) {
        if (prop == null) {
            throw new IllegalArgumentException("prop can not be null");
        }
        this.properties.putAll((Map<?, ?>)prop.getProperties());
        return this;
    }

    public Prop append(String fileName, Charset encoding) {
        return this.append(new Prop(fileName, encoding));
    }

    public Prop append(String fileName) {
        return this.append(fileName, DEFAULT_ENCODING);
    }

    public Prop appendIfExists(String fileName, Charset encoding) {
        try {
            return this.append(new Prop(fileName, encoding));
        }
        catch (Exception e) {
            return this;
        }
    }

    public Prop appendIfExists(String fileName) {
        return this.appendIfExists(fileName, DEFAULT_ENCODING);
    }

    public Prop append(File file, Charset encoding) {
        return this.append(new Prop(file, encoding));
    }

    public Prop append(File file) {
        return this.append(file, DEFAULT_ENCODING);
    }

    public Prop appendIfExists(File file, Charset encoding) {
        if (file.isFile()) {
            this.append(new Prop(file, encoding));
        }
        return this;
    }

    public Prop appendIfExists(File file) {
        return this.appendIfExists(file, DEFAULT_ENCODING);
    }

    public String get(String key) {
        String value = this.properties.getProperty(key);
        return value != null && value.length() != 0 ? value.trim() : null;
    }

    public String get(String key, String defaultValue) {
        String value = this.properties.getProperty(key);
        return value != null && value.length() != 0 ? value.trim() : defaultValue;
    }

    public Integer getInt(String key) {
        return this.getInt(key, null);
    }

    public Integer getInt(String key, Integer defaultValue) {
        String value = this.properties.getProperty(key);
        if (value != null) {
            return Integer.parseInt(value.trim());
        }
        return defaultValue;
    }

    public Long getLong(String key) {
        return this.getLong(key, null);
    }

    public Long getLong(String key, Long defaultValue) {
        String value = this.properties.getProperty(key);
        if (value != null) {
            return Long.parseLong(value.trim());
        }
        return defaultValue;
    }

    public Double getDouble(String key) {
        return this.getDouble(key, null);
    }

    public Double getDouble(String key, Double defaultValue) {
        String value = this.properties.getProperty(key);
        if (value != null) {
            return Double.parseDouble(value.trim());
        }
        return defaultValue;
    }

    public Boolean getBoolean(String key) {
        return this.getBoolean(key, null);
    }

    public Boolean getBoolean(String key, Boolean defaultValue) {
        String value = this.properties.getProperty(key);
        if (value != null) {
            if ("true".equals(value = value.toLowerCase().trim())) {
                return true;
            }
            if ("false".equals(value)) {
                return false;
            }
            throw new RuntimeException("The value can not parse to Boolean : " + value);
        }
        return defaultValue;
    }

    public boolean containsKey(String key) {
        return this.properties.containsKey(key);
    }

    public boolean isEmpty() {
        return this.properties.isEmpty();
    }

    public boolean notEmpty() {
        return !this.properties.isEmpty();
    }

    public Properties getProperties() {
        return this.properties;
    }
}

