/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.tio.utils.date;

import com.litongjava.tio.utils.map.SyncWriteMap;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class TioTimeUtils {
    private static final Map<String, DateTimeFormatter> formaters = new SyncWriteMap<String, DateTimeFormatter>();
    private static final ThreadLocal<HashMap<String, SimpleDateFormat>> TL = ThreadLocal.withInitial(() -> new HashMap());

    public static SimpleDateFormat getSimpleDateFormat(String pattern) {
        SimpleDateFormat ret = TL.get().get(pattern);
        if (ret == null) {
            ret = new SimpleDateFormat(pattern);
            TL.get().put(pattern, ret);
        }
        return ret;
    }

    public static String format(Date date) {
        return TioTimeUtils.format(date, "yyyy-MM-dd HH:mm:ss");
    }

    public static String format(Date date, String pattern) {
        return TioTimeUtils.getSimpleDateFormat(pattern).format(date);
    }

    public static String format(LocalDate localDate, String pattern) {
        return localDate.format(TioTimeUtils.getDateTimeFormatter(pattern));
    }

    public static DateTimeFormatter getDateTimeFormatter(String pattern) {
        DateTimeFormatter ret = formaters.get(pattern);
        if (ret == null) {
            ret = DateTimeFormatter.ofPattern(pattern);
            formaters.put(pattern, ret);
        }
        return ret;
    }

    public static String format(LocalDateTime localDateTime, String pattern) {
        return localDateTime.format(TioTimeUtils.getDateTimeFormatter(pattern));
    }

    public static String format(LocalTime localTime, String pattern) {
        return localTime.format(TioTimeUtils.getDateTimeFormatter(pattern));
    }

    public static Date toDate(LocalDateTime localDateTime) {
        ZoneId zone = ZoneId.systemDefault();
        Instant instant = localDateTime.atZone(zone).toInstant();
        return Date.from(instant);
    }
}

