/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.tio.utils.commandline;

import com.litongjava.tio.utils.commandline.ProcessResult;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessUtils {
    private static final Logger log = LoggerFactory.getLogger(ProcessUtils.class);

    public static ProcessResult execute(File outDir, ProcessBuilder pb) throws IOException, InterruptedException {
        if (outDir != null && !outDir.exists()) {
            outDir.mkdirs();
        }
        File stdoutFile = new File(outDir, "stdout.log");
        File stderrFile = new File(outDir, "stderr.log");
        pb.redirectOutput(stdoutFile);
        pb.redirectError(stderrFile);
        Process process = pb.start();
        int exitCode = process.waitFor();
        String stdoutContent = new String(Files.readAllBytes(stdoutFile.toPath()), StandardCharsets.UTF_8);
        String stderrContent = new String(Files.readAllBytes(stderrFile.toPath()), StandardCharsets.UTF_8);
        ProcessResult result = new ProcessResult();
        result.setExitCode(exitCode);
        result.setStdOut(stdoutContent);
        result.setStdErr(stderrContent);
        return result;
    }

    public static ProcessResult execute(File outDir, ProcessBuilder pb, int timeout) throws IOException, InterruptedException {
        int exitCode;
        if (outDir != null && !outDir.exists()) {
            outDir.mkdirs();
        }
        File stdoutFile = new File(outDir, "stdout.log");
        File stderrFile = new File(outDir, "stderr.log");
        pb.redirectOutput(stdoutFile);
        pb.redirectError(stderrFile);
        Process process = pb.start();
        boolean finished = process.waitFor(timeout, TimeUnit.SECONDS);
        if (!finished) {
            log.error("process did not respond within 120 seconds. Forcibly terminating...");
            process.destroyForcibly();
            exitCode = -1;
        } else {
            exitCode = process.exitValue();
        }
        String stdoutContent = new String(Files.readAllBytes(stdoutFile.toPath()), StandardCharsets.UTF_8);
        String stderrContent = new String(Files.readAllBytes(stderrFile.toPath()), StandardCharsets.UTF_8);
        ProcessResult result = new ProcessResult();
        result.setExitCode(exitCode);
        result.setStdOut(stdoutContent);
        result.setStdErr(stderrContent);
        return result;
    }
}

