/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.tio.utils.cache.redismap;

import com.litongjava.tio.utils.cache.AbsCache;
import com.litongjava.tio.utils.cache.CacheFactory;
import com.litongjava.tio.utils.cache.CacheName;
import com.litongjava.tio.utils.cache.CacheRemovalListener;
import com.litongjava.tio.utils.cache.RemovalListenerWrapper;
import com.litongjava.tio.utils.cache.redismap.RedisMapCache;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;

public enum RedisMapCacheFactory implements CacheFactory
{
    INSTANCE;

    private final Map<String, RedisMapCache> map = new ConcurrentHashMap<String, RedisMapCache>();

    @Override
    public RedisMapCache register(String cacheName, Long timeToLiveSeconds, Long timeToIdleSeconds) {
        return this.register(cacheName, timeToLiveSeconds, timeToIdleSeconds, (RemovalListenerWrapper)null);
    }

    @Override
    public <T> RedisMapCache register(String cacheName, Long timeToLiveSeconds, Long timeToIdleSeconds, RemovalListenerWrapper<T> removalListenerWrapper) {
        CacheRemovalListener listener = null;
        if (removalListenerWrapper != null && removalListenerWrapper.getListener() instanceof CacheRemovalListener) {
            listener = (CacheRemovalListener)removalListenerWrapper.getListener();
        }
        CacheRemovalListener thatListener = listener;
        Function<String, RedisMapCache> mappingFunction = k -> {
            RedisMapCache redisMapCache = new RedisMapCache((String)k, timeToLiveSeconds, timeToIdleSeconds, thatListener);
            return redisMapCache;
        };
        return this.map.computeIfAbsent(cacheName, mappingFunction);
    }

    @Override
    public RedisMapCache getCache(String cacheName, boolean skipNull) {
        RedisMapCache cache = this.map.get(cacheName);
        if (cache == null && !skipNull) {
            throw new IllegalArgumentException("Cache with name " + cacheName + " does not exist.");
        }
        return cache;
    }

    @Override
    public RedisMapCache getCache(String cacheName) {
        return this.getCache(cacheName, true);
    }

    @Override
    public Map<String, ? extends AbsCache> getMap() {
        return this.map;
    }

    @Override
    public RedisMapCache register(CacheName cacheName) {
        return this.register(cacheName.getName(), cacheName.getTimeToLiveSeconds(), cacheName.getTimeToIdleSeconds(), (RemovalListenerWrapper)null);
    }
}

