/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.tio.utils.cache.redismap;

import com.litongjava.tio.utils.cache.AbsCache;
import com.litongjava.tio.utils.cache.CacheRemovalListener;
import com.litongjava.tio.utils.cache.RemovalCause;
import com.litongjava.tio.utils.cache.redismap.JedisPoolCan;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPubSub;
import redis.clients.jedis.params.SetParams;

public class RedisMapCache
extends AbsCache {
    private CacheRemovalListener<String, Serializable> removalListener;
    private final String namespace;
    private static final String KEYSPACE_EXPIRED_CHANNEL = "__keyevent@0__:expired";

    public RedisMapCache(String cacheName, Long timeToLiveSeconds, Long timeToIdleSeconds, CacheRemovalListener<String, Serializable> removalListener) {
        super(cacheName, timeToLiveSeconds, timeToIdleSeconds);
        this.removalListener = removalListener;
        this.namespace = "tio_cache:" + cacheName + ":";
        if (removalListener != null) {
            new Thread(new ExpiredKeyListener()).start();
        }
    }

    private String getRedisKey(String key) {
        return this.namespace + key;
    }

    public void clear() {
        try (Jedis jedis = JedisPoolCan.jedisPool.getResource();){
            Set keys = jedis.keys(this.namespace + "*");
            if (!keys.isEmpty()) {
                jedis.del(keys.toArray(new String[0]));
            }
        }
    }

    @Override
    public Serializable _get(String key) {
        try (Jedis jedis = JedisPoolCan.jedisPool.getResource();){
            String redisKey = this.getRedisKey(key);
            byte[] data = jedis.get(redisKey.getBytes());
            if (data != null) {
                Serializable value = this.deserialize(data);
                if (this.getTimeToIdleSeconds() != null) {
                    jedis.expire(redisKey, (long)this.getTimeToIdleSeconds().intValue());
                }
                Serializable serializable = value;
                return serializable;
            }
            Serializable serializable = null;
            return serializable;
        }
    }

    public Iterable<String> keys() {
        try (Jedis jedis = JedisPoolCan.jedisPool.getResource();){
            Set keys = jedis.keys(this.namespace + "*");
            Iterable iterable = keys.stream().map(k -> k.substring(this.namespace.length())).collect(Collectors.toList());
            return iterable;
        }
    }

    public Collection<String> keysCollection() {
        try (Jedis jedis = JedisPoolCan.jedisPool.getResource();){
            Set keys = jedis.keys(this.namespace + "*");
            Collection collection = keys.stream().map(k -> k.substring(this.namespace.length())).collect(Collectors.toList());
            return collection;
        }
    }

    public void put(String key, Serializable value) {
        this.put(key, value, this.getTimeToLiveSeconds());
    }

    public void put(String key, Serializable value, int ttlSeconds) {
        this.put(key, value, Long.valueOf(ttlSeconds));
    }

    public void put(String key, Serializable value, Long ttlSeconds) {
        try (Jedis jedis = JedisPoolCan.jedisPool.getResource();){
            String redisKey = this.getRedisKey(key);
            byte[] serializedValue = this.serialize(value);
            SetParams params = new SetParams();
            if (ttlSeconds != null) {
                params.ex(ttlSeconds.longValue());
            }
            if (this.getTimeToIdleSeconds() != null) {
                if (ttlSeconds != null) {
                    params.ex((long)((int)Math.min(ttlSeconds, this.getTimeToIdleSeconds())));
                } else {
                    params.ex(this.getTimeToIdleSeconds().longValue());
                }
            }
            jedis.set(redisKey.getBytes(), serializedValue, params);
        }
    }

    public void remove(String key) {
        try (Jedis jedis = JedisPoolCan.jedisPool.getResource();){
            String redisKey = this.getRedisKey(key);
            byte[] data = jedis.get(redisKey.getBytes());
            if (data != null) {
                Serializable value = this.deserialize(data);
                jedis.del(redisKey);
                if (this.removalListener != null) {
                    this.removalListener.onCacheRemoval(key, value, RemovalCause.EXPLICIT);
                }
            }
        }
    }

    public void putTemporary(String key, Serializable value) {
        this.put(key, value, 600);
    }

    public long ttl(String key) {
        try (Jedis jedis = JedisPoolCan.jedisPool.getResource();){
            String redisKey = this.getRedisKey(key);
            Long ttl = jedis.ttl(redisKey);
            long l = ttl != null && ttl > 0L ? ttl : -1L;
            return l;
        }
    }

    public Map<String, Serializable> asMap() {
        try (Jedis jedis = JedisPoolCan.jedisPool.getResource();){
            Set keys = jedis.keys(this.namespace + "*");
            HashMap<String, Serializable> map = new HashMap<String, Serializable>();
            for (String redisKey : keys) {
                byte[] data = jedis.get(redisKey.getBytes());
                if (data == null) continue;
                Serializable value = this.deserialize(data);
                String key = redisKey.substring(this.namespace.length());
                map.put(key, value);
            }
            HashMap<String, Serializable> hashMap = map;
            return hashMap;
        }
    }

    public long size() {
        try (Jedis jedis = JedisPoolCan.jedisPool.getResource();){
            Set keys = jedis.keys(this.namespace + "*");
            long l = keys.size();
            return l;
        }
    }

    /*
     * Exception decompiling
     */
    private byte[] serialize(Serializable obj) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    private Serializable deserialize(byte[] data) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private class ExpiredKeyListener
    implements Runnable {
        private ExpiredKeyListener() {
        }

        @Override
        public void run() {
            try (Jedis jedis = JedisPoolCan.jedisPool.getResource();){
                jedis.psubscribe(new JedisPubSub(){

                    public void onPMessage(String pattern, String channel, String message) {
                        if (message.startsWith(RedisMapCache.this.namespace)) {
                            String key = message.substring(RedisMapCache.this.namespace.length());
                            if (RedisMapCache.this.removalListener != null) {
                                RedisMapCache.this.removalListener.onCacheRemoval(key, null, RemovalCause.EXPIRED);
                            }
                        }
                    }
                }, new String[]{RedisMapCache.KEYSPACE_EXPIRED_CHANNEL});
            }
        }
    }
}

