/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.tio.http.server.util;

import com.litongjava.aio.Packet;
import com.litongjava.tio.core.ChannelContext;
import com.litongjava.tio.core.Tio;
import com.litongjava.tio.http.common.encoder.ChunkEncoder;
import com.litongjava.tio.http.common.sse.ChunkedPacket;
import java.nio.charset.StandardCharsets;

public class SseEmitter {
    public static String LFLF = "\n\n";

    public static void pushSSEChunk(ChannelContext channelContext, String string) {
        String text = "data:" + string + LFLF;
        byte[] bytes = text.getBytes();
        ChunkedPacket ssePacket = new ChunkedPacket(ChunkEncoder.encodeChunk((byte[])bytes));
        Tio.bSend((ChannelContext)channelContext, (Packet)ssePacket);
    }

    public static void pushSSEChunk(ChannelContext channelContext, String event, String data) {
        StringBuilder sb = new StringBuilder();
        if (event != null) {
            sb.append("event:").append(event).append("\n");
        }
        sb.append("data:").append(data).append(LFLF);
        byte[] bytes = sb.toString().getBytes(StandardCharsets.UTF_8);
        ChunkedPacket ssePacket = new ChunkedPacket(ChunkEncoder.encodeChunk((byte[])bytes));
        Tio.bSend((ChannelContext)channelContext, (Packet)ssePacket);
    }

    public static void pushChunk(ChannelContext channelContext, byte[] bytes) {
        ChunkedPacket ssePacket = new ChunkedPacket(ChunkEncoder.encodeChunk((byte[])bytes));
        Tio.bSend((ChannelContext)channelContext, (Packet)ssePacket);
    }

    public static void closeSeeConnection(ChannelContext channelContext) {
        try {
            Thread.sleep(1000L);
            Tio.remove((ChannelContext)channelContext, (String)"remove");
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public static void closeChunkConnection(ChannelContext channelContext) {
        byte[] zeroChunk = ChunkEncoder.encodeChunk((byte[])new byte[0]);
        ChunkedPacket endPacket = new ChunkedPacket(zeroChunk);
        Tio.bSend((ChannelContext)channelContext, (Packet)endPacket);
        try {
            Thread.sleep(1000L);
            Tio.remove((ChannelContext)channelContext, (String)"remove");
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }
}

