/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.tio.http.server.stat.token;

import com.litongjava.tio.core.TioConfig;
import com.litongjava.tio.http.server.intf.CurrUseridGetter;
import com.litongjava.tio.http.server.stat.DefaultStatPathFilter;
import com.litongjava.tio.http.server.stat.StatPathFilter;
import com.litongjava.tio.http.server.stat.token.DefaultTokenGetter;
import com.litongjava.tio.http.server.stat.token.TokenAccessStat;
import com.litongjava.tio.http.server.stat.token.TokenGetter;
import com.litongjava.tio.http.server.stat.token.TokenPathAccessStatListener;
import com.litongjava.tio.utils.cache.AbsCache;
import com.litongjava.tio.utils.cache.CacheFactory;
import com.litongjava.tio.utils.cache.RemovalListenerWrapper;
import com.litongjava.tio.utils.hutool.StrUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TokenPathAccessStats {
    private static Logger log = LoggerFactory.getLogger(TokenPathAccessStats.class);
    private static final String CACHE_NAME = "TIO_TOKEN_ACCESSPATH";
    private TioConfig tioConfig;
    private String tioConfigId;
    private StatPathFilter statPathFilter;
    public final Map<Long, AbsCache> cacheMap = new HashMap<Long, AbsCache>();
    public final List<Long> durationList = new ArrayList<Long>();
    private final Map<Long, TokenPathAccessStatListener> listenerMap = new HashMap<Long, TokenPathAccessStatListener>();
    private TokenGetter tokenGetter;
    private CurrUseridGetter currUseridGetter;

    public TokenPathAccessStats(StatPathFilter statPathFilter, TokenGetter tokenGetter, CurrUseridGetter currUseridGetter, TioConfig tioConfig, TokenPathAccessStatListener tokenPathAccessStatListener, Long[] durations, RemovalListenerWrapper<?> removalListenerWrapper) {
        this.statPathFilter = statPathFilter;
        if (this.statPathFilter == null) {
            this.statPathFilter = DefaultStatPathFilter.me;
        }
        if (tokenGetter == null) {
            throw new RuntimeException("tokenGetter can not be null");
        }
        this.tokenGetter = tokenGetter;
        this.currUseridGetter = currUseridGetter;
        this.tioConfig = tioConfig;
        this.tioConfigId = tioConfig.getId();
        if (durations != null) {
            for (Long duration : durations) {
                this.addDuration(duration, tokenPathAccessStatListener, removalListenerWrapper);
            }
        }
    }

    public TokenPathAccessStats(StatPathFilter statPathFilter, CurrUseridGetter currUseridGetter, TioConfig tioConfig, TokenPathAccessStatListener tokenPathAccessStatListener, Long[] durations, RemovalListenerWrapper<?> removalListenerWrapper) {
        this(statPathFilter, DefaultTokenGetter.me, currUseridGetter, tioConfig, tokenPathAccessStatListener, durations, removalListenerWrapper);
    }

    public void addDuration(Long duration, TokenPathAccessStatListener tokenPathAccessStatListener, RemovalListenerWrapper<?> removalListenerWrapper) {
        CacheFactory cacheFactory = this.tioConfig.getCacheFactory();
        AbsCache absCache = cacheFactory.register(this.getCacheName(duration), duration, null, removalListenerWrapper);
        this.cacheMap.put(duration, absCache);
        this.durationList.add(duration);
        if (tokenPathAccessStatListener != null) {
            this.listenerMap.put(duration, tokenPathAccessStatListener);
        }
    }

    public TokenPathAccessStatListener getListener(Long duration) {
        return this.listenerMap.get(duration);
    }

    public void addDurations(Long[] durations, TokenPathAccessStatListener tokenPathAccessStatListener, RemovalListenerWrapper<?> removalListenerWrapper) {
        if (durations != null) {
            for (Long duration : durations) {
                this.addDuration(duration, tokenPathAccessStatListener, removalListenerWrapper);
            }
        }
    }

    public void removeMonitor(Long duration) {
        this.clear(duration);
        this.cacheMap.remove(duration);
        this.durationList.remove(duration);
    }

    public String getCacheName(Long duration) {
        String cacheName = "TIO_TOKEN_ACCESSPATH_" + this.tioConfigId + "_";
        return cacheName + duration;
    }

    public void clear(Long duration) {
        AbsCache caffeineCache = this.cacheMap.get(duration);
        if (caffeineCache == null) {
            return;
        }
        caffeineCache.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TokenAccessStat get(Long duration, String token, String ip, String uid, boolean forceCreate) {
        if (StrUtil.isBlank((String)token)) {
            return null;
        }
        AbsCache caffeineCache = this.cacheMap.get(duration);
        if (caffeineCache == null) {
            return null;
        }
        TokenAccessStat tokenAccessStat = (TokenAccessStat)caffeineCache.get(token);
        if (tokenAccessStat == null && forceCreate) {
            AbsCache absCache = caffeineCache;
            synchronized (absCache) {
                tokenAccessStat = (TokenAccessStat)caffeineCache.get(token);
                if (tokenAccessStat == null) {
                    tokenAccessStat = new TokenAccessStat(duration, token, ip, uid);
                    caffeineCache.put(token, (Serializable)tokenAccessStat);
                }
            }
        }
        return tokenAccessStat;
    }

    public TokenAccessStat get(Long duration, String token, String ip, String uid) {
        return this.get(duration, token, ip, uid, true);
    }

    public Map<String, Serializable> map(Long duration) {
        AbsCache caffeineCache = this.cacheMap.get(duration);
        if (caffeineCache == null) {
            return null;
        }
        Map map = caffeineCache.asMap();
        return map;
    }

    public Long size(Long duration) {
        AbsCache caffeineCache = this.cacheMap.get(duration);
        if (caffeineCache == null) {
            return null;
        }
        return caffeineCache.size();
    }

    public Collection<Serializable> values(Long duration) {
        AbsCache caffeineCache = this.cacheMap.get(duration);
        if (caffeineCache == null) {
            return null;
        }
        Collection<Serializable> set = caffeineCache.asMap().values();
        return set;
    }

    public TokenGetter getTokenGetter() {
        return this.tokenGetter;
    }

    public CurrUseridGetter getCurrUseridGetter() {
        return this.currUseridGetter;
    }

    public void setCurrUseridGetter(CurrUseridGetter currUseridGetter) {
        this.currUseridGetter = currUseridGetter;
    }

    public StatPathFilter getStatPathFilter() {
        return this.statPathFilter;
    }

    public void setStatPathFilter(StatPathFilter statPathFilter) {
        this.statPathFilter = statPathFilter;
    }
}

