/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.tio.http.server.router;

import com.litongjava.model.type.TioTypeReference;
import com.litongjava.tio.http.server.handler.IHttpRequestFunction;
import com.litongjava.tio.http.server.handler.RouteEntry;
import com.litongjava.tio.http.server.router.HttpRequestFunctionRouter;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class DefaultHttpRequestFunctionRouter
implements HttpRequestFunctionRouter {
    private final Map<String, RouteEntry<?, ?>> requestMapping = new ConcurrentHashMap();

    @Override
    public <R, T> void add(String path, IHttpRequestFunction<R, T> function, TioTypeReference<T> typeReference) {
        this.requestMapping.put(path, new RouteEntry<R, T>(function, typeReference));
    }

    @Override
    public <R, T> RouteEntry<R, T> find(String path) {
        RouteEntry<?, ?> entry = this.requestMapping.get(path);
        if (entry != null) {
            try {
                return entry;
            }
            catch (ClassCastException e) {
                throw new IllegalArgumentException("Function type mismatch for path: " + path, e);
            }
        }
        Set<Map.Entry<String, RouteEntry<?, ?>>> entrySet = this.requestMapping.entrySet();
        for (Map.Entry<String, RouteEntry<?, ?>> mapEntry : entrySet) {
            String baseRoute;
            String key = mapEntry.getKey();
            if (!(key.endsWith("/*") ? path.startsWith(baseRoute = key.substring(0, key.length() - 1)) : key.endsWith("/**") && path.startsWith(baseRoute = key.substring(0, key.length() - 2)))) continue;
            return mapEntry.getValue();
        }
        return null;
    }
}

